<?php
class Targets extends stock
{

	public function __construct()
	{
		$this->CI =& get_instance();
	}

	#-------------------------------------------------------------------------------

	public function get_points($conditions)
	{
		$conditions['up.status'] = 1;
		$this->CI->db->select_sum('sms_point');
		$this->CI->db->from('user_points as up');
		$this->CI->db->join('dms_sms as ds','ds.bill_ref_no=up.group_id');
		$this->CI->db->where($conditions);
		
		$row = $this->CI->db->get()->row_array();

		if($row['sms_point'] != NULL){
			return $row['sms_point'];
		}
		return 0;
	}

	#-------------------------------------------------------------------------------

	public function get_targets($args = array())
	{
		if(!isset($args['columns'])){
			$args['columns'] = array('a.id','a.target_type','b.qty','b.unit_id','b.amount','b.points');
		}
		if(!isset($args['bill_date'])){
			$args['bill_date'] = date('Y-m-d');
		}
		$this->CI->db->select($args['columns'])->from('targets as a')->join('target_items as b','a.id = b.targets_id')->where($args['conditions']);
		$this->CI->db->where("'$args[bill_date]' between valid_from and valid_to",NULL,false);
		$this->CI->db->where(array('a.status' => 1,'b.status' => 1));
		$row = $this->CI->db->get()->row_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	#-------------------------------------------------------------------------------
	#to get points acheived for a single bill
	public function get_bill_points($desig_id,$user_id,$item_id,$unit_id,$qty,$rate,$bill_date)
	{
		$item_details = $this->get_item($item_id,array('item_group_id'));
		$item_group_id = $item_details['item_group_id'];
		$stock_array = array();$max_points = 0;
		$bill_date = date('Y-m-d',strtotime($bill_date));
		$target_details = $this->get_targets(array('conditions' => array('designation_id' => $desig_id,'user_id' => $user_id,'item_group_id' => $item_group_id),'bill_date' => $bill_date));
		if(!empty($target_details))
		{
			$point = $target_details['points'];
			if($target_details['target_type'] == 0)
			{
				$convert_unit = $target_details['unit_id'];
				if($convert_unit == $unit_id)
				{
					$stock_array['qty'] = $qty;
					$stock_array['rate'] = $rate;
				}
				else
				{
					$convert_qty = $qty;$convert_rate = $rate;
					$row = $this->get_item($item_id,array('unit_id','alt_unit_id','unit_conversion','alt_unit_conversion'));
					if($row['unit_id'] == $convert_unit && $row['alt_unit_id'] == $unit_id){
						$stock_array = $stock_array + $this->alternate_unit_convert($row['alt_unit_conversion'],$row['unit_conversion'],$qty,$rate);
					}
					else
					{
						$second_unit_array = $this->get_second_units($convert_unit,1);
						if(array_key_exists($unit_id,$second_unit_array))
						{
							$position = array_search($unit_id,array_keys($second_unit_array));
							$array_keys = array_keys($second_unit_array);
							for($i=$position;$i>=0;$i--)
							{
								if($i == 0){
									$previous_key = $convert_unit;
									if($array_keys[$i] == $row['alt_unit_id']){
										$result = $this->alternate_unit_convert($row['alt_unit_conversion'],$row['unit_conversion'],$convert_qty,$convert_rate);
									}
									else{
										$current_key = $array_keys[$i];
										$result = $this->get_converted_qty($previous_key,$current_key,$convert_qty,1,$convert_rate);
									}
								}
								else{
									$previous_key = $array_keys[$i-1];
									$current_key = $array_keys[$i];
									$result = $this->get_converted_qty($previous_key,$current_key,$convert_qty,1,$convert_rate);
								}
								$convert_qty = $result['qty'];
								$convert_rate = $result['rate'];
							}
						}
						else
						{
							$first_unit_array = $this->get_first_units($convert_unit,1);
							$position = array_search($unit_id,array_keys($first_unit_array));
							$array_keys = array_keys($first_unit_array);
							for($i=$position;$i>=0;$i--)
							{
								if($i == 0){
									$previous_key = $convert_unit;
									if($array_keys[$i] == $row['alt_unit_id']){
										$result = $this->alternate_unit_convert($row['alt_unit_conversion'],$row['unit_conversion'],$convert_qty,$convert_rate);
									}
									else
									{
										$current_key = $array_keys[$i];
										$result = $this->get_converted_qty($current_key,$previous_key,$convert_qty,2,$convert_rate);
									}
								}
								else{
									$previous_key = $array_keys[$i-1];
									$current_key = $array_keys[$i];
									$result = $this->get_converted_qty($current_key,$previous_key,$convert_qty,2,$convert_rate);
								}
								$convert_qty = $result['qty'];
								$convert_rate = $result['rate'];
							}
						}
						$stock_array['qty'] = round_this($convert_qty);
						$stock_array['rate'] = round_this($convert_rate);
					}
				}
				$max_points = ($stock_array['qty']/$target_details['qty'])*$point;
			}
			else
			{
				$target_amount = $target_details['amount'];
				$max_points = (($qty*$rate)/$target_amount)*$point;
			}
		}
		return $max_points;
	}

	#-------------------------------------------------------------------------------

	public function get_message($targets_id,$points)
	{
		$row = $this->CI->db->select(array('id','gift_name'))->from('target_achievements')->where(array('company_id' => $this->CI->session->userdata('company_id'),'point <=' => $points,'status'=>1))->order_by('point','desc')->limit(1)->get()->row_array();
		if(!empty($row))
		{
			$row1 = $this->CI->db->select('id')->get_where('dms_user_achievements',array('targets_id' => $targets_id,'ta_id' => $row['id']))->row_array();
			if(!empty($row1))
			{
				return "Congrats...Your total achievement is ".$points." points.";
			}
			else
			{
				$this->CI->db->insert('dms_user_achievements',array('targets_id' => $targets_id,'ta_id' => $row['id'],'status' => 1,'created_by' => $this->CI->session->userdata('id'),'created_on' => date('Y-m-d H:i:s')));
				return "Congrats...Your total achievement is ".$points." points.You will get ".$row['gift_name']." as a compliment.";
			}
		}
		else
		{
			return "Congrats...Your total achievement is ".$points." points.";
		}
	}
}
