<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Menu_model extends CI_Model{

		#------------------------------------------------

		public function list_menus($args = array()){

			#all menu groups
			$this->db->select(array('id','menu_group'))->from('menu_master');
			if(isset($agrs['conditions'])){
				$this->db->where($agrs['conditions']);
			}
			if(isset($agrs['like'])){
				$this->db->like($agrs['like']);
			}
			$menu_groups = $this->db->group_by('menu_group')->get()->result_array();
			#groups
			$groups = array();
			#loop it to get its menu icons
			foreach($menu_groups as $group){
				
				$this->db->from('menu_master')->where('menu_group',$group['menu_group']);
				$this->db->where('menu_controller !=','#');
				$menus = $this->db->order_by('menu_order')->get()->result_array();
				if(!empty($menus)){
					foreach($menus as $menu){
						$groups[$group['menu_group']][] = array('id'=>$menu['id'],'menu_name'=>$menu['menu_name']);
					}
				}
			}
			return $groups;		
		}

		#------------------------------------------------

		public function users_menu($user_id){
			$rows = $this->db->select('menu_id')->get_where('user_privileges',array('owner_id'=>$user_id,'user_group'=>'individual'))->result_array();
			$menus = array();
			foreach($rows as $row){
				$menus[] = $row['menu_id'];
			}
			return $menus;
		}

		#-------------------------------------------------

		public function menu_name($id){
			$row = $this->db->select('menu_name')->get_where('menu_master',array('id'=>$id))->row_array();
			return $row['menu_name'];
		}
		#------------------------------------------------

		public function get_menus($args = array()){

			$this->db->select(array('id','menu_name','menu_title','menu_order'));
			$this->db->from('menu_master');

			if(isset($args['conditions'])){
			if($args['conditions']['menu_parent'] != 0)	
				$args['conditions']['menu_group !='] = 'settings-dashboard';	
				$this->db->where($args['conditions']);
			}
			
			if(isset($args['like'])){
				$this->db->like($args['like']);
			}
			
			if(isset($args['order_by'])){ 
				if(!isset($args['order'])){	$args['order'] = 'asc'; }
				$this->db->order_by($args['order_by'],$args['order']);
			}else{
				$this->db->order_by('menu_order','asc');
			}
			return $this->db->get()->result_array();
		}

		#--------------------------------------------------

		public function get_user_menus($args = array()){

			$this->db->select(array('up.menu_id','mm.id','mm.menu_name','mm.menu_title','mm.menu_order'));
			$this->db->from('user_privileges up');
			$this->db->join('menu_master mm','up.menu_id = mm.id','left');
			$this->db->where('owner_id',$this->session->userdata('id'));
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			
			if(isset($args['like'])){
				$this->db->like($args['like']);
			}
			if(isset($args['order_by'])){ 
				if(!isset($args['order'])){ $args['order'] = 'asc'; }
				$this->db->order_by($args['order_by'],$args['order']);
			}else{
				$this->db->order_by('menu_order','asc');
			}						
			return $this->db->get()->result_array();

		}	
	    #--------------------------------------------------
	}
?>