<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Account_groups_model extends MY_Model
{	
	public function get_primary_groups($args = array())
	{				
		$this->db->select(array('id','primary_group','dc'))->from('account_primary_groups');
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}
		$row = $this->db->get()->result_array();
		if(isset($args['select']))
		{
			$data = array();
			$data[""] = "select";
			foreach($row as $key => $value){
				$data[$value['id']] = $value['primary_group'];
			}
			return $data;
		}
		return $row;
	}
	
	public function get_sub_group($args = array())
	{
		$company_id = $this->session->userdata('company_id');
		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.primary_group','b.id','b.primary_group_id','b.sub_group','b.dc','b.company_id');	
		}			
		$this->db->select($args['columns'])->from('account_primary_groups as a')->join('account_sub_groups as b','a.id = b.primary_group_id','inner')->where("(b.company_id = $company_id or b.company_id = 0) and b.status = 1");
		$row = $this->db->get()->result_array();
		if(isset($args['select']))
		{
			$data = array();
			$data[""] = "select";
			foreach($row as $key => $value)
			{
				$data[$value['primary_group']][$value['id']] = $value['sub_group'];
			}
			return $data;
		}
		return $row;
	}
	
	public function insert($data)	
	{
		$data['company_id'] = $this->session->userdata('company_id');
		$this->db->select('dc')->from('account_primary_groups')->where('id',$data['primary_group_id']);
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			$data['dc'] = $row['dc'];
			if($this->f_save("account_sub_groups",$data)){
				return true;
			}
			return false;
		}
		return false;
	}
	
	public function get_data($id = NULL)
	{
		$this->db->select(array('id','company_id','primary_group_id','sub_group'))->from('account_sub_groups')->where('id',$id);
		$row = $this->db->get()->row_array();
		if(!empty($row)){
			return $row;
		}
		return false;						
	}
	
	public function update($args = array())
	{
		$this->db->select('id')->from('account_sub_groups')->where(array('company_id' => $this->session->userdata('company_id'),'id' => $args['conditions']['id']));
		$row = $this->db->get()->row_array();		
		if(!empty($row))
		{
			$this->my_update("account_sub_groups",$args['data'],$args['conditions']);
			return true;
		}
	}

	public function check_account_group($sgroup_id)
	{
		return $this->db->from('dms_ledgers')->where(array('sgroup_id' => $sgroup_id,'status' => 1))->count_all_results();		
	}
}