<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vat_model extends MY_Model
{
	public function get($args = array())
	{
		$args['conditions']['company_id'] = $this->session->userdata('company_id');
		$args['conditions']['fiscal_yr_id'] = $this->session->userdata('fiscal_yr_id');				
		$this->db->select(array('id','item_type'))->from('item_type_master')->where(array('status'=>1,'company_id'=>$this->session->userdata('company_id')))->order_by('item_type');
		$row = $this->db->get()->result_array();
		foreach($row as $items => $item_details)
		{
			$vat_percent = $this->get_item_vat($item_details['id']);
			$row[$items]['vat_percent'] = $vat_percent;
		}
		return $row;
	}

        public function get_gst($args = array())
	{
		$args['conditions']['company_id'] = $this->session->userdata('company_id');
		$args['conditions']['fiscal_yr_id'] = $this->session->userdata('fiscal_yr_id');				
		$this->db->select(array('id','item_type'))->from('item_type_master')->where(array('status'=>1,'company_id'=>$this->session->userdata('company_id')))->order_by('item_type');
		$row = $this->db->get()->result_array();
		foreach($row as $items => $item_details)
		{
			$cgst = $this->get_item_cgst($item_details['id']);
                        $sgst = $this->get_item_sgst($item_details['id']);
			$row[$items]['cgst'] = $cgst;
                        $row[$items]['sgst'] = $sgst;
		}
		return $row;
	}
	
	public function get_item_vat($item_grp_id)
	{
		$this->db->select('a.vat_percent')->from('tax_master as a')->join('fiscal_year_master as b','a.fiscal_yr_id=b.id')->where(array('a.company_id' => $this->session->userdata('company_id'),'a.item_grp_id' => $item_grp_id,'fiscal_yr_id <= ' => $this->session->userdata('fiscal_yr_id')))->order_by('fiscal_order','DESC')->limit(1);
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			return $row['vat_percent'];
		}
		return false;
	}
     
        public function get_item_cgst($item_grp_id)
	{
	    $branch_id = $this->session->userdata('under_id');
	  	$this->db->select('a.cgst')->from('gst_master as a')->join('fiscal_year_master as b','a.fiscal_yr_id=b.id')->where(array('a.item_grp_id' => $item_grp_id,'a.branch_id'=>$this->session->userdata('under_id'),'fiscal_yr_id <='  => $this->session->userdata('fiscal_yr_id')))->order_by('fiscal_order','DESC')->limit(1);
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			return $row['cgst'];
		}
           return false;
	}

        public function get_item_sgst($item_grp_id)
	{
		$this->db->select('a.sgst')->from('gst_master as a')->join('fiscal_year_master as b','a.fiscal_yr_id=b.id')->where(array('a.item_grp_id' => $item_grp_id,'a.branch_id'=>$this->session->userdata('under_id'),'fiscal_yr_id <= ' => $this->session->userdata('fiscal_yr_id')))->order_by('fiscal_order','DESC')->limit(1);
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			return $row['sgst'];
		}
		return false;
	}

    public function get_item_igst($item_grp_id)
	{
		$this->db->select('a.igst')->from('igst_master as a')->join('fiscal_year_master as b','a.fiscal_yr_id=b.id')->where(array('a.item_grp_id' => $item_grp_id,'fiscal_yr_id <= ' => $this->session->userdata('fiscal_yr_id')))->order_by('fiscal_order','DESC')->limit(1);
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			return $row['igst'];
		}
		return false;
	}

	public function update($data)
	{
		$data['company_id'] = $this->session->userdata('company_id');
		$data['fiscal_yr_id'] = $this->session->userdata('fiscal_yr_id');
		$this->db->select('id')->from('tax_master')->where(array('company_id' => $data['company_id'],'fiscal_yr_id' => $data['fiscal_yr_id'],'item_grp_id' => $data['item_grp_id']));
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			$result=$this->my_update("tax_master",array('vat_percent' => $data['vat_percent']),array('id' => $row['id']));
		}
		else
		{			
			$result=$this->f_save("tax_master",$data);
		}
		return $result;
	}

    public function updates($data)
	{
		$company_id = $this->session->userdata('company_id');
		$branch_id = $this->session->userdata('under_id');
		$fiscal_yr_id = $this->session->userdata('fiscal_yr_id');
		$this->db->select('id')->from('gst_master')->where(array('company_id' => $company_id,'branch_id'=>$branch_id,'fiscal_yr_id' => $fiscal_yr_id,'item_grp_id' => $data['item_grp_id']));
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{ echo $row['id']; echo "hi";
			$result = $this->my_update("gst_master",array('cgst' => $data['cgst'],'sgst' => $data['sgst'] ),array('id' => $row['id']));
		}
		else
		{			
		    $data['company_id'] = $company_id;
		    $data['branch_id'] = $branch_id;
		    $data['fiscal_yr_id'] = $fiscal_yr_id;
		    
			$result=$this->f_save("gst_master",$data);
		}
		return $result;
	}

	public function check_vat($item_group_id,$vat_value)
	{		
		$fiscal_year = $this->dms->get_fiscal_year();
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];
		
		#-----------dms_stocks
		$this->db->from('dms_stocks as a')->join('item_master as b','a.item_id=b.id')->where(array('b.item_group_id' => $item_group_id,'b.status' => 1,'a.stock_status >' => 0,'a.stock_status <' => 9,'a.status' => 1));
		$this->db->where("stock_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
		$count1 = $this->db->count_all_results();
		if(!$count1)
		{				
			#-----------dms_purchase_orders
			$this->db->from('dms_purchase_orders as a')->join('dms_purchase_items as b','a.group_id=b.group_id')->join('item_master as c','b.item_id=c.id')->where(array('a.status' => 1,'b.status !=' => 0,'c.item_group_id' => $item_group_id,'c.status' => 1));
			$this->db->where("a.po_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
			$count2 = $this->db->count_all_results();
			if(!$count2)
			{					
				#-----------dms_quotations
				$this->db->from('dms_quotations as a')->join('dms_quotations_items as b','a.id=b.qt_id')->join('item_master as c','b.item_id=c.id')->where(array('a.status >' => 0,'b.status >' => 0,'c.item_group_id' => $item_group_id,'c.status' => 1));
				$this->db->where("a.qt_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
				return $this->db->count_all_results();
			}
			return true;
		}
		return true;
	}


        public function check_gst($item_group_id,$vat_value)
	{		
		$fiscal_year = $this->dms->get_fiscal_year();
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];
		
		#-----------dms_stocks
		$this->db->from('dms_stocks as a')->join('item_master as b','a.item_id=b.id')->where(array('b.item_group_id' => $item_group_id,'b.status' => 1,'a.stock_status >' => 0,'a.stock_status <' => 9,'a.status' => 1));
		$this->db->where("stock_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
		$count1 = $this->db->count_all_results();
		if(!$count1)
		{				
			#-----------dms_purchase_orders
			$this->db->from('dms_purchase_orders as a')->join('dms_purchase_items1 as b','a.group_id=b.group_id')->join('item_master as c','b.item_id=c.id')->where(array('a.status' => 1,'b.status !=' => 0,'c.item_group_id' => $item_group_id,'c.status' => 1));
			$this->db->where("a.po_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
			$count2 = $this->db->count_all_results();
			if(!$count2)
			{					
				#-----------dms_quotations
				$this->db->from('dms_quotations as a')->join('dms_quotations_items as b','a.id=b.qt_id')->join('item_master as c','b.item_id=c.id')->where(array('a.status >' => 0,'b.status >' => 0,'c.item_group_id' => $item_group_id,'c.status' => 1));
				$this->db->where("a.qt_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
				return $this->db->count_all_results();
			}
			return true;
		}
		return true;
	}

        public function get_other_gst($args = array())
	{
		$args['conditions']['company_id'] = $this->session->userdata('company_id');					
		$this->db->select(array('id','specialisation','cgst','sgst'))->from('other_gst')->where(array('company_id'=>$this->session->userdata('company_id')))->order_by('id');
		$row = $this->db->get()->result_array();		
		return $row;
	}
       
         public function get_igst($args = array())
	{
		$args['conditions']['company_id'] = $this->session->userdata('company_id');
		$args['conditions']['fiscal_yr_id'] = $this->session->userdata('fiscal_yr_id');				
		$this->db->select(array('id','item_type'))->from('item_type_master')->where(array('status'=>1,'company_id'=>$this->session->userdata('company_id')))->order_by('item_type');
		$row = $this->db->get()->result_array();
		foreach($row as $items => $item_details)
		{
			$igst = $this->get_item_igst($item_details['id']);                        
			$row[$items]['igst'] = $igst;
                        
		}
		return $row;
	}        

        public function updates_other($data)
	{
		$data['company_id'] = $this->session->userdata('company_id');
		$data['fiscal_yr_id'] = $this->session->userdata('fiscal_yr_id');
		$this->db->select('id')->from('other_gst')->where(array('company_id' => $data['company_id'],'fiscal_yr_id' => $data['fiscal_yr_id']));
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			$result=$this->my_update("other_gst",array('cgst' => $data['cgst'],'sgst' => $data['sgst'] ),array('id' => $row['id']));
		}
		else
		{			
			$result=$this->f_save("other_gst",$data);
		}
		return $result;
	}

        public function update_igst($data)
	{
		$data['company_id'] = $this->session->userdata('company_id');
		$data['fiscal_yr_id'] = $this->session->userdata('fiscal_yr_id');
		$this->db->select('id')->from('igst_master')->where(array('company_id' => $data['company_id'],'fiscal_yr_id' => $data['fiscal_yr_id'],'item_grp_id' => $data['item_grp_id']));
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			$result=$this->my_update("igst_master",array('igst' => $data['igst']),array('id' => $row['id']));
		}
		else
		{			
			$result=$this->f_save("igst_master",$data);
		}
		return $result;
	}

}