<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Voucher_types_model extends MY_Model
{
	public function get($args = array())
	{
		$company_id = $this->session->userdata('company_id');
		if(!isset($args['columns'])){
			$args['columns'] = array('b.id','a.vtype as voucher_type','b.vtype as voucher','b.defaults');
		}
		$this->db->select($args['columns'])->from('dms_voucher_types as a')->join('dms_voucher_types as b','a.id = b.vid','inner')->where("(b.company_id = $company_id or b.defaults = 1) and b.status = 1");
		return $this->db->get()->result_array();
	}

	public function get_types()
	{
		$this->db->select(array('id','vtype'))->from('dms_voucher_types')->where(array('defaults' => 1,'status' => 1));
		$row = $this->db->get()->result_array();
		$data = array();
		$data[""] = "select";
		foreach($row as $id => $value){
			$data[$value['id']] = $value['vtype'];
		}
		return $data;
	}
	public function insert($data)
	{
		$data['company_id'] = $this->session->userdata('company_id');
		if($this->f_save("dms_voucher_types",$data)){
			return true;
		}
		return false;
	}

	public function get_update_data($id)
	{
		$this->db->select(array('id','company_id','vid','vtype'))->from('dms_voucher_types')->where('id',$id);
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			return $row;
		}
		return false;
	}

	public function update($args = array())
	{
		$this->db->select('id')->from('dms_voucher_types')->where(array('company_id' => $this->session->userdata('company_id'),'id' => $args['conditions']['id'],'defaults =' => 0));
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			$this->my_update("dms_voucher_types",$args['data'],$args['conditions']);
			return true;
		}
	}

	public function check_voucher_type($vtype_id,$vid)
	{
		#-----------dms_vouchers
		$count1 = $this->db->from('dms_vouchers')->where(array('vtype_id' => $vtype_id,'status !=' => 0))->count_all_results();
		if(!$count1)
		{
			#-----------dms_voucher_temps
			$count2 = $this->db->from('dms_voucher_temps')->where('vtype_id',$vtype_id)->count_all_results();
			if(!$count2)
			{
				if($vid == 9)//receipt note
				{
					return $this->db->from('dms_receipt_notes')->where(array('vtype_id' => $vtype_id,'status !=' => 0))->count_all_results();
				}
				elseif($vid == 10)//delivery note
				{
					return $this->db->from('dms_delivery_notes')->where(array('vtype_id' => $vtype_id,'status !=' => 0))->count_all_results();
				}
				elseif($vid == 11)//rejection in
				{
					return $this->db->from('dms_rejection_ins')->where(array('vtype_id' => $vtype_id,'status !=' => 0))->count_all_results();
				}
				elseif($vid == 12)//rejection out
				{
					return $this->db->from('dms_rejection_outs')->where(array('vtype_id' => $vtype_id,'status !=' => 0))->count_all_results();
				}
				elseif($vid == 13)//physical stock
				{
					return false;
				}
				elseif($vid == 14)//memorandum
				{
					return false;
				}
				return 0;
			}
			return 1;
		}
		return 1;
	}
}