<?php
class Delivery_note_model extends MY_Model
{
	public function __construct()
	{
		parent :: __construct();

	}

	#---------------------------------------------------------------------------------
	#purpuse:get financial year starting and ending date
	public function get_fiscal_year($fiscal_year_id){


			//return $user_id;
			$row = $this->db->select(array('start_date','end_date'))->get_where('fiscal_year_master',array('id'=>$fiscal_year_id))->row_array();
			if(!empty($row)){
				if($row['end_date'] == '0000-00-00' || empty($row['end_date'])){
					$row['end_date'] = date('Y-m-d');
				}
				return $row;
			}
			return false;
		}

	#-------------------------------------------------------------------------------

	public function voucher_types($company_id,$vid)
	{
		$data = array();
		$this->db->select(array('id','vtype'))->from('dms_voucher_types')->where("(company_id = 0 or company_id = ".$company_id.")")->where(array('vid' => $vid,'status' => 1))->order_by('id');
		$row = $this->db->get()->result_array();
		if(!empty($row))
		{
			foreach($row as $key => $value)
			{
				$data[$value['id']] = $value['vtype'];
			}
		}
		return $data;
	}


#--------------------------------------------------------------------------------------------------------

	public function get_bills($args = array())
	{


		if(isset($args['fiscal_year_id'])){
			$fiscal_year_id = $args['fiscal_year_id'];
			$fiscal_start_date = $this->get_fiscal_year($fiscal_year_id)['start_date'];
			$fiscal_end_date = $this->get_fiscal_year($fiscal_year_id)['end_date'];

		}

		if(!isset($args['columns']))
		{
			$args['columns'] = array('id','vtype_id','bill_no','bill_date','group_id','dno','customer_type_id','customer_id','user_id','area_id','bill_discount_per','bill_discount_amt','bill_freight','other_expense','cess','d_status','bill_status');
		}
		$this->db->select($args['columns'])->from('dms_delivery_notes');

		if(isset($args['between'])){
			$this->db->where($args['between'],NULL,false);
		}
		else{
			$this->db->where("bill_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
		}

		if(!array_key_exists('branch_id',$args['conditions'])){
			$args['conditions']['branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['branch_id'])){
			unset($args['conditions']['branch_id']);
		}
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['like']) && !empty($args['like']))
		{
			$this->db->like($args['like'],false,'before');
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		#$this->db->get()->result_array();echo $this->db->last_query();die;
		return $this->db->get()->result_array();
	}

	#-------------------------------------------------------------------------------------------------------------
	public function get_sales($args = array())
	{
		if(isset($args['fiscal_year_id'])){
		$fiscal_year_id = $args['fiscal_year_id'];
		$fiscal_start_date = $this->get_fiscal_year($fiscal_year_id)['start_date'];
		$fiscal_end_date = $this->get_fiscal_year($fiscal_year_id)['end_date'];

		}

		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.dno','a.customer_id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.freight','b.godown_id');
		}
		$this->db->select($args['columns'])->from('dms_delivery_notes as a')->join('dms_sales_items as b','a.group_id = b.group_id');

		$this->db->where("a.bill_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);

		if(!array_key_exists('a.branch_id',$args['conditions'])){
			$args['conditions']['a.branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['a.branch_id'])){
			unset($args['conditions']['a.branch_id']);
		}
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}
#------------------------------------------------------------------------------------------------------------
	public function next_bill($vtype,$branch_id,$fiscal_year_id)
	{

		$fiscal_start_date = $this->get_fiscal_year($fiscal_year_id)['start_date'];
		$fiscal_end_date = $this->get_fiscal_year($fiscal_year_id)['end_date'];
		$row = $this->db->select_max('bill_no')->from('dms_sales')->where(array('branch_id' => $branch_id,'vtype_id' => $vtype,'status !=' => 0))->where("bill_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false)->get()->row_array();
		$bill_no = 1;
		if($row['bill_no'] != NULL){
			$bill_no = $row['bill_no']+1;
		}
		return $bill_no;
	}

#------------------------------------------------------------------------------------------------------------


	public function payment_modes($company_id)
	{
		$modes = array();
		$this->db->select(array('id','ledger_name'))->from('dms_ledgers')->where("(company_id = ".$company_id." or company_id = 0 or company_id = -1)")->where('id !=',7);
		if(empty($conditions['sub_groups'])){
			$sGroups = array(13,14,0);
		}else{
			$sGroups = $conditions['sub_groups'];
		}
		$this->db->where_in('sgroup_id',$sGroups);
		$row = $this->db->get()->result_array();
		if(!empty($row)){
			foreach($row as $key => $value){
				$modes[$value['id']] = $value['ledger_name'];
			}
		}
		return $modes;
	}

	#------------------------------------------------------------------------------------------------------------
	public function transaction_types()
	{
		return array('' => 'transaction-type',1 => 'cheque',2 => 'dd',3 => 'neft',4 => 'rtgs',5 => 'imps');
	}

	#------------------------------------------------------------------------------------------------------------

	public function update_others($args = array())
	{
			if($this->db->update($args['table'],$args['data'],$args['conditions'])){
				return true;
			}
			return false;
	}
	#------------------------------------------------------------------------------------------------------------

	public function insert($table,$data)
	{
		//$result = $this->f_save($table,$data);
		//if($result){
			//return $result;
		$data['created_on'] = date('Y-m-d H:i:s');
		$data['created_by'] = '-2';
		$this->db->insert($table,$data);

 		return $this->db->insert_id();


		//}
	//	return false;
	}
	#------------------------------------------------------------------------------------------------------------


}