<?php
class Sales_model extends MY_Model
{
	public function __construct()
	{
		parent :: __construct();

	}

#----------------------------------------------------------------------------------------
	public function voucher_types($company_id,$vid)
	{
		$data = array();
		$this->db->select(array('id','vtype'))->from('dms_voucher_types')->where("(company_id = 0 or company_id = ".$company_id.")")->where(array('vid' => $vid,'status' => 1))->order_by('id');
		$row = $this->db->get()->result_array();
		if(!empty($row))
		{
			foreach($row as $key => $value)
			{
				$data[$value['id']] = $value['vtype'];
			}
		}
		return $data;
	}

#---------------------------------------------------------------------------------------------

	#purpuse:get financial year starting and ending date
	public function get_fiscal_year($fiscal_year_id){


			//return $user_id;
			$row = $this->db->select(array('start_date','end_date'))->get_where('fiscal_year_master',array('id'=>$fiscal_year_id))->row_array();
			if(!empty($row)){
				if($row['end_date'] == '0000-00-00' || empty($row['end_date'])){
					$row['end_date'] = date('Y-m-d');
				}
				return $row;
			}
			return false;
		}






	#----------to get all bills
	public function get_bills($args = array())
	{

		if(isset($args['fiscal_year_id'])){
			$fiscal_year_id = $args['fiscal_year_id'];
			$fiscal_start_date = $this->get_fiscal_year($fiscal_year_id)['start_date'];
			$fiscal_end_date = $this->get_fiscal_year($fiscal_year_id)['end_date'];

		}

		if(!isset($args['columns']))
		{
			$args['columns'] = array('id','vtype_id','bill_no','bill_date','group_id','customer_type_id','customer_id','user_id','area_id','bill_discount_per','bill_discount_amt','bill_freight','other_expense','cess','payment_mode','bill_status');
		}
		$this->db->select($args['columns'])->from('dms_sales');

		if(isset($args['between'])){
			$this->db->where($args['between'],NULL,false);
		}
		else{
			$this->db->where("bill_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
		}

		if(!array_key_exists('branch_id',$args['conditions'])){
			$args['conditions']['branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['branch_id'])){
			unset($args['conditions']['branch_id']);
		}
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['like']) && !empty($args['like']))
		{
			$this->db->like($args['like'],false,'before');
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}
#-----------------------------------------------------------------------------------------------------------------------
	/*public function get_sales($args = array())
	{

		$fiscal_year_id = 2;
		$fiscal_start_date = $this->get_fiscal_year($fiscal_year_id)['start_date'];
		$fiscal_end_date = $this->get_fiscal_year($fiscal_year_id)['end_date'];

		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.customer_id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.godown_id');
		}
		$this->db->select($args['columns'])->from('dms_sales as a')->join('dms_sales_items as b','a.group_id = b.group_id');
		#$this->db->where('a.branch_id',$this->branch_id);
		$this->db->where("a.bill_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
		if(!array_key_exists('a.branch_id',$args['conditions'])){
			$args['conditions']['a.branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['a.branch_id'])){
			unset($args['conditions']['a.branch_id']);
		}
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}

	*/
	#--------------------------


	public function get_customer($customerType,$customerID,$return=NULL){

		//return "ppp";

		if($customerType ==1){

			#-branch details
			$rows = $this->db->select(array('concat(branch_short_name," ",branch_name) as name','branch_landline phone_no','branch_mobile as mobile_no','branch_address as address','branch_email as email_id','ledger_id'))->get_where('branch_master',array('id'=>$customerID))->row_array();
			if(!empty($rows)){
				if(empty($return)){
					return $rows['name'];
				}else{
					return $rows;
				}
			}
			return NULL;

		}else if($customerType ==2){

			#-customer details
			$rows = $this->db->select(array('concat(fname," ",lname) as name','address','mobile_no','phone_no','email_id','ledger_id'))->get_where('customer_master',array('id'=>$customerID))->row_array();
			if(!empty($rows)){
				if(empty($return)){
					return $rows['name'];
				}else{
					return $rows;
				}
			}
			return NULL;

		}else if($customerType ==3){

			#-ar details
			$rows = $this->db->select(array('concat(retailer_short_name," ",retailer_name) as name','retailer_address as address','retailer_landline as phone_no','retailer_mobile as mobile_no','retailer_email as email_id','tin_no as tin','ledger_id'))->get_where('retailer_master',array('id'=>$customerID))->row_array();
			if(!empty($rows)){
				if(empty($return)){
					return $rows['name'];
				}else{
					return $rows;
				}
			}
			return NULL;

		}else{
			return NULL;
		}
	}

	#-------------------------------------------------------------------------------
	public function desig_name($id)//designation name
	{
		$row = $this->db->select('designation_name')->get_where('designation_master',array('id' => $id))->row_array();
		if(!empty($row)){
			return $row['designation_name'];
		}
		return false;
	}
	#-------------------------------------------------------------------------------

	public function ledger_name($ledger_id)
	{
		$this->db->select('ledger_name')->from('dms_ledgers')->where('id',$ledger_id);
		$row = $this->db->get()->row_array();
		if(!empty($row)){
			return $row['ledger_name'];
		}
		return false;
	}

	#-------------------------------------------------------------------------------

	public function get_tax_type($company_id)
	{
		#return array(10);
		$row = $this->db->select(array('tax_type','presum_tax'))->get_where('company_master',array('id' => $company_id))->row_array();
		if($row['tax_type'] == 0){
			return array($row['presum_tax']);
		}
		return array();
	}

	#-------------------------------------------------------------------------------


	public function get_voucher_prefix($vid,$company_id){

		$row = $this->db->select(array('vprefix'))->get_where('dms_voucher_prefixes',array('company_id'=>$company_id,'vid'=>$vid))->row_array();
		if(!empty($row)){
			return $row['vprefix'];
		}
		return NULL;
	}

	#------------------------------------------------------------------------------
	public function get_sales_items($args = array())
	{
		if(!isset($args['columns'])){
			$args['columns'] = array('id','group_id','item_id','qty','unit_id','rate','amount','discount_amt','vat_amt','cst','godown_id');
		}
		$this->db->select($args['columns'])->from('dms_sales_items');
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}

		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		return $this->db->get()->result_array();
	}



#-------------------------------------------------------------------------------

	public function get_item_vat($itemID)
	{
		$this->load->model('accounts/Vat_model','vat');
		$row = $this->db->select('item_group_id')->get_where('item_master',array('id' => $itemID))->row_array();
		return $vatPercent = $this->vat->get_item_vat($row['item_group_id']);
	}

	#-------------------------------------------------------------------------------

}