<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Branch_model extends MY_Model{



	#-------------------------------------------------------
		
		public function get_all($conditions = NULL,$number=NULL,$limit=NULL,$offset=NULL){

			$conditions['status'] = 1;

			if($number == 1 ){
				return $this->db->get_where('branch_master',$conditions)->num_rows();
			}

			if($limit){
				return $this->db->get_where('branch_master',$conditions,$limit,$offset)->result_array();
			} 
			return $this->db->get_where('branch_master',$conditions)->result_array();
		}

	#-------------------------------------------------------

		public function listing($conditions = NULL){

			$conditions['status'] = 1;
			if($this->dms->get_main_branch($this->session->userdata('under_id')) === false){
				$conditions['id'] = $this->session->userdata('under_id');
			}
			$rows = $this->db->select(array('id','branch_short_name','branch_name'))->get_where('branch_master',$conditions)->result_array();

			$branches = array();
			foreach($rows as $row)
				$branches[$row['id']] = $row['branch_name'];	

			return $branches;
		}
		
		
	#---------------------------------------------------------------------------
	
		public function listingnew($conditions = NULL){

			$conditions['status'] = 1;
			if($this->dms->get_main_branch($this->session->userdata('under_id')) === false){
				$conditions['id'] = $this->session->userdata('under_id');
			}
			$rows = $this->db->select(array('id','branch_short_name','branch_name'))->get_where('branch_master',$conditions)->result_array();

			$branches = array();
			$branches[0]='All';
			foreach($rows as $row)
				$branches[$row['id']] = $row['branch_short_name'].' '.$row['branch_name'];	

			return $branches;
		}

#---------------------------------------------------------------------

public function listingnewid($conditions = NULL){

			$conditions['status'] = 1;
			if($this->dms->get_main_branch($this->session->userdata('under_id')) === false){
				$conditions['id'] = $this->session->userdata('under_id');
			}
			$rows = $this->db->select(array('id'))->get_where('branch_master',$conditions)->result_array();

			$branches = array();
		
			foreach($rows as $row)
				$branches[$row['id']] = $row['id'];	

			return $branches;
		}



	#--------------------------------------------------------
		public function save_area($branch_id,$area){
			$num = $this->db->get_where('branch_areas',array('branch_id'=>$branch_id,'area_name'=>$area))->num_rows();
			if($num==0){
				$this->db->insert('branch_areas',array('branch_id'=>$branch_id,'area_name'=>$area,'created_by'=>$this->session->userdata('id')));
			}
		}
	#--------------------------------------------------------
		#date : 23-6-2014
		#purpose : get area names of a  brances
		public function list_branch_areas($branch_id){

			$rows = $this->db->get_where('branch_areas',array('branch_id'=>$branch_id))->result_array();

			$areas = array();
			foreach($rows as $row){ $areas[$row['id']] = $row['area_name']; }
			return $areas;
		}	
	#---------------------------------------------------------
		#date :23-06-2014
		#purpose :area updation
		public function area_update($p_areas,$branch_id){

			$posted_areas = explode(',',$p_areas);
			print_r($posted_areas);

			#get exiisting areas#
			$exist_areas = $this->list_branch_areas($branch_id);
			//echo '</br>';print_r($exist_areas);die;

			#delere removed areas
			foreach($exist_areas as $ea){
				//echo $ea.'<hr/>';
				
				if(!in_array($ea,$posted_areas)){
					//remove ea
					$this->db->delete('branch_areas',array('branch_id'=>$branch_id,'area_name'=>$ea)); 
				}
			}


			#add new areas
			foreach ($posted_areas as $pa) {
				
				if(!in_array($pa,$exist_areas)){
					$this->db->insert('branch_areas',array('branch_id'=>$branch_id,'area_name'=>$pa,'created_by'=>$this->session->userdata('id')));
				}
			}

			return true;
		}
	#---------------------------------------------------------
		public function get_full_name($branch_id){

			$row = $this->db->select('branch_name')->get_where('branch_master',array('id'=>$branch_id))->row_array();
			return $row['branch_name'];
		}
#--------------------------------------------------------------------
	public function get_previous_status($branch_id){

			$row = $this->db->select('previous_entry')->get_where('branch_master',array('id'=>$branch_id))->row_array();
			return $row['previous_entry'];
		}

	#-----------------------------------------------------------------
		public function open_balance($ledger_id){

			$this->db->select(array('ledger.*','ledger.id as dms_ledger_id'));
			$this->db->from('dms_ledgers ledger');
			$this->db->where('ledger.id',$ledger_id);
			$this->db->where('ledger.status',1);
			$this->db->where('ledger.company_id',$this->session->userdata('company_id'));
			$ledgers1 = $this->db->get()->row_array();

			$this->db->select(array('open_bals.*','open_bals.id as open_bals_id'));
			$this->db->from('dms_ledger_open_bals open_bals');
			$this->db->where('open_bals.ledger_id',$ledger_id);
			$this->db->where('open_bals.status',1);
			$ledgers = $this->db->get()->row_array();
            $ledgers1 = is_array($ledgers1) ? $ledgers1 : []; // Ensure $ledgers1 is an array
            $ledgers = is_array($ledgers) ? $ledgers : []; // Ensure $ledgers is a
			return array_merge($ledgers1,$ledgers);	
		
		}
	#------------------------------------------------------------------
		public function branch_type($id){
			$this->db->select('branch_type');
			$this->db->from('branch_master');
			$this->db->where('id',$id);
			$this->db->where('company_id',$this->session->userdata('company_id'));
			$row = $this->db->get()->row_array();
			return $row['branch_type'];
		}
	#------------------------------------------------------------------		
		public function godown_count($branch_id)
		{
			return $this->db->where(array('branch_id' => $branch_id,'status' => 1))->count_all_results('godown_master');
		}
	#------------------------------------------------------------------
	
	    public function get_branch_details($branch_id)
	    {
	        $rows = $this->db->get_where('branch_master',array('id'=>$branch_id))->row_array();
	        
	        return array('id'=>$rows['id'],'name'=>$rows['branch_name'],'address'=>$rows['branch_address'],'land_line'=>$rows['branch_landline'],'mobile'=>$rows['branch_mobile']);
	    }
	}
?>