<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Company_model extends CI_Model{

		#-------------------------------------------

			public function get_all($conditions=NULL,$return=0,$limit=0,$offset=0){
		         if (!is_array($conditions)) {
                    $conditions = [];
                }
				$this->db->select(array('cm.*'));
				$this->db->from('company_master cm');			
				$conditions['cm.status'] = 1;
				$this->db->where($conditions);				
				if($return){
					return $this->db->count_all_results();
				}				
				if($offset != 0)
					$this->db->limit($offset,$limit);				
				return $this->db->get()->result_array();
			}

		#-------------------------------------------
		#get company and user details
		public function get_user_company($company_id){

			$row = $this->db->select('id')->get_where('users',array('id >' => 0,'company_id' => $company_id,'status !=' => 0))->row_array();
			if(!empty($row)){
				return true;
			}
			return false;
		}
		#-------------------------------------------

		public function have_access($menu_id){

			$total = $this->db->select('id')->get_where('user_privileges',array('owner_id'=>$this->session->userdata('id'),'menu_id'=>$menu_id,'user_group'=>'individual'))->num_rows();
			if($total == 0){
				return false;
			}else{
				return true;
			}

		}
		
		public function get_stock_count()
		{
			$row = $this->db->select('id')->get_where('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'status' => 1))->row_array();
			if(!empty($row)){
				return true;
			}
			return false;
		}
		
		public function company_count()
		{
			$row = $this->db->select('id')->get_where('company_master',array('status' => 1))->row_array();
			if(!empty($row)){
				return true;
			}
			return false;
		}
		
		public function get_company($user = -2)
		{
			$row = $this->db->select('company_id')->get_where('users',array('id' => $user,'status !=' => 0))->row_array();
			if(!empty($row)){
				return $row['company_id'];
			}
			return false;
		}
		
		public function update_others($args = array())
		{		
			if($this->db->update($args['table'],$args['data'],$args['conditions'])){
				return true;
			}		
			return false;
		}

		#-------------company type(single/multi)
		public function company_type()
		{		
			$row = $this->db->select('id')->get_where('dms_company_type',array('status' => 1))->row_array();
			return $row['id'];
		}
	}
?>