<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Designation_master_model extends MY_Model{

		#--------------------------------------------------
		public $desig_array = array();
		#--------------------------------------------------

		public function listing($conditions=array()){

			$this->db->from('designation_master');
			$this->db->where('status',1);
			if($conditions){
				foreach ($conditions as $key => $value) {
					$this->db->where($key,$value);
				}
			}
			$this->db->where("(company_id='0' OR company_id='".$this->session->userdata('company_id')."')");
			#-------------------for customer only
			$this->db->where('id',2);
			#-------------------for customer only
			#$this->db->or_where('company_id',$this->session->userdata('company_id'));

			$this->db->order_by('designation_name');
			$rows = $this->db->get()->result_array();

			$desgs = array();
			foreach($rows as $row){
				$desgs[$row['id']] = $row['designation_name'];
			}

			return $desgs;
		}

		#--------------------------------------------------

		public function get_all($conditions=array()){
		
				#getting shop id
				$conditions['department_master.company_id'] = $this->session->userdata('company_id');
				
				$this->db->select(array('designation_master.*'));
				$this->db->from('designation_master');
				$this->db->join('department_master','designation_master.department_id=department_master.id');
				
				if(!empty($conditions)){
				foreach($conditions as $key=>$value){
					$this->db->where($key,$value);
				}
			}

			$this->db->where('designation_master.status',1);
			 
			$this->db->order_by("designation_name", "ASC"); 

			return $this->db->get()->result_array();
		}

		

		#--------------------------------------------------

		public function get_id($designation){

			$row = $this->db->get_where('designation_master',array('designation_name'=>$designation))->row_array();
			return $row['id'];
		}

		#--------------------------------------------------
			public function get_desg_for_dept($dept){

			$desgs = array();

			if(!empty($dept)){

				$rows = $this->db->select(array('id','designation_name'))->get_where('designation_master',array('department_id'=>$dept))->result_array();

				if(empty($rows)){
				$desgs[''] = 'No designation found';
				}else{
					foreach($rows as $row)
						$desgs[$row['id']] = $row['designation_name'];
				}
			}
			/*else{
				$desgs[''] = 'Select a designation';
			}*/
				
			return $desgs;
		}


	#-------------------------------------------------------------
		public function get_all1($args){

			$this->db->select(array('*'));
			$this->db->from('designation_master');
			$this->db->where('status',1);
			$this->db->where('company_id',$this->session->userdata('company_id'));
			$this->db->or_where('company_id',0);
			$this->db->where('department_id >',0);

			//$this->db->join('vehicle_master vehicle','insurance.vehicle_id = vehicle.id');

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
	#-------------------------------------------------------------#
		public function desig_listing($lower_desig=NULL){

			$desig_id = $this->session->userdata('user_desig');
			if($lower_desig == NULL){
				$this->desig_array[$desig_id] = $this->get_name($desig_id);
			}
			$this->db->select(array('id','designation_name'));
			$this->db->from('designation_master');
			$this->db->where("(company_id='0' OR company_id='".$this->session->userdata('company_id')."')");
			$this->db->where(array('parent_id' => $desig_id,'utype_status <=' =>3));
			$rows = $this->db->get()->result_array();
			if(!empty($rows)){
				foreach($rows as $row){

					$this->desig_array[$row['id']] =  $this->get_name($row['id']);
					$this->get_parent_desig($row['id']);					
				}
				
			}
			return $this->desig_array;		
		}

	#-------------------------------------------------------------#
		public function get_parent_desig($id)
		{		
			$rows = $this->db->select('id')->from('designation_master')->where(array('parent_id'=>$id,'utype_status <=' => 3))->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $row)
				{
					$this->desig_array[$row['id']] = $this->get_name($row['id']);
					$this->get_inner_parent_desig($row['id']);
				}
			}
		}
	#-------------------------------------------------------------#
		public function get_inner_parent_desig($id)
		{			
			$rows = $this->db->select('id')->from('designation_master')->where(array('parent_id'=>$id,'utype_status <=' => 3))->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $row)
				{
					$this->desig_array[$row['id']] = $this->get_name($row['id']);
					$this->get_parent_desig($row['id']);
				}
			}
		}	
	#-------------------------------------------------------------#
		public function get_name($id){

			$row = $this->db->select('designation_name')->get_where('designation_master',array('id'=>$id))->row_array();
			return $row['designation_name'];
		}	
	#-------------------------------------------------------------#

	#-------------------------------------------------------------	
		
	}

?>