<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Staff_leave_model extends MY_Model{

		#--------------------------------------------------

		public function get_name($id){

			$row = $this->db->get_where('employee_leave_type',array('id'=>$id))->row_array();
			return $row['leave_type'];
		}

		#--------------------------------------------------
		public function get_all($args,$type = 0){

			$this->db->select(array('*'));
			$this->db->from('employee_leave_type');
				if(!empty($args)){
				foreach($args as $key=>$value){
					$this->db->where($key,$value);
				}
			}
				if($type == 1)
				{
					$this->db->or_where('company_id','0');
				}
			return $this->db->get()->result_array();
		}

		#--------------------------------------------------
		public function get_all_assigned()
		{
			return $this->db->distinct()->select(array('designation','from_date','to_date'))->from('designation_leave_types')->where('status',1)->get()->num_rows();
		}

		#--------------------------------------------------

		#date: 01-08-2014
		#purpose : delete the target
		public function delete_ltype($id){
			
			$check_ltype = $this->db->select()->get_where('employee_leave_type',array('id'=>$id,'status'=>1))->row_array();
			if(!empty($check_ltype)){
				$result=$this->db->update('employee_leave_type',array('status'=>0),array('id'=>$id));
			}
			return $result;
		}

		#--------------------------------------------------

		#date: 01-08-2014
		#purpose : delete the target
		public function delete_ltype_assigned($where = array())
		{
			$where['status'] = 1;			
			if($this->db->from('designation_leave_types')->where($where)->count_all_results()){				
				$this->my_update('designation_leave_types',array('status' => 0),$where);
				return true;
			}			
			return false;			
		}

		#--------------------------------------------------

		public function get_ltype_for_user($did){

			$this->db->select(array('el.*','dl.*','dm.*'));
			$this->db->from('employee_leave_type el');
			$this->db->join('designation_leave_types dl','el.id=dl.leave_type_id');
			$this->db->join('designation_master dm','dm.id=dl.designation','inner');
			$this->db->where('el.company_id',$this->session->userdata('company_id'));
			$this->db->where('dl.designation',$did);
			$this->db->where('dl.status',1);
			$this->db->where('el.status',1);
				
			$rows = $this->db->get()->result_array();
			#print_r($rows);
			$ltypes = array();
			foreach($rows as $row){
				$ltypes[$row['leave_type_id']] = $row['leave_type'];
			}
			return $ltypes;
		}

	#--------------------------------------------------

		public function get_default_ltypes(){

			$this->db->select(array('*'));
			$this->db->from('employee_leave_type');
			$this->db->where('company_id',0);
			$rows = $this->db->get()->result_array();
			#print_r($rows);
			$ltypes = array();
			foreach($rows as $row){
				$ltypes[$row['id']] = $row['leave_type'];
			}
			return $ltypes;
		}

	#---------------------------------------------------------------
		#purpose : to get attended data from employee_attendance
		public function get_attended($args){

			$this->db->select(array('*'));
			$this->db->from('employee_attendance');				
				if(!empty($args)){
				foreach($args as $key=>$value){
					$this->db->where($key,$value);
				}
			}
			return $this->db->get()->result_array();
		}

	#---------------------------------------------------------------
		#purpose : to get unique attended data from employee_attendance
		public function get_attended_unique($args){

			$this->db->distinct();
			$this->db->select(array('date'));
			$this->db->from('employee_attendance');
				
				if(!empty($args)){
				foreach($args as $key=>$value){
					$this->db->where($key,$value);
				}
			}
			return $this->db->get()->result_array();
		}

	#--------------------------------------------------
		#purpose : to get leave of assigned leave type from employee_attendance
		public function get_ltype_row($args){

			$this->db->distinct();
			$this->db->select(array('ea.*','dl.leave_type_id','el.*'));
			$this->db->from('employee_attendance ea');
			$this->db->join('employee_leave_type el','el.id = ea.leave_type');
			$this->db->join('designation_leave_types dl','el.id = dl.leave_type_id');
			$this->db->where('ea.attend',0);
			$this->db->where('ea.status',1);

				if(!empty($args)){
				foreach($args as $key=>$value){
					$this->db->where($key,$value);
				}
			}
			return $this->db->get()->result_array();
		}	

	#--------------------------------------------------------------------------------
		#purpose : to get leave of default leave type from employee_attendance
		public function get_default_ltype_row($args){

			$this->db->distinct();
			$this->db->select(array('ea.*','el.*'));
			$this->db->from('employee_attendance ea');
			$this->db->join('employee_leave_type el','el.id = ea.leave_type');
			$this->db->where('ea.attend',0);
			$this->db->where('ea.status',1);

				if(!empty($args)){
				foreach($args as $key=>$value){
					$this->db->where($key,$value);
				}
			}
			return $this->db->get()->result_array();
		}	

	#--------------------------------------------------------------------------------------
		#purpose : to get halfday leave of assigned leave type from employee_attendance
		public function get_halfltype_row($args){

			$this->db->distinct();
			$this->db->select(array('ea.*','dl.leave_type_id','el.*'));
			$this->db->from('employee_attendance ea');
			$this->db->join('employee_leave_type el','el.id = ea.leave_type');
			$this->db->join('designation_leave_types dl','el.id = dl.leave_type_id');
			$this->db->where('ea.attend',1);
			$this->db->where('ea.status',1);

				if(!empty($args)){
				foreach($args as $key=>$value){
					$this->db->where($key,$value);
				}
			}
			return $this->db->get()->result_array();
		}	

	#--------------------------------------------------

		#purpose : to fetch halfday leave of default leave types from employee_attendance
		public function get_dfhalfltype_row($args)
		{
			$this->db->distinct();
			$this->db->select(array('ea.*','el.*'));
			$this->db->from('employee_attendance ea');
			$this->db->join('employee_leave_type el','el.id = ea.leave_type');
			$this->db->where('ea.attend',1);
			$this->db->where('ea.status',1);
			if(!empty($args))
			{
				foreach($args as $key=>$value)
				{
					$this->db->where($key,$value);
				}
			}
			return $this->db->get()->result_array();
		}

		#--------------------------------------------------
		public function check_leaves($desig_id,$leave_type_id,$from_date,$to_date,$id = NULL)
		{
			$where = array('status' => 1);
			if(!empty($id)){
				$where['id !='] = $id;
			}
			if($this->db->from('designation_leave_types')->where(array('designation' => $desig_id,'leave_type_id' => $leave_type_id))->where("((from_date <= '$from_date' and to_date >= '$from_date') or (from_date <= '$to_date' and to_date >= '$to_date') or (from_date > '$from_date' and to_date < '$to_date'))")->where($where)->count_all_results()){
				return true;
			}
			return false;
		}

		#--------------------------------------------------
		public function get_assigned_leaves($limit = NULL,$offset = NULL)
		{
			$leave_array = array();
			$this->db->distinct()->select(array('designation','from_date','to_date'))->from('designation_leave_types')->where('status',1)->order_by('from_date','DESC');
			if(!empty($limit)){
				$this->db->limit($limit, $offset);
			}
			$row = $this->db->get()->result_array();			
			if(!empty($row))
			{
				foreach($row as $key => $value)
				{					
					$row1 = $this->db->select(array('leave_type_id','max_permissible','carry_forward','from_date','to_date'))->get_where('designation_leave_types',array('designation' => $value['designation'],'from_date' => $value['from_date'],'to_date' => $value['to_date'],'status' => 1))->result_array();					
					$ltype_array = array();
					$year = date('Y',strtotime($value['from_date']));
					foreach($row1 as $lkey => $lvalue)
					{
						$ltype_array[$lvalue['leave_type_id']] = array('max_leave' => $lvalue['max_permissible'],'carry_forward' => $lvalue['carry_forward'],'year' => $year);
					}						
					$leave_array[] = array($value['designation'] => $ltype_array);					
				}
			}			
			return $leave_array;
		}

		#--------------------------------------------------
		public function get_assigned_leave($desig,$from_date,$to_date)
		{
			$row = $this->db->select(array('a.id','b.id as did','max_permissible','carry_forward','leave_type','type_description'))->from('employee_leave_type as a')->join('designation_leave_types as b',"a.id=b.leave_type_id and b.designation='$desig' and b.from_date='$from_date' and b.to_date='$to_date' and b.status=1",'left')->where(array('a.company_id' => $this->session->userdata('company_id'),'a.status' => 1))->get()->result_array();
			if(!empty($row)){
				return $row;
			}
			return false;
		}
		
		#--------------------------------------------------
		public function get_attendance($date)
		{
		   
			$row = $this->db->select(array('a.id',"concat(a.fname,' ',a.lname) as sname",'a.designation_id','b.designation_name','c.attend','c.leave_type'))->from('users as a')->join('designation_master as b','a.designation_id=b.id')->join('employee_attendance as c',"a.id=c.user_id and c.date='$date' and c.status=1",'left')->where(array('a.id >' => 0,'a.department_id >' => 0,'a.status' => 1,'a.branch_id' => $this->session->userdata('under_id'),'b.status' => 1,'a.date_of_join <=' => $date))->order_by('designation_name','asc')->get()->result_array();			
			if(!empty($row)){
				return $row;
			}
			return false;
		}

		#--------------------------------------------------
		public function get_color($ltype_id)
		{
			$row = $this->db->select(array('leave_type','type_color','type_description'))->get_where('employee_leave_type',array('id' => $ltype_id))->row_array();
			if(!empty($row)){
				return $row;
			}
			return false;
		}

		#--------------------------------------------------
		public function get_leaves($desig_id,$from_date,$to_date,$leave_type_id = NULL)
		{
			$this->db->from('designation_leave_types')->where(array('designation' => $desig_id,'from_date' => $from_date,'to_date' => $to_date));
			if($leave_type_id != NULL){
				$this->db->where('leave_type_id',$leave_type_id);
			}
			$this->db->where('status',1);
			return $this->db->count_all_results();
		}

		#--------------------------------------------------
		public function check_attendance($desig_id,$year)
		{
			return $this->db->from('users as a')->join('employee_attendance as b','a.id=b.user_id')->where(array('a.designation_id' => $desig_id,'a.status' => 1,'YEAR(b.date)' => $year,'b.status' => 1))->count_all_results();
		}
	}
?>