<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Enquiry_model extends MY_Model{
	

                public function __construct(){
		
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');		
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}



	#-------------------------------------------------------
		#date : 14-8-2014
		#purpose : save enquiry data
		public function save($enq_data){

			

			#user
			$enq_data['created_by'] = $this->session->userdata('id');

			#date formats
			$enq_data['enquiry_date'] = date('Y-m-d',strtotime($enq_data['enquiry_date']));
			$enq_data['follow_up_date'] = date('Y-m-d',strtotime($enq_data['follow_up_date']));

			$this->db->insert('enquiries',$enq_data);
			
			$enq_id = $this->db->insert_id();

			return $enq_id;

		}
	#---------------------------------------------------------
		#date : 14-8-2014
		#purpose : save enquiry items in tbl - enquiry stocks
		public function save_items($enquiry_id,$items){

			$items['enquiry_id'] = $enquiry_id;
			$this->db->insert('enquiry_items',$items);
			return true;
		}

	#---------------------------------------------------------
		#date : 14-8-2014
		#purpose : get enquiry data based on conditions
		public function get_all($args = NULL){

			$args = func_get_args()[0];
			#print_r($args);

			$this->db->select(array('e.*','ei.id ei_id','i.item_name','ei.item_quantity','ei.status','u.symbol','e.status as st'));
			$this->db->from('enquiries e');
			$this->db->where('e.status<=',2);
			$this->db->join('enquiry_items ei','ei.enquiry_id = e.id');
			$this->db->join('item_master i','ei.item_id=i.id');
			$this->db->join('unit_master u','ei.item_unit=u.id');
			$this->db->where('ei.status',1);

			#echo '<pre>';print_r($args);

			if($args != NULL){
				foreach($args as $key=>$value){
					if($key == 'total'){ return $this->db->get()->num_rows(); }
					else if($key == 'order_by'){ $this->db->order_by($value,$args['order']);}
					else if($key == 'limit'){ $this->db->limit($value,$args['offset']); }
					else if(!in_array($key,array('offset','order','order_by'))){ $this->db->where($key,$value); }

				}
			}
			

			return $this->db->get()->result_array();
		}
	#----------------------------------------------------------
		#date : 14-7-2014
		#purpose : find out how many items are there for a request
		public function get_items($args = NULL){

			$this->db->select()->from('enquiry_items ei');
			$this->db->where('status',1);
			if($args != NULL){
				foreach($args as $key=>$value){
					if($key == 'total'){ return $this->db->get()->num_rows(); }
					else if($key == 'order_by'){ $this->db->order_by($value,$args['order']);}
					else if($key == 'limit'){ $this->db->limit($value,$args['offset']); }
					else if(!in_array($key,array('offset','order','order_by'))){ $this->db->where($key,$value); }

				}
			}

			return $this->db->get()->result_array();
		}

	#----------------------------------------------------------
		#date : 19-8-2014
		#purpose : list workstages
		public function work_stage_listing(){
			$rows = $this->db->order_by('stage')->get_where('work_stages')->result_array();
			$stages = array();

			foreach($rows as $row){ $stages[$row['id']] = $row['stage']; }
			return $stages;
		}
	#----------------------------------------------------------
		#date:17-10-2014
		#purpose:to get remind enquiry follow up
		public function follow_up_remainder($date){
			//echo 'hai';die;
			$cur_date = $date ;
	    	
	    	$max_date = strtotime ( '+7day' , strtotime ( $date ) ) ;
	    	$max_date = date('Y-m-d',$max_date);

	    	$conditions['e.follow_up_date >='] = $cur_date;
	    	$conditions['e.follow_up_date <='] = $max_date;

	    	$result = $this->get_all($conditions);

	    	return $result;
		}

	#----------------------------------------------------------

            public function save_customer($data)
            {		
		$data['branch_id'] = $this->branchID;
		$customerID = NULL;
		$this->db->select('id');
		$this->db->from('customer_master');
		$this->db->where(array('mobile_no'=>$data['mobile_no'],'status !='=>0));
		$customer = $this->db->get()->row_array();
		if(empty($customer)){
			$this->f_save("customer_master",$data);
			$customerID = $this->db->insert_id();
		}else{
			$customerID = $customer['id'];
		}
		return $customerID;
	     }


            public function get_sales($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.company_id','a.mason_id','a.stage_id','a.name','a.address','a.created_by','a.enquiry_date','a.follow_up_date','a.fiscal_yr_id','b.enquiry_id','b.item_id','b.item_quantity','b.item_unit','b.status');
		}
		$this->db->select($args['columns'])->from('enquiries as a')->join('enquiry_items as b','a.id = b.enquiry_id');

		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
                if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}

         public function update_others($args = array())
	{
		if($this->db->update($args['table'],$args['data'],$args['conditions'])){
			return true;
		}
		return false;
	}
	
	
	public function next_bill_no($vtype)
	{
		$vid = $this->vouchers->get_vid($vtype);
		$this->db->select(array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.sid','a.s_status'))->from('dms_delivery_notes as a')->join('dms_voucher_types as b','a.vtype_id=b.id')->where(array('b.vid' => $vid,'a.branch_id' => $this->branch_id,'a.created_by' => $this->session->userdata('id'),'a.status' => -1))->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false)->order_by('a.id','asc')->limit(1);
		$row = $this->db->get()->row_array();
		if(empty($row)){
			$this->db->select_max('bill_no')->from('dms_delivery_notes')->where(array('branch_id' => $this->branch_id,'vtype_id' => $vtype,'status !=' => 0))->where("bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
			$row = $this->db->get()->row_array();
			$cur_date=date('Y-m-d');
			$row['vtype_id'] = $vtype;
			$row['bill_date'] = $cur_date;
			$row['vstatus'] = 0;
			if($row['bill_no'] != NULL){
				$row['bill_no'] = $row['bill_no']+1;
			}
			else{
				$row['bill_no'] = 1;
			}
		}
		else{
			$row['vstatus'] = 1;
		}
		return $row;
	}

	public function next_bill($vtype)
	{
		$row = $this->db->select_max('bill_no')->from('dms_sales')->where(array('branch_id' => $this->branch_id,'vtype_id' => $vtype,'status !=' => 0))->where("bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false)->get()->row_array();
		$bill_no = 1;
		if($row['bill_no'] != NULL){
			$bill_no = $row['bill_no']+1;
		}
		return $bill_no;
	}
	public function insert($table,$data)
	{
		$result = $this->f_save($table,$data);
		if($result){
			return $result;
		}
		return false;
	}
	public function get_cust($id)
	{
		
		$this->db->select('name')->from('enquiries');
		$this->db->where(array('id'=>$id));
	
	
		return $this->db->get()->result_array();
	
	
	
	}


	}
?>