<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Fiscal_model extends MY_Model
{
	public function insert($data)
	{
		$result=$this->f_save("fiscal_year_master",$data);
		$this->update_order();
		return $result;
	}
	
	public function insert_others($table,$data)
	{
		$result = $this->f_save($table,$data);
		if($result){
			return $result;
		}
		return false;		
	}
	
	public function update($table,$data,$conditions)
	{	
		$result=$this->my_update($table,$data,$conditions);
		if($table == "fiscal_year_master"){
			$this->update_order();
		}
		return $result;
	}
	
	public function update_order()
	{
		$this->db->select('id')->from('fiscal_year_master')->where(array('company_id' => $this->session->userdata('company_id'),'status' => 1))->order_by('start_date','asc');
		$row = $this->db->get()->result_array();
		if(!empty($row))
		{
			$i = 0;
			foreach($row as $fiscals => $fiscal_details)
			{
				$i++;
				$this->db->update('fiscal_year_master',array('fiscal_order' => $i),array('id' => $fiscal_details['id']));
			}
		}
		return true;
	}
	
	public function update_others($args = array())
	{		
		if($this->db->update($args['table'],$args['data'],$args['conditions'])){
			return true;
		}		
		return false;
	}
	
	public function check_date($start_date,$end_date,$id = NULL)
	{
		$cond=array('company_id' => $this->session->userdata('company_id'),'status' => 1);
		if(!empty($id)){
			$cond['id != ']=$id;}
		$where="((`start_date` <= '$start_date' && `end_date` >= '$start_date') or (`start_date` <= '$end_date' && `end_date` >= '$end_date') or (`start_date` > '$start_date' && `end_date` < '$end_date'))";
		$this->db->select('id')->from("fiscal_year_master")->where($cond)->where($where);	
		return $this->db->get()->num_rows();
	}
	
	public function get($args = array())
	{
		$args['cond']['status'] = 1;
		$args['cond']['company_id'] = $this->session->userdata('company_id');
		if(isset($args['columns'])){
			$this->db->select($args['columns'])->from('fiscal_year_master');;
		}
		else{
			$this->db->select(array('id','company_id','start_date','end_date','status','close_status'))->from('fiscal_year_master');
		}
		$this->db->where($args['cond']);
		if(isset($args['numrows']))
		{
			return $this->db->count_all_results();			
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}		
		return $this->db->get()->result_array();
		//echo $this->db->last_query();die;		
	}
	
	public function first_closed_yr()
	{
		$row = $this->db->select(array('id','start_date','end_date'))->from('fiscal_year_master')->where(array('company_id' => $this->session->userdata('company_id'),'status' => 0))->order_by('fiscal_order','asc')->limit(1)->get()->row_array();
		if(!empty($row))
		{
			return $row;
		}
		return false;
	}
}