<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
	
	class Godown_model extends MY_Model{


		#---------------------------------------------------------
		public function get_all($args){

			$this->db->select(array('gm.*','bm.branch_name'));
			$this->db->from('godown_master gm');
			$this->db->where('gm.status',1);
			$this->db->join('branch_master bm','bm.id=gm.branch_id');
			$this->db->where('bm.status',1);
			
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}
			else{
				$this->db->order_by('branch_id','asc');
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
		#---------------------------------------------------------
		
		public function listing($args=array()){
			$godowns= array();
			
			$this->db->select(array('gm.id','gm.godown_code','gm.godown_name','bm.branch_name'));
			$this->db->from('godown_master gm');
			$this->db->join('branch_master bm','gm.branch_id = bm.id');
			$args['conditions']['gm.status'] = 1;
			$args['conditions']['bm.company_id'] = $this->session->userdata('company_id');
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			$rows = $this->db->get()->result_array();
			if(!empty($rows)){
				foreach($rows as $key=>$row){
					$godowns[$row['id']] = $row['godown_code'].' / '.$row['godown_name'].' - '.$row['branch_name'];
				}
			}
			return $godowns;
						
		}
		
		public function listing1($args=array()){
			$godowns= array();
			
			$this->db->select(array('gm.id','gm.godown_code','gm.godown_name','bm.branch_name'));
			$this->db->from('godown_master gm');
			$this->db->join('branch_master bm','gm.branch_id = bm.id');
			$args['conditions']['gm.status'] = 1;
			$args['conditions']['bm.status'] = 1;
			$args['conditions']['bm.company_id'] = $this->session->userdata('company_id');
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			$rows = $this->db->get()->result_array();
			if(!empty($rows)){
				foreach($rows as $key=>$row){
					$godowns[$row['id']] = $row['branch_name'].' -- '.$row['godown_code'].' / '.$row['godown_name'];
				}
			}
			return $godowns;
						
		}
		
		#---------------------------------------------------------
		public function opt_listing($args=array()){
			$godowns= array();
			
			$this->db->select(array('gm.id','gm.godown_code','gm.godown_name','bm.branch_name'));
			$this->db->from('godown_master gm');
			$this->db->join('branch_master bm','gm.branch_id = bm.id');
			$this->db->where('bm.status',1);
			$this->db->order_by('gm.branch_id','ASC');
			$args['conditions']['gm.status'] = 1;
			$args['conditions']['bm.company_id'] = $this->session->userdata('company_id');
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			$rows = $this->db->get()->result_array();
			if(!empty($rows)){
				foreach($rows as $key=>$row){
					$godowns[$row['branch_name']][$row['id']] = $row['godown_code'].' / '.$row['godown_name'];
				}
			}
			return $godowns;
						
		}
		
		#---------------------------------------------------------
		public function opt_listing1($args=array()){
			$godowns= array();
			
			$this->db->select(array('gm.id','gm.godown_code','gm.godown_name','bm.branch_name','cm.company_name'));
			$this->db->from('godown_master gm');
			$this->db->join('branch_master bm','gm.branch_id = bm.id');
			$this->db->join('company_master cm','bm.company_id = cm.id');
			$this->db->where('bm.status',1);
			$this->db->order_by('gm.branch_id','ASC');
			$args['conditions']['gm.status'] = 1;
			//$args['conditions']['bm.company_id'] = $this->session->userdata('company_id');
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$godowns[$row['company_name']][$row['id']] = $row['branch_name'].' ['.$row['godown_name'].' '.$row['godown_code'].']';
				}
			}
			return $godowns;
						
		}
		

		#---------------------------------------------------------
		public function check_delete($id){
			$this->db->select('id');
			$this->db->from('dms_stocks');
			$this->db->where(array('status !='=>0,'godown_id'=>$id));
			$row = $this->db->count_all_results();
			if(!empty($row)){
				return true;
			}
			else{
				return false;
			}
		}
		#---------------------------------------------------------

		public function godown_exists($code,$branch_id,$type,$id = NULL)
		{
			//type = 1 => code , type = 2 => name
			if($type == 1){
				if($id != NULL){
					$where = array('id !=' => $id,'branch_id' => $branch_id,'godown_code' => $code);
				}
				else{
					$where = array('branch_id' => $branch_id,'godown_code' => $code);
				}
			}
			else{
				if($id != NULL){
					$where = array('id !=' => $id,'branch_id' => $branch_id,'godown_name' => $code);
				}
				else{
					$where = array('branch_id' => $branch_id,'godown_name' => $code);
				}
			}
			if($this->db->from('godown_master')->where($where)->count_all_results()){				
				return true;
			}
			return false;
		}
	}
?>