<?php
class Payment_against_bill_model extends MY_Model{
	
	#============================
	
	public function __construct(){
		
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
				
	}
	
	#============================
	
	public function save_bill($data){
		if($this->f_save("dms_voucher_against_bills",$data)){
			return true;
		}
		return false;		
	}
	
	#============================
	
	public function save_bill_items($data){
		if($this->f_save("dms_voucher_against_bill_items",$data)){
			return true;
		}
		return false;		
	}	
	
	#============================
	
	public function update($data,$conditions){
		if($this->my_update('dms_voucher_against_bills',$data,$conditions)){
			return true;
		}
		return false;		
	}
	
	#============================
	
	public function update_receipt_item($data,$conditions){
		if($this->my_update('dms_voucher_against_bill_items',$data,$conditions)){
			return true;
		}
		return false;		
	}	
	
	#============================
	
	public function delete_item($dvabi_id){
		
		$this->db->select(array('vid'));
		$this->db->from('dms_voucher_against_bill_items');
		$this->db->where(array('id'=>$dvabi_id));
		
		$rows = $this->db->get()->row_array();
		$vid = $rows['vid'];
		
		$this->db->from('dms_voucher_against_bill_items');
		$this->db->where(array('vid'=>$vid));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->db->delete('dms_voucher_against_bills',array('id'=>$vid));
		}
		
		if($this->db->delete('dms_voucher_against_bill_items',array('id'=>$dvabi_id))){
			return true;
		}		
		
		
		
		
		if($this->db->delete('dms_voucher_against_bill_items',array('id'=>$dvabi_id))){
			return true;
		}
		return false;
		
	}
	
	#============================
	
	public function get($args = array()){
		
		if(!isset($args['select'])){
			$args['select'] = array('dvab.*');
		}
		$this->db->select($args['select']);
		$this->db->from('dms_voucher_against_bills as dvab');
		
		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}		
		if(isset($args['between'])){
			$fromDate = $args['between'][0];$toDate = $args['between'][1];
		}else{
			$fromDate = $this->fiscal_start_date;$toDate = $this->fiscal_end_date;
		}
		$this->db->where("dvab.bill_date between '".$fromDate."' and '".$toDate."'",NULL,true);
		if(!isset($args['conditions']['dvab.status'])){
			$args['conditions']['dvab.status'] = 1;
		}
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		#-- returns total number of rows---------------------
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}
		$this->db->order_by('dvab.bill_date','desc');

		#-- for order by------------------------------------------
		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
		}

		#--for limit ----------------------------------------------
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}			
		#$this->db->get()->result_array();echo $this->db->last_query();die;
		
		return $this->db->get()->result_array();		
	}
	
	#============================
	public function get_receipt_number(){
		
		$this->db->select_max('bill_no');
		$this->db->from('dms_voucher_against_bills as dvab');
		$this->db->where("dvab.bill_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$this->db->where(array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>1,'dvab.status !='=>0));
		$row = $this->db->get()->row_array();
		return $row['bill_no']+1;
	}
	
	#============================
	
	public function get_vendor_bill($args=array()){

		$vendorBills = array();
		$this->db->select(array('dp.id','dp.bill_no'));
		$this->db->from('dms_purchases as dp');
		$this->db->where("dp.bill_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);	
		$args['conditions']['dp.vendor_id'] = $args['vendor_id'];
		$args['conditions']['dp.branch_id'] = $this->branchID;
		$args['conditions']['dp.payment_mode'] = 2;# creadit sales bill only.
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}
		return $rows = $this->db->get()->result_array();

	}
	
	#============================
	
	public function get_purchase_bill($bill_id){
		
		$this->db->select(array('dp.bill_no','dp.bill_date','dp.group_id','dp.bill_discount_per','dp.bill_discount_amt','dp.bill_freight','dp.other_expense','dp.cess','dpi.item_id','dpi.qty','dpi.rate','dpi.discount_per','dpi.discount_amt','dpi.cst'));
		$this->db->from('dms_purchases as dp');
		$this->db->join('dms_purchase_items as dpi','dp.group_id=dpi.group_id');
		
		$this->db->where(array('dp.id'=>$bill_id,'dp.status'=>1,'dpi.status'=>1,'dpi.item_status >='=>1));
		return $rows = $this->db->get()->result_array();
		
  
		
	}
	
	#============================
	
	public function get_receipt_amount($receiptID){
		
		$this->db->select(array("sum(received_amount) as received_amount",'sum(discount) as discount'));
		$this->db->from('dms_voucher_against_bill_items');
		$this->db->where(array('vid'=>$receiptID,'status'=>1));
		$row = $this->db->get()->row_array();
		#$receipt_amount = $row['received_amount']-$row['discount'];
		return array('amount'=>$row['received_amount'],'discount'=>$row['discount']);
				
	}
	
	#===========================

}
?>