<?php	
class Item_model extends MY_Model{


#--------------------------------------------	
	public function save_vat($data){

		$data['created_by'] = $this->session->userdata('id');
		$data['company_id'] = $this->session->userdata('company_id');
		$data['fiscal_yr_id'] = $this->dms->get_default_fiscal_id();
		
		#take care of MRP
		$args = func_get_args()[0];
		if(!isset($args['item_mrp'])){
			$last = $this->db->get_where('item_vats',array('company_id'=>$data['company_id'],'fiscal_yr_id'=>$data['fiscal_yr_id'],'item_id'=>$data['item_id']))->row_array();
			$data['item_mrp'] = $last['item_mrp'];
		}
		
		#take care of VAT
		if(!isset($args['vat_rate'])){
			$last = $this->db->get_where('item_vats',array('company_id'=>$data['company_id'],'fiscal_yr_id'=>$data['fiscal_yr_id'],'item_id'=>$data['item_id']))->row_array();
			$data['vat_rate'] = $last['vat_rate'];
		}		

		#save new VAT amount
		$this->db->insert('item_vats',$data);
		#echo $this->db->last_query();
		return true;
	}

#-----------------------------------------	

	public function get_item_type_id($item_type,$company_id){

		$type = $this->db->get_where('item_type_master',array('item_type'=>$item_type,'company_id'=>$company_id))->row_array();
	
		if(empty($type)){
			$this->db->insert('item_type_master',array('item_type'=>$item_type,'company_id'=>$company_id,'created_by'=>$this->session->userdata('id')));
			return $this->db->insert_id();
		}else{
			return $type['id'];
		}
	}
#-----------------------------------------	

	public function get_manufacturer_name($manu_name,$company_id){

		$manus = $this->db->get_where('item_manufacturer_master',array('manufacturer_name'=>$manu_name,'company_id'=>$company_id))->row_array();
		if(empty($manus)){
			$this->db->insert('item_manufacturer_master',array('manufacturer_name'=>$manu_name,'company_id'=>$company_id,'created_by'=>$this->session->userdata('id')));
			return $this->db->insert_id();
		}else{
			return $manus['id'];
		}
	}

#-----------------------------------------

	public function save($item,$vat,$primary_unit,$alt_units){

		$company_id = $this->session->userdata('company_id');

		#save item type details
		$item['item_type_id'] = $this->get_item_type_id($item['item_type_id'],$company_id);
		$item['item_manufacturer_id'] = $this->get_manufacturer_name($item['item_manufacturer_id'],$company_id);
		
		#save item details
		$item['company_id'] = $company_id;

		#get default fiscal yr.
		$fiscal_yr_id = $this->dms->get_default_fiscal_id();
		$item['fiscal_yr_id'] = $fiscal_yr_id;

		//echo '<pre>';print_r($item);die;


		$this->f_save('item_master',$item);
	    #echo $this->db->last_query();
		
		#save item vat details
		$vat['item_mrp'] = $item['opening_rate'];
		$vat['item_id'] = $this->db->insert_id();
		$this->save_vat($vat);
		#echo $this->db->last_query();
		#save item unit details
		$this->save_item_units($vat['item_id'],$primary_unit,$alt_units);
		return $vat['item_id'];


	}

#--------------------------------------------

	#date : 02-07-2014
	#purpose : save item units with items
	public function save_item_units($item_id,$primary_unit,$alt_units){

		#save primary unit
		$this->db->insert('item_units',array('item_id'=>$item_id,'unit_id'=>$primary_unit,'status'=>'primary'));

		#save secondary units
		foreach($alt_units as $unit)
			$this->db->insert('item_units',array('item_id'=>$item_id,'unit_id'=>$unit,'status'=>'alternate'));
		return true;
	}	

#-------------------------------------------	

	#date : 11-6-2014
	#purpose : update product item data
	public function update($id,$item,$company_id){

		#save item type details
		$item['item_type_id'] = $this->get_item_type_id($item['item_type_id'],$company_id);
		$item['item_manufacturer_id'] = $this->get_manufacturer_name($item['item_manufacturer_id'],$company_id);
		
		#save item details
		$item['created_by'] = $this->session->userdata('id');
		$item['company_id'] = $company_id;
		$this->db->update('item_master',$item,array('id'=>$id));
	
		return true;

	}

#-------------------------------------------	


	public function get_all($conditions=NULL,$total=0,$limit=0,$offset=0){

		$this->db->select(array('item.*','manu.manufacturer_name','type.item_type','unit.symbol','unit.formal_name'));
		$this->db->from('item_master item');
		$this->db->join('item_manufacturer_master manu','manu.id=item.item_manufacturer_id');
		$this->db->join('item_type_master type','type.id=item.item_group_id');
		$this->db->join('unit_master unit','unit.id=item.unit_id');
		//$this->db->where('unit.status','primary');
		$this->db->where('item.status',1);
		$this->db->where('item.company_id',$this->session->userdata('company_id'));

		if($conditions){
			foreach($conditions as $key=>$value){
				$this->db->where($key,$value);
			}
		}

		if($total != 0){ return $this->db->get()->num_rows(); }
                 
		if($offset != 0){
			$this->db->limit($offset,$limit);
		}
			return $this->db->get()->result_array();
			#echo $this->db->last_query();

	}

	#--------------------------------------------
	
	public function get_vstok($conditions=NULL,$total=0,$limit=0,$offset=0){

		$this->db->select(array('item.*','manu.item_code','manu.item_name'));
		$this->db->from('item_stock item');
		$this->db->join('item_master manu','manu.id=item.item_id');
		//$this->db->where('unit.status','primary');
		$this->db->where('item.branch_id',$this->session->userdata('under_id'));
		$this->db->where('item.company_id',$this->session->userdata('company_id'));
       
		if($conditions){
			foreach($conditions as $key=>$value){
				$this->db->where($key,$value);
			}
		}

		if($total != 0){ return $this->db->get()->num_rows(); }
                 
		if($offset != 0){
			$this->db->limit($offset,$limit);
		}
			return $this->db->get()->result_array();
			#echo $this->db->last_query();

	}
	
	
	
	
	#---------------------------------------------

	public function get_item_types($conditions=NULL,$total=0,$limit=0,$offset=0){

		$fiscal_yr_id = $this->dms->get_default_fiscal_id();
		$company_id = $this->session->userdata('company_id');

		$this->db->select(array('typ.*','users.fname','users.lname'))->from('item_type_master typ');
		$this->db->join('users','users.id=typ.created_by');
		//$this->db->where('typ.fiscal_yr_id',$fiscal_yr_id );
		$this->db->where('typ.company_id',$company_id);
		$this->db->where('typ.status',1);

		if($conditions){
			foreach ($conditions as $key => $value) {
				$this->db->where($key,$value);
			}
		}

		if($total != 0){ return $this->db->get()->num_rows(); }

		if($offset != 0){ return $this->db->limit($offset,$limit)->get()->result_array(); }

	}

	#--------------------------------------------
	#get manufacturers
	public function get_manus($conditions=NULL,$total=0,$limit=0,$offset=0){

	
		$fiscal_yr_id = $this->dms->get_default_fiscal_id();
		$company_id = $this->session->userdata('company_id');

		$this->db->select(array('mans.*','users.fname','users.lname'))->from('item_manufacturer_master mans');
		$this->db->join('users','users.id=mans.created_by','LEFT');
		//$this->db->where('mans.fiscal_yr_id',$fiscal_yr_id);
		$this->db->where('mans.company_id',$company_id);
		$this->db->where('mans.status',1);

		if($conditions){
			foreach ($conditions as $key => $value) {
				$this->db->where($key,$value);
			}
		}

		if($total != 0){ return $this->db->get()->num_rows(); }

		if($offset != 0){ 
			return $this->db->limit($offset,$limit)->get()->result_array(); 
		}

	}

	#--------------------------------------------

		#date : 17-6-2014
		#purpose : listing the products
		public function listing($conditions = NULL){

			$company_id = $this->session->userdata('company_id');
			//$fiscal_yr_id = $this->dms->get_default_fiscal_id();

			$conditions['company_id'] = $company_id;
			$conditions['status'] = 1;
			$rows = $this->db->select(array('id','item_name','item_code','model_no'))->get_where('item_master',$conditions)->result_array();

			$items = array();
			foreach($rows as $row){ $items[$row['id']] = $row['item_code'].' / '.$row['item_name'].' / '.$row['model_no']; }
			return $items;

		}


	#----------------------------------------------

		#date : 05-07-2014
		#purpose : get all units of a particular item
		public function get_units($item){

			$this->db->select('unit_id');
			$this->db->from('item_master');
			$this->db->where('id',$item);
			$item_unit = $this->db->get()->row_array();

			$this->db->select(array('id','symbol'));
			$this->db->from('unit_master');
			$this->db->or_where(array('id'=>$item_unit['unit_id'],'first_unit'=>$item_unit['unit_id'],'second_unit'=>$item_unit['unit_id']));
			$rows = $this->db->get()->result_array();

			$unit =array();
			foreach($rows as $row){
				$unit[$row['id']] = $row['symbol'];
			}
			return $unit;
		}

	#----------------------------------------------	

		#date : 22-7-2014
		#purpose : list all units for this item
		public function list_units($item){

			$this->db->select(array('u.id','iu.status','u.symbol'));
			$this->db->from('item_units iu');
			$this->db->join('unit_master u','iu.unit_id=u.id');
			$this->db->where('iu.item_id',$item);
			$this->db->order_by('iu.status','DESC');

			$units = array();
			foreach($this->db->get()->result_array() as $u){ $units[$u['id']] = $u['symbol'];}
			return $units;
		}
#-----------------------------------------------------






	#--------------------------------------------------	

		#date : 05-07-2014
		#purpose : get all VATs for a particular item
		public function get_vats($item){

			$this->db->select(array('v.*','u.fname','u.lname'));
			$this->db->from('item_vats v');
			$this->db->join('users u','v.created_by=u.id');
			$this->db->where('v.item_id',$item);
			$this->db->order_by('v.created_on','DESC');
			return $this->db->get()->result_array();
		}

	#-----------------------------------------------

		#date : 10-07-2014
		#purpose : get current VAT rate of an Item
		public function get_vat($item_id){
			$conditions = array('item_id'=>$item_id,'company_id'=>$this->session->userdata('company_id'),'fiscal_yr_id'=>$this->session->userdata('fiscal_yr_id'));
			return $this->db->get_where('item_vats',$conditions)->row_array();

		}

	#------------------------------------------------
		#date:10-07-2014
		#purpose:update item units
		public function update_item_units($item_id,$primary_unit,$alt_units){

			#update primary units
			$check_units = $this->db->select()->get_where('item_units',array('unit_id'=>$primary_unit,'status'=>'primary','item_id'=>$item_id))->row_array();
			
			if(empty($check_units)){

				#delete existing primary 
				$this->db->delete('item_units',array('item_id'=>$item_id,'status'=>'primary'));

				#add new one
				$this->db->insert('item_units',array('item_id'=>$item_id,'unit_id'=>$primary_unit,'status'=>'primary'));
			}

			
		#update alternate units---------
			
			#get posted alternatae units
			$posted_units =$alt_units;

			#get existed alternate units
			$existed_units = $this->db->select('unit_id')->get_where('item_units',array('status'=>'alternate','item_id'=>$item_id))->result_array();
			

			#delete removed alterante units
			foreach($existed_units as $e_unit){

				if(!in_array($e_units,$posted_units)){

					$this->db->delete('item_units',array('unit_id'=>$e_unit['unit_id'],'item_id'=>$item_id));
				}
			}

			#add new alternate units
			foreach($posted_units as $p_unit){

				if(!in_array($p_unit,$existed_units)){

					$status = $this->is_primary_unit($p_unit,$item_id);
					if($status!='primary'){
						
						$this->db->insert('item_units',array('item_id'=>$item_id,'unit_id'=>$p_unit,'status'=>'alternate'));
					}
				}
			}

			return true;

		}
	#------------------------------------------------

		#date : 13-8-2014
		#purpose : calculate total amount based on item_id,unit selected
		# $r_unit = requested unit
		public function get_total_amount($item_id,$r_unit,$qty){

			#get current item price
			$price = $this->get_current_price($item_id);
			
			#get 'per-unit' from item_master
			$per_unit = $this->get_per_unit($item_id);
			
			#echo '>>'.$per_unit.' <---> '.$r_unit;die;
			
			#get unit conversion amount
			if($per_unit == $r_unit){
				$conversion = 1; 
			}else{
				$conversion = 2;
				#$conversion =  $this->unit->get_conversion_unit_to_primary($r_unit,$per_unit);
			}    
			
			$total_amount = $price['current_price'] * $conversion;
			
			#get VAT rate
			$vat = $this->get_vat($item_id)['vat_rate'];
			
			#add VAT rate
			$total_amount = $total_amount + ($total_amount * ($vat/100));
			$total_amount = $total_amount * $qty;
			return number_format($total_amount,2,'.','');
		}

	#--------------------------------------------------


		#date : 21-8-2014
		#purpose : calculate gross amount based on item_id,unit selected
		# $r_unit = requested unit
		public function get_gross_amount($item_id,$r_unit,$qty){

			#get current item price
			$price = $this->get_current_price($item_id);
			
			#get 'per-unit' from item_master
			$per_unit = $this->get_per_unit($item_id);
			
			#echo '>>'.$per_unit.' <---> '.$r_unit;die;
			
			#get unit conversion amount
			if($per_unit == $r_unit){
				$conversion = 1; 
			}else{
				$conversion = 2;
				#$conversion =  $this->unit->get_conversion_unit_to_primary($r_unit,$per_unit);
			}    
			
			$total_amount = $price['current_price'] * $conversion;
			
			$total_amount = $total_amount * $qty;
			return number_format($total_amount,2,'.','');
		}




	#------------------------------------------------------
		
	#date : 16-8-2014
	#purpose : get per unit & current price
	function get_current_price($item_id){
		return $this->db->select(array('per_unit','current_price'))->from('item_master')->where('id',$item_id)->get()->row_array();
	}	
	
	#--------------------------------------------------
	#date : 16-8-2014
	#purpose : get primary unit of an item
	function get_primary_unit($item_id){
		return $this->db->select('unit_id')->get_where('item_units',array('item_id'=>$item_id,'status'=>'primary'))->row_array()['unit_id'];
	}

	#-------------------------------------------------------


function get_name($item_id){
		return $this->db->select(array('item_name'))->from('item_master')->where('id',$item_id)->get()->row_array();
	}

	#-------------------------------------------------------


function get_model($item_id){
		return $this->db->select(array('model_no'))->from('item_master')->where('id',$item_id)->get()->row_array();
	}

	#-------------------------------------------------------

	#date : 16-08-2014
	#purpose : get 'per unit' for an item
	function get_per_unit($item_id){
			return $this->db->select('per_unit')->get_where('item_master',array('id'=>$item_id))->row_array()['per_unit'];
	}


	#--------------------------------------------------	
		#10-07-2014
		#purpose:check unit_id has status primary or not
		public function is_primary_unit($unit_id,$item_id){

			$this->db->select();
			$this->db->from('item_units');
			$this->db->where(array('unit_id'=>$unit_id,'item_id'=>$item_id,'status'=>'primary'));
			$row = $this->db->get()->row_array();
			//echo $this->db->last_query();
			//print_r($row['status']);die;
			return $row['status'];
		}
	#-----------------------------------------------------
		#18-12-2014
		#purpose: get item type listing
		public function item_group_listing($conditions = NULL){

		$conditions['company_id'] = $this->session->userdata('company_id');
		$conditions['status'] = 1;
		$rows = $this->db->get_where('item_type_master',$conditions)->result_array();

		$manus = array();
		foreach($rows as $row){ $manus[$row['id']] = $row['item_type'];}
		return $manus;
		
	}
	
	public function item_group_listing_branch(){

		$company_id = $this->session->userdata('company_id');
		
		$rows = $this->db->query("select * from item_type_master where company_id='$company_id' and status='1' and id in(1,4)")->result_array();

		$manus = array();
		foreach($rows as $row){ $manus[$row['id']] = $row['item_type'];}
		return $manus;
		
	}
	#-------------------------------------------------------demo
		public function check($item){

			$this->db->select(array('item_code','item_name'));
			$this->db->from('item_master');
			$this->db->where('item_code',$item);
			$item_unit = $this->db->get()->row_array();
			return $item_unit;
		}
	#-------------------------------------------------------demo
		public function stock_register_get_all($args){

			$this->db->select(array('item.*','manu.manufacturer_name','type.item_type','unit.symbol','unit.formal_name'));
			$this->db->from('item_master item');
			$this->db->join('item_manufacturer_master manu','manu.id=item.item_manufacturer_id');
			$this->db->join('item_type_master type','type.id=item.item_group_id');
			$this->db->join('unit_master unit','unit.id=item.unit_id');
			//$this->db->where('unit.status','primary');
			$this->db->where('item.status',1);
			$this->db->where('item.company_id',$this->session->userdata('company_id'));

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
	#-------------------------------------------------------	
                public function tint_listing($conditions = NULL){
			
			$rows = $this->db->get_where('tint_master',$conditions)->result_array();

			$tint = array();
                        $tint[]="Select";
			foreach($rows as $row){ $tint[$row['tint']] = strtoupper($row['tint']);}
			return $tint;
			
		}

                public function shape_listing($conditions = NULL){
			
			$rows = $this->db->get_where('fshape_master',$conditions)->result_array();

			$shape = array();
                        $shape[]="Select";
			foreach($rows as $row){ $shape[$row['shape']] = strtoupper($row['shape']);}
			return $shape;
			
		}
                public function color_listing($conditions = NULL){
			
			$rows = $this->db->query("select distinct(color) from item_master where color != ''")->result_array();

			$color = array();
                        $color[]="Select";
			foreach($rows as $row){ $color[$row['color']] = strtoupper($row['color']);}
			return $color;
			
		}
                	
        			
                public function get_alls($conditions=NULL,$total=0,$limit=0,$offset=0){

		$this->db->select(array('item.*','manu.manufacturer_name','type.item_type','unit.symbol','unit.formal_name'));
		$this->db->from('item_master item');
		$this->db->join('item_manufacturer_master manu','manu.id=item.item_manufacturer_id');
		$this->db->join('item_type_master type','type.id=item.item_group_id');
		$this->db->join('unit_master unit','unit.id=item.unit_id');
		//$this->db->where('unit.status','primary');
		$this->db->where('item.status',1);
		$this->db->where('item.company_id',$this->session->userdata('company_id'));

		if($conditions){
			foreach($conditions as $key=>$value){
				$this->db->where($key,$value);
			}
		}

		if($total != 0){ return $this->db->get()->num_rows(); }
                 
		$this->db->order_by('item.id','ASC');
		$this->db->limit($offset,$limit);
		 
		return $this->db->get()->result_array();
		#echo $this->db->last_query();
	}
	

        function get_types($item_id){
		return $this->db->select(array('item_types'))->from('item_master')->where('id',$item_id)->get()->row_array();
	}
	
	public function itemcode($conditions = NULL){

			$company_id = $this->session->userdata('company_id');

			$conditions['company_id'] = $company_id;
			$conditions['status'] = 1;
			$rows = $this->db->select(array('id','item_code'))->get_where('item_master',$conditions)->result_array();

			$items = array();
			foreach($rows as $row){ $items[$row['item_code']] = $row['item_code']; }
			return $items;
	}
	public function items($conditions = NULL){

			$company_id = $this->session->userdata('company_id');

			$conditions['company_id'] = $company_id;
			$conditions['status'] = 1;
			$rows = $this->db->select(array('id,item_name'))->get_where('item_master',$conditions)->result_array();

			$items = array();
			foreach($rows as $row){ $items[$row['item_name']] = $row['item_name']; }
			return $items;

		}
	
}

?>