<?php
class Opening_stock_model extends MY_Model{
	
	public function __construct(){
		$this->branchID = $this->session->userdata('under_id');
		$this->companyID = $this->session->userdata('company_id');	
	}
	public function save($data){
		
		return $this->f_save("dms_stocks",$data);
	}
	
	#-------------------------------------------------------------------
	
	public function get($args=array()){
		
		if(!isset($args['select'])){
			$args['select'] = array('id','company_id','godown_id','item_id','qty','unit_id','rate','stock_date','stock_status','created_by');
		}
		
		$this->db->select($args['select']);
		$this->db->from('dms_stocks');
		$this->db->where('status',1);
		
		if(isset($args['conditions'])){
			
			$this->db->where($args['conditions']);			
		}
		
		#-- returns total number of rows
		if(isset($args['num_rows'])){
			return $this->db->count_all_results();
		}
		#-- for order by
		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
			
		}
		#--for limit 
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}			
		return $this->db->get()->result_array();		
		
	}
	
	#--------------------------------------------------------------------------------------
	public function getAll($args=array()){
		
		if(!isset($args['select'])){
			$args['select'] = array('ds.company_id','ds.godown_id','ds.item_id','ds.qty','ds.unit_id','ds.rate','ds.stock_date','ds.stock_status','gm.godown_code','gm.godown_name','im.item_code','im.item_name','im.model_no');
		}
		
		$this->db->select($args['select']);
		$this->db->from('dms_stocks as ds');
		$this->db->join('godown_master as gm','ds.godown_id=gm.id');
		$this->db->join('item_master as im','ds.item_id=im.id');
		$this->db->join('unit_master as um','ds.unit_id=um.id');
		
		$this->db->where(array('ds.status'=>1,'gm.branch_id'=>$this->branchID));
		
		if(isset($args['conditions'])){
			
			$this->db->where($args['conditions']);			
		}
		
		#-- returns total number of rows
		if(isset($args['num_rows'])){
			return $this->db->count_all_results();
		}
		#-- for order by
		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
			
		}
		#--for limit 
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}			
		return $this->db->get()->result_array();		
		
	}
	
	#------------------------------------------------------------------------	
	
	public function update($data,$id){
		
		if($this->update_a(array('table'=>'dms_stocks','data'=>$data,'conditions'=>array('id'=>$id)))){
			return true;
		}
		return false;
	}
	
	#------------------------------------------------------------------------
	
	public function save_opening_balance($data){
		
		return $this->f_save("dms_stock_open_bals",$data);		
	}
	
	#------------------------------------------------------------------------
	
	public function get_opening_balance($args){
		if(!isset($args['select'])){
			$args['select'] = array('id','company_id','branch_id','open_amount','open_date');
		}
		
		$this->db->select($args['select']);
		$this->db->from('dms_stock_open_bals');
		$this->db->where('status',1);

		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);			
		}
		
		#-- returns total number of rows
		if(isset($args['num_rows'])){
			return $this->db->count_all_results();
		}
		#-- for order by
		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
			
		}
		#--for limit 
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}

		return $this->db->get()->result_array();			
	}
	
	#------------------------------------------------------------------------
	
	public function update_opening_balance($data,$conditions){
		if($this->update_a(array('table'=>'dms_stock_open_bals','data'=>$data,'conditions'=>$conditions))){
			return true;
		}
		return false;		
	}
	
	#-------------------------------------------------------------------------
	public function update_stock_qty($data,$conditions){
		if($this->update_a(array('table'=>'item_stock','data'=>$data,'conditions'=>$conditions))){
			return true;
		}
		return false;		
	}
	
	#------------------------------------------------------------------------
}

?>