<?php
class Purchase_order_model extends MY_Model{
	
	#============================
	
	public function __construct(){
		
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
				
	}
		
	#============================
	
	public function save_purchase_order($data){
		
		if($this->f_save("dms_purchase_orders",$data)){
			return true;
		}
		return false;
				
	}
		
	#============================
	
	public function save_purchase_order_item($data){
		
		if($this->f_save("dms_purchase_items",$data)){
			return true;
		}
		return false;
					
	}
        
        #============================

        public function save_purchase_order_items($data){
		
		if($this->f_save("dms_purchase_items1",$data)){
			return true;
		}
		return false;
					
	}

	#============================
	
	public function get($args = array()){
		
		if(!isset($args['select'])){
			$args['select'] = array();
		}
		if(isset($args['from_date'])){$fromDate = $args['from_date'];}else{$fromDate = $this->fiscal_start_date;}
		if(isset($args['to_date'])){$toDate = $args['to_date'];}else{$toDate = $this->fiscal_end_date;}
		
		$args['conditions']['dpo.status'] = 1;
		$args['conditions']['dpo.branch_id'] = $this->branchID;
		$this->db->select($args['select'])->from('dms_purchase_orders as dpo');
		
		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}
		
		$this->db->where("dpo.po_date between '".$fromDate."' and '".$toDate."'",NULL,true);		
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
		}

		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		#$this->db->get();echo $this->db->last_query();die;
		return $this->db->get()->result_array();		
	}
	
	#============================
	
	public function delete_item($poItmID){
		
		$this->db->select(array('group_id'));
		$this->db->from('dms_purchase_items');
		$this->db->where(array('id'=>$poItmID));
		
		$rows = $this->db->get()->row_array();
		$po_groupID = $rows['group_id'];
		
		$this->db->from('dms_purchase_items');
		$this->db->where(array('group_id'=>$po_groupID,'status'=>1));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->my_update('dms_purchase_orders',array('status'=>0),array('group_id'=>$po_groupID));
		}
		
		if($this->my_update('dms_purchase_items',array('status'=>0),array('id'=>$poItmID))){
			return true;
		}
		return true;			
	}

        #=================================

        public function delete_items($poItmID){
		
		$this->db->select(array('group_id'));
		$this->db->from('dms_purchase_items1');
		$this->db->where(array('id'=>$poItmID));
		
		$rows = $this->db->get()->row_array();
		$po_groupID = $rows['group_id'];
		
		$this->db->from('dms_purchase_items1');
		$this->db->where(array('group_id'=>$po_groupID,'status'=>1));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->my_update('dms_purchase_orders',array('status'=>0),array('group_id'=>$po_groupID));
		}
		
		if($this->my_update('dms_purchase_items1',array('status'=>0),array('id'=>$poItmID))){
			return true;
		}
		return true;			
	}
	
	#==================================
	
	public function check_po_number($po_no){
		
		$this->db->select('id');
		$this->db->from('dms_purchase_orders');
		$this->db->where(array('branch_id'=>$this->branchID,'po_no'=>$po_no,'status'=>1));
		$this->db->where("po_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		if(empty($this->db->get()->num_rows())){
			return true;
		}
		return false;
				
	}	
	
	#==================================	
	
	public function update_po_item($data,$conditions){
		if($this->my_update('dms_purchase_items',$data,$conditions)){
			return true;
		}
		return false;
	}

        #==================================

        public function update_po_items($data,$conditions){
		if($this->my_update('dms_purchase_items1',$data,$conditions)){
			return true;
		}
		return false;
	}
	
	#==================================	

	public function update_po($data,$conditions){
		if($this->my_update('dms_purchase_orders',$data,$conditions)){
			return true;
		}
		return false;
	}
	
	#==================================	
	
	public function get_po_status($poID){
		
		$args = array();
		$args['select'] = array('dpo.group_id','dpo.branch_id','dpo.po_date');
		$args['conditions'] = array('dpo.id'=>$poID);
		$po_details = $this->get($args);
		
		if(!empty($po_details)){

			$receiptNotes = $purchases = array();
			$po_group_id = $po_details[0]['group_id'];
			$po_date = $po_details[0]['po_date'];
			
			#---check receipt note------
			$this->db->select(array('id','pid'));
			$this->db->from('dms_receipt_notes');
			$this->db->where(array('group_id'=>$po_group_id,'status !='=>0));
			$receiptNotes = $this->db->get()->row_array();

			#---check sales bill-----------
			$this->db->select(array('id','pid'));
			$this->db->from('dms_purchases');
			$this->db->where(array('group_id'=>$po_group_id,'status !='=>0));
			$purchases = $this->db->get()->row_array();

			if(!empty($receiptNotes) || !empty($purchases)){
				return false;
			}else{
				return true;
			}
		}
	}
		
	#==========================================				
}
?>