<?php
class Purchase_request_model extends MY_Model{
	
	#--------------------------------------------------------
	
	public function __construct(){
		$this->companyID = $this->session->userdata('company_id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];		
	}
	
	#--------------------------------------------------------
	
	public function save_temp_data($data){
		if($this->f_save('dms_purchase_request_temps',$data)){
			return true;
		}
		return false;
	}
	
	#--------------------------------------------------------
	
	public function get_temp_data($conditions=array()){
		
		$this->db->select(array('dprt.*','im.item_code','im.item_name','im.model_no','um.symbol'));
		$this->db->from('dms_purchase_request_temps as dprt');
		$this->db->join('item_master as im','dprt.item_id=im.id');
		$this->db->join('unit_master as um','dprt.unit_id=um.id');
		
		if(!empty($conditions)){
			$this->db->where($conditions);
		}
		
		return $this->db->get()->result_array();
		
	}
	
	#--------------------------------------------------------
	
	public function delete_temp_data($tempID){
		if($this->db->delete('dms_purchase_request_temps',array('id'=>$tempID))){
			return true;
		}
		return false;
	}
	
	#--------------------------------------------------------
	
	public function get_request_number($conditions){
		
		$this->db->select_max('request_no');
		$this->db->from('dms_purchase_requests');
		$conditions['company_id'] = $this->companyID;
		$conditions['status'] = 1;
		$this->db->where($conditions);
		$this->db->where("request_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		
		$row = $this->db->get()->row_array();
		return $row['request_no']+1;

	}
	
	#--------------------------------------------------------
	
	public function save_request($data){
		
		if($this->f_save('dms_purchase_requests',$data)){
			
			return true;
		}
		return false;		
	}
	
	#--------------------------------------------------------
	
	public function save_request_items($data){
		if($this->f_save('dms_purchase_request_items',$data)){
			return true;
		}
		return false;		
	}
	
	#--------------------------------------------------------
	
	public function get_purchase_request($args){
		
		if(!isset($args['select'])){
			$args['select'] = array('dpr.id','dpr.requested_by','dpr.request_no','dpr.my_req_no','dpr.request_date','dpr.delivery_date','dpr.remarks','dpr.req_status');
		}
		
		$this->db->select($args['select']);
		$this->db->from('dms_purchase_requests as dpr');
		
		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}
				
		$this->db->where(array('dpr.status'=>1,'dpr.company_id'=>$this->companyID));
		$this->db->where("dpr.request_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}
		
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
		}

		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		#$this->db->get();echo $this->db->last_query();die;
		return $this->db->get()->result_array();
	}
	
	#---------------------------------------------------------
	
	
	public function delete_request_items($reqItmID){
		
		$this->db->select(array('pr_id'));
		$this->db->from('dms_purchase_request_items');
		$this->db->where(array('id'=>$reqItmID));
		$rows = $this->db->get()->row_array();
		$requestID = $rows['pr_id'];

		$this->db->select('id');
		$this->db->from('dms_purchase_request_items');
		$this->db->where(array('pr_id'=>$requestID,'status'=>1));
		$totalitems = $this->db->get()->num_rows();
		
		if($totalitems == 1){
			$this->my_update('dms_purchase_requests',array('status'=>0),array('id'=>$requestID));
		}
		
		if($this->my_update('dms_purchase_request_items',array('status'=>0),array('id'=>$reqItmID))){
			return true;
		}
		return true;	
		
	}

	#-------------------------------------------------------------------------------------	
	
	public function update_request_items($data,$conditions){
		
		if($this->my_update('dms_purchase_request_items',$data,$conditions)){
			return true;
		}
		return false;
				
	}
	
	#-------------------------------------------------------------------------------------
	
	public function update_request($data,$conditions){
		
		if($this->my_update('dms_purchase_requests',$data,$conditions)){
			return true;
		}
		return false;
				
	}
	
	#------------------------------------------------------------------------------------
	
	#------------------------------------------------------------------------------------
}
?>