<?php
class Receipt_against_bill_model extends MY_Model{

	#============================

	public function __construct(){

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];

	}

	#============================

	public function save_bill($data){
		if($this->f_save("dms_voucher_against_bills",$data)){
			return true;
		}
		return false;
	}

	#============================

	public function save_bill_items($data){
		if($this->f_save("dms_voucher_against_bill_items",$data)){
			return true;
		}
		return false;
	}

	#============================

	public function update($data,$conditions){
		if($this->my_update('dms_voucher_against_bills',$data,$conditions)){
			return true;
		}
		return false;
	}

	#============================

	public function update_receipt_item($data,$conditions){
		if($this->my_update('dms_voucher_against_bill_items',$data,$conditions)){
			return true;
		}
		return false;
	}

	#============================

	public function delete_item($dvabi_id){

		$this->db->select(array('vid'));
		$this->db->from('dms_voucher_against_bill_items');
		$this->db->where(array('id'=>$dvabi_id));

		$rows = $this->db->get()->row_array();
		$vid = $rows['vid'];

		$this->db->from('dms_voucher_against_bill_items');
		$this->db->where(array('vid'=>$vid));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->db->delete('dms_voucher_against_bills',array('id'=>$vid));
		}

		if($this->db->delete('dms_voucher_against_bill_items',array('id'=>$dvabi_id))){
			return true;
		}




		if($this->db->delete('dms_voucher_against_bill_items',array('id'=>$dvabi_id))){
			return true;
		}
		return false;

	}

	#============================

	public function get($args = array()){

		if(!isset($args['select'])){
			$args['select'] = array('dvab.*');
		}
		$this->db->select($args['select']);
		$this->db->from('dms_voucher_against_bills as dvab');

		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}
		if(isset($args['between'])){
			$fromDate = $args['between'][0];$toDate = $args['between'][1];
		}else{
			$fromDate = $this->fiscal_start_date;$toDate = $this->fiscal_end_date;
		}
		$this->db->where("dvab.bill_date between '".$fromDate."' and '".$toDate."'",NULL,true);
		if(!isset($args['conditions']['dvab.status'])){
			$args['conditions']['dvab.status'] = 1;
		}
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		#-- returns total number of rows---------------------
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}
		$this->db->order_by('dvab.bill_date','desc');

		#-- for order by------------------------------------------
		if(isset($args['order_by'])){
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
		}

		#--for limit ----------------------------------------------
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		#$this->db->get()->result_array();echo $this->db->last_query();die;

		return $this->db->get()->result_array();
	}

	#============================
	public function get_receipt_number(){

		$this->db->select_max('bill_no');
		$this->db->from('dms_voucher_against_bills as dvab');
		$this->db->where("dvab.bill_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$this->db->where(array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>0,'dvab.status !='=>0));

		$row = $this->db->get()->row_array();
		return $row['bill_no']+1;
	}

	#============================

	public function get_customer_bill($args=array()){

		$customerBills = array();
		$this->db->select(array('ds.id','ds.bill_no'));
		$this->db->from('dms_sales as ds');
		$this->db->where("ds.bill_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$args['conditions']['ds.customer_type_id'] = $args['customer_type_id'];
		$args['conditions']['ds.customer_id'] = $args['customer_id'];
		$args['conditions']['ds.branch_id'] = $this->branchID;
		$args['conditions']['payment_mode'] = 2;# creadit sales bill only.
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}
		return $rows = $this->db->get()->result_array();

	}

	#============================

	public function get_bill_amount($bill_id){

		$this->db->select(array('ds.bill_no','ds.bill_date','ds.group_id','ds.bill_discount_per','ds.bill_discount_amt','ds.bill_freight','ds.other_expense','ds.cess','dsi.item_id','dsi.qty','dsi.rate','dsi.amount','dsi.discount_per','dsi.discount_amt','dsi.vat_amt','dsi.cst'));
		$this->db->from('dms_sales as ds');
		$this->db->join('dms_sales_items as dsi','ds.group_id=dsi.group_id');

		$this->db->where(array('ds.id'=>$bill_id,'ds.status'=>1,'dsi.status'=>1,'dsi.item_status >='=>1));
		return $rows = $this->db->get()->result_array();
	}
      
        public function get_bill_amounts($bill_id){

		$this->db->select(array('ds.bill_no','ds.bill_date','ds.group_id','ds.bill_discount_per','ds.bill_discount_amt','ds.bill_freight','ds.other_expense','ds.cess','dsi.item_id','dsi.qty','dsi.rate','dsi.amount','dsi.discount_per','dsi.discount_amt','dsi.cgst_amt','dsi.sgst_amt'));
		$this->db->from('dms_sales as ds');
		$this->db->join('dms_sales_items1 as dsi','ds.group_id=dsi.group_id');

		$this->db->where(array('ds.id'=>$bill_id,'ds.status'=>1,'dsi.status'=>1,'dsi.item_status >='=>1));
		return $rows = $this->db->get()->result_array();
	}

	#============================

	public function get_receipt_amount($receiptID){

		$this->db->select(array("sum(received_amount) as received_amount",'sum(discount) as discount'));
		$this->db->from('dms_voucher_against_bill_items');
		$this->db->where(array('vid'=>$receiptID,'status'=>1));
		$row = $this->db->get()->row_array();
		#$receipt_amount = $row['received_amount']-$row['discount'];
		return array('amount'=>$row['received_amount'],'discount'=>$row['discount']);

	}

	#===========================+
}
?>