<?php
Class Salary_model extends MY_Model{
	
	#_______________________________________________

	public function __construct(){

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');

	}

	#_______________________________________________

	public function save($table,$data){

		if($this->f_save($table,$data)){
			return true;
		}
		return false;

	}

	#_______________________________________________

	public function get($args) {


		$this->db->select($args['select']);
		$this->db->from($args['from']);
		$this->db->where($args['conditions']);
		if(isset($args['or_where_string'])){
			if(is_array($args['or_where_string'])){
				foreach($args['or_where_string'] as $key => $or_where_string){
					$this->db->or_where("($or_where_string )",NULL,true);	
				}
			}else{
				$this->db->or_where("($args[or_where_string])",NULL,true);	
			}
			
		}

		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}

		#$this->db->get()->result_array();echo $this->db->last_query();die;
		return $this->db->get()->result_array();

	}

	#_______________________________________________

	public function update($table,$data,$conditions){

		if($this->my_update($table,$data,$conditions)){
			return true;
		}
		return false;


	}

	#______________________________________________

	public function delete($table,$conditions)
	{
		if($this->db->delete($table,$conditions)){
			return true;
		}
		return false;
	}

	#_______________________________________________


	public function get_driver_salary($args){

		if(!isset($args['select'])){
			$args['select'] = array();
		}
		$this->db->select($args['select']);
		$this->db->from('dms_driver_salary as dds');

		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}
		if(isset($args['between'])){
			$from_date = $args['between']['from_date'];
			$to_date = $args['between']['to_date'];
			$this->db->where($args['between']['column']." between '".$from_date."' and '".$to_date."'",NULL,true);
		}
		
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		#-- returns total number of rows---------------------
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		#-- for order by------------------------------------------
		if(isset($args['order_by'])){
			if(!isset($args['order'])){$args['order'] = 'asc';}
			if(!is_array($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}else{
				foreach($args['order_by'] as $order_field=>$order){
					$this->db->order_by($order_field,$order);
				}
			}
		}


		#--for limit ----------------------------------------------
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}

		#$this->db->get()->result_array();echo $this->db->last_query();die;
		return $this->db->get()->result_array();

	}

	#__________________________________________________________________


	public function get_driver_bills($driver_id,$from_date,$to_date){

		
		#------ get driver's sales bills -------------------------
		$this->db->select(array('ds.id','ds.bill_no','ds.bill_date','ds.customer_type_id','ds.customer_id','ds.vtype_id','ds.group_id','dsv.vehicle_rent','rm.route_name','dvt.vtype as voucher_type'))->from('dms_sales as ds');
		$this->db->join('dms_sales_vehicles as dsv','ds.group_id=dsv.group_id','left');
		$this->db->join('route_master as rm','dsv.route_id=rm.id','left');
		$this->db->join('vehicle_master as vm','dsv.vehicle_id=vm.id','left');
		#$this->db->join('dms_salary_percentages as dsp','vm.vehicle_type_id=dsp.vehicle_type_id','left');
		$this->db->join('dms_voucher_types as dvt','ds.vtype_id=dvt.id','left');
		$this->db->where("ds.bill_date between '".$from_date."' and '".$to_date."'",NULL,true);
		$this->db->where(array('ds.status'=>1,'dsv.driver_id'=>$driver_id,'vm.company_id'=>$this->companyID,'rm.company_id'=>$this->companyID));
		#'dvt.company_id'=>$this->companyID,
		$sales = $this->db->get()->result_array();


		#------ get driver's delivery notes ----------------------
		$this->db->select(array('ddn.id','ddn.bill_no','ddn.bill_date','ddn.customer_type_id','ddn.customer_id','ddn.vtype_id','ddn.group_id','dsv.vehicle_rent','rm.route_name','dvt.vtype as voucher_type'))->from('dms_delivery_notes as ddn');#'dsp.id as salary_percent_id','dsp.percentage'
		$this->db->join('dms_sales_vehicles as dsv','ddn.group_id=dsv.group_id','left');
		$this->db->join('route_master as rm','dsv.route_id=rm.id','left');
		$this->db->join('vehicle_master as vm','dsv.vehicle_id=vm.id','left');
		#$this->db->join('dms_salary_percentages as dsp','vm.vehicle_type_id=dsp.vehicle_type_id','left');
		$this->db->join('dms_voucher_types as dvt','ds.vtype_id=dvt.id','left');
		$this->db->where("ds.bill_date between '".$from_date."' and '".$to_date."'",NULL,true);
		$this->db->where(array('ddn.status'=>1,'dsv.driver_id'=>$driver_id,'ds.d_status'=>0,'vm.company_id'=>$this->companyID,'rm.company_id'=>$this->companyID));
		#'dsp.company_id'=>$this->companyID;
		$delivery_notes = $this->db->get()->result_array();		

		#------ get driver's purchase bills -----------------------
		$this->db->select(array('dp.id','dp.bill_no','dp.bill_date','dp.vtype_id','dp.group_id','dp.vendor_id','dpv.vehicle_rent','rm.route_name','dvt.vtype as voucher_type'))->from('dms_purchases as dp');#,'dsp.id as salary_percent_id','dsp.percentage'
		$this->db->join('dms_purchase_vehicles as dpv','dp.group_id=dpv.group_id','left');
		$this->db->join('route_master as rm','dpv.route_id=rm.id','left');
		$this->db->join('vehicle_master as vm','dpv.vehicle_id=vm.id','left');
		#$this->db->join('dms_salary_percentages as dsp','vm.vehicle_type_id=dsp.vehicle_type_id','left');
		$this->db->join('dms_voucher_types as dvt','dp.vtype_id=dvt.id','left');
		$this->db->where("dp.bill_date between '".$from_date."' and '".$to_date."'",NULL,true);
		$this->db->where(array('dp.status'=>1,'dpv.driver_id'=>$driver_id,'vm.company_id'=>$this->companyID,'rm.company_id'=>$this->companyID));
		#'dsp.company_id'=>$this->companyID,
		$purchases = $this->db->get()->result_array();	


		#------- get driver's receipt notes ----------------------
		$this->db->select(array('drn.id','drn.bill_no','drn.bill_date','drn.vtype_id','drn.group_id','drn.vendor_id','dpv.vehicle_rent','rm.route_name','dvt.vtype as voucher_type'))->from('dms_receipt_notes as drn');
		#,'dsp.id as salary_percent_id','dsp.percentage'
		$this->db->join('dms_purchase_vehicles as dpv','drn.group_id=dpv.group_id','left');
		$this->db->join('route_master as rm','dpv.route_id=rm.id','left');
		$this->db->join('vehicle_master as vm','dpv.vehicle_id=vm.id','left');
		#$this->db->join('dms_salary_percentages as dsp','vm.vehicle_type_id=dsp.vehicle_type_id','left');
		$this->db->join('dms_voucher_types as dvt','drn.vtype_id=dvt.id','left');
		$this->db->where("drn.bill_date between '".$from_date."' and '".$to_date."'",NULL,true);
		$this->db->where(array('drn.status'=>1,'drn.r_status'=>0,'dpv.driver_id'=>$driver_id,'vm.company_id'=>$this->companyID,'rm.company_id'=>$this->companyID));
		#'dsp.company_id'=>$this->companyID,

		$receipt_notes = $this->db->get()->result_array();			
		return array('sales'=>$sales,'delivery_notes'=>$delivery_notes,'purchases'=>$purchases,'receipt_notes'=>$receipt_notes);
	}
}
?>