<?php
class Quotation_model extends MY_Model{
	
	#--------------------------------------------------------------------------------
	
	public function __construct(){
		
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');		
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}
	
	#---------------------------------------------------------------------------------
	
	public function save($data){

		$data['branch_id'] = $this->branchID;
		return $this->f_save("dms_quotations",$data);
	}
	
	#-----------------------------------------------------------------------------------
	
	public function save_items($data){
		return $this->f_save("dms_quotations_items",$data);
	}

        #----------------------------------------------------------------------------------- 

        public function save_itemss($data){
		return $this->f_save("dms_quotations_items1",$data);
	}

		
	#-----------------------------------------------------------------------------------
	
	public function save_customer($data){
		
		$data['branch_id'] = $this->branchID;
		$customerID = NULL;
		$this->db->select('id');
		$this->db->from('customer_master');
		$this->db->where(array('mobile_no'=>$data['mobile_no'],'status !='=>0));
		$customer = $this->db->get()->row_array();
		if(empty($customer)){
			$this->f_save("customer_master",$data);
			$customerID = $this->db->insert_id();
		}else{
			$customerID = $customer['id'];
		}
		return $customerID;
	}

	#-----------------------------------------------------------------------------------	
		
	public function update($table,$data,$conditions){
		if($this->my_update($table,$data,$conditions)){
			return true;
		}
		return false;
	}

	#-----------------------------------------------------------------------------------
				
	public function delete_temp_item($tempItmID){
		
		$this->db->select(array('qt_id'));
		$this->db->from('dms_quotations_items');
		$this->db->where(array('id'=>$tempItmID));
		$rows = $this->db->get()->row_array();
		$qt_id = $rows['qt_id'];
		
		$this->db->from('dms_quotations_items');
		$this->db->where(array('qt_id'=>$qt_id));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->db->delete('dms_quotations',array('id'=>$qt_id));
		}
		
		if($this->db->delete('dms_quotations_items',array('id'=>$tempItmID))){
			return true;
		}
				
	}

      
        public function delete_temp_items($tempItmID){
		
		$this->db->select(array('qt_id'));
		$this->db->from('dms_quotations_items1');
		$this->db->where(array('id'=>$tempItmID));
		$rows = $this->db->get()->row_array();
		$qt_id = $rows['qt_id'];
		
		$this->db->from('dms_quotations_items1');
		$this->db->where(array('qt_id'=>$qt_id));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->db->delete('dms_quotations',array('id'=>$qt_id));
		}
		
		if($this->db->delete('dms_quotations_items1',array('id'=>$tempItmID))){
			return true;
		}
				
	}



	
	#-----------------------------------------------------------------------------------	
	
	public function get($args=array()){
		
		if(!isset($args['select'])){
			$args['select'] = array('dq.id','dq.branch_id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_status');
		}
		
		$this->db->select($args['select']);
		$this->db->from('dms_quotations as dq');
		
		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}
		$args['conditions']['dq.branch_id'] = $this->branchID;
		$this->db->where($args['conditions']);
		
		$fromDate = (isset($args['from_date']))? $args['from_date']:$this->fiscal_start_date;
		$toDate = (isset($args['to_date']))? $args['to_date']:$this->fiscal_end_date;
		
		$this->db->where("dq.qt_date between '".$fromDate."' and '".$toDate."'",NULL,true);		
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		if(isset($args['order_by'])){
			if(!isset($args['order'])){$args['order'] = 'asc';}
			if(!is_array($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}else{
				foreach($args['order_by'] as $order_field=>$order){
					$this->db->order_by($order_field,$order);
				}
			}
		}else{
			$this->db->order_by('dq.qt_date','desc');
			$this->db->order_by('dq.qt_date','desc');
		}	
			
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();		
	}
	
	#---------------------------------------------------------------------------------
	
	public function get_bill_number($conditions=array()){
		
		$bill_number=1;
		$this->db->select_max('qt_no');
		$this->db->from('dms_quotations');
		$this->db->where(array('branch_id'=>$this->branchID));
		$this->db->where(array('status'=>1));
		$this->db->where("qt_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		if(!empty($conditions)){
			$this->db->where($conditions);
		}
		$row = $this->db->get()->row_array();
		return $bill_number+$row['qt_no'];
	}
	
	#---------------------------------------------------------------------------------
	
	public function check_bill_number($bill_number,$conditions=array()){
		
		$this->db->select('id');
		$this->db->from('dms_quotations');
		$this->db->where(array('qt_no'=>$bill_number));
		$this->db->where(array('branch_id'=>$this->branchID));
		$this->db->where(array('status'=>1));
		$this->db->where("qt_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		if(!empty($conditions)){
			$this->db->where($conditions);
		}		
		$row = $this->db->get()->row_array();
		if(empty($row)){
			return true;
		}
		return false;
		
	}
	
	#----------------------------------------------------------------------------------
	
}?>