<?php

class Sales_order_temp_model extends MY_Model{

	public function __construct(){

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}
	#---------------------------------------------------------------------------------

	public function save_temp_order($data){

		return $this->f_save("dms_sales_order_temp",$data);

	}

	#---------------------------------------------------------------------------------

	public function save_temp_order_items($data){

		return $this->f_save("dms_sales_order_temp_items",$data);

	}

        public function save_temp_order_itemss($data){

		return $this->f_save("dms_sales_order_temp_items1",$data);

	}




	#----------------------------------------------------------------------------------

	public function save_sales_order($data){

		return $this->f_save("dms_sales_orders",$data);

	}

	#----------------------------------------------------------------------------------

	public function save_sales_order_items($data){

		return $this->f_save("dms_sales_items",$data);

	}

        public function save_sales_order_itemss($data){

		return $this->f_save("dms_sales_items1",$data);

	}


	#----------------------------------------------------------------------------------

	public function update($table,$data,$conditions){
		if($this->my_update($table,$data,$conditions)){
			return true;
		}
		return false;
	}

	#----------------------------------------------------------------------------------

	public function get_temp_order($args){

		if(!isset($args['select'])){
			$args['select'] = array('id','branch_id','so_no','so_date','customer_id','pricelist_id','created_by');
		}

		$this->db->select($args['select']);
		$this->db->from('dms_sales_order_temp');
		$this->db->where("so_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$args['conditions']['branch_id'] = $this->branchID;
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}

		#-- returns total number of rows
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}
		return $this->db->get()->result_array();
	}

	#-----------------------------------------------------------------------------------

	public function check_sales_order_number($bill_num){

		$this->db->select('id');
		$this->db->from('dms_sales_orders');
		$this->db->where(array('branch_id'=>$this->branchID,'so_no'=>$bill_num,'status'=>1));
		$this->db->where("so_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		if(empty($this->db->get()->num_rows())){
			return true;
		}
		return false;

	}

	#-----------------------------------------------------------------------------------

	public function get_temp_order_items($args){

		if(!isset($args['select'])){

			$args['select'] = array('dsoti.id','dsoti.so_temp_id','dsoti.item_id','dsoti.godown_id','dsoti.qty','dsoti.unit_id','dsoti.rate','dsoti.amount','dsoti.so_discount_per','dsoti.so_discount_amt','dsoti.vat_percent','dsoti.vat_amt','dsoti.cst','im.item_code','im.item_name','im.model_no','um.formal_name','um.symbol');
		}

		$this->db->select($args['select']);
		$this->db->from('dms_sales_order_temp_items as dsoti');
		$this->db->join('item_master as im','dsoti.item_id=im.id');
		$this->db->join('unit_master as um','dsoti.unit_id=um.id');

		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		#-- returns total number of rows
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		return $this->db->get()->result_array();

	}


        public function get_temp_order_itemss($args){

		if(!isset($args['select'])){

			$args['select'] = array('dsoti.id','dsoti.so_temp_id','dsoti.item_id','dsoti.godown_id','dsoti.qty','dsoti.unit_id','dsoti.rate','dsoti.amount','dsoti.so_discount_per','dsoti.so_discount_amt','dsoti.cgst','dsoti.sgst','dsoti.cgst_amt','dsoti.sgst_amt','im.item_code','im.item_name','um.formal_name','um.symbol');
		}

		$this->db->select($args['select']);
		$this->db->from('dms_sales_order_temp_items1 as dsoti');
		$this->db->join('item_master as im','dsoti.item_id=im.id');
		$this->db->join('unit_master as um','dsoti.unit_id=um.id');

		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		#-- returns total number of rows
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		return $this->db->get()->result_array();

	}















	#-----------------------------------------------------------------------------------

	public function get_sales_order_number(){

		$this->db->select(array('max(so_no) as bill_no'));
		$this->db->from('dms_sales_order_temp');
		$this->db->where(array('branch_id'=>$this->branchID));
		$this->db->where("so_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$row1 = $this->db->get()->row_array();
		$billNum1=0;$billNum2=0;
		if(!empty($row1)){$billNum1 = $row1['bill_no'];}

		$this->db->select(array('max(so_no) as bill_no'));
		$this->db->from('dms_sales_orders');
		$this->db->where(array('branch_id'=>$this->branchID,'status'=>1));
		$this->db->where("so_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$row2 = $this->db->get()->row_array();
		if(!empty($row2)){$billNum2 = $row2['bill_no'];}
		$newBill = 1;
		if($billNum1 > $billNum2){
			$newBill = $newBill+$billNum1;
		}else{
			$newBill = $newBill+$billNum2;
		}
		return $newBill;
	}

	#------------------------------------------------------------------------------------

	public function sales_order_number_check($so_num){

		$this->db->select(array('id'));
		$this->db->from('dms_sales_order_temp');
		$this->db->where(array('so_no'=>$so_num,'branch_id'=>$this->branchID,'created_by !='=>$this->session->userdata('id')));
		$this->db->where("so_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$row1 = $this->db->get()->row_array();

		$this->db->select(array('id'));
		$this->db->from('dms_sales_orders');
		$this->db->where(array('so_no'=>$so_num,'branch_id'=>$this->branchID,'status'=>1));
		$this->db->where("so_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$row2 = $this->db->get()->row_array();

		if(empty($row1) && empty($row2)){

			return true;
		}
		return false;
	}

	#------------------------------------------------------------------------------------

	public function delete_temp_item($tempItmID){

		$this->db->select(array('so_temp_id'));
		$this->db->from('dms_sales_order_temp_items');
		$this->db->where(array('id'=>$tempItmID));

		$rows = $this->db->get()->row_array();
		$so_temp_id = $rows['so_temp_id'];

		$this->db->from('dms_sales_order_temp_items');
		$this->db->where(array('so_temp_id'=>$so_temp_id));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->db->delete('dms_sales_order_temp',array('id'=>$so_temp_id));
		}

		if($this->db->delete('dms_sales_order_temp_items',array('id'=>$tempItmID))){
			return true;
		}

	}


public function delete_temp_items($tempItmID){

		$this->db->select(array('so_temp_id'));
		$this->db->from('dms_sales_order_temp_items1');
		$this->db->where(array('id'=>$tempItmID));

		$rows = $this->db->get()->row_array();
		$so_temp_id = $rows['so_temp_id'];

		$this->db->from('dms_sales_order_temp_items1');
		$this->db->where(array('so_temp_id'=>$so_temp_id));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->db->delete('dms_sales_order_temp',array('id'=>$so_temp_id));
		}

		if($this->db->delete('dms_sales_order_temp_items1',array('id'=>$tempItmID))){
			return true;
		}

	}




}
?>