<?php
class Sales_return_model extends MY_Model
{
	public function __construct()
	{
		parent :: __construct();

		#-----------fiscal year dates
		$this->fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$this->fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];
		$this->branch_id = $this->session->userdata('under_id');
	}

	public function insert($table,$data)
	{
		$result = $this->f_save($table,$data);
		if($result){
			return $result;
		}
		return false;
	}

	public function next_bill_no($vtype)
	{
		$vid = $this->vouchers->get_vid($vtype);
		$this->db->select(array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.return_bill_no'))->from('dms_sales_returns as a')->join('dms_voucher_types as b','a.vtype_id=b.id')->where(array('b.vid' => $vid,'a.branch_id' => $this->branch_id,'a.created_by' => $this->session->userdata('id'),'a.status' => -1))->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false)->order_by('a.id','asc')->limit(1);
		$row = $this->db->get()->row_array();
		if(empty($row)){
			$this->db->select_max('bill_no')->from('dms_sales_returns')->where(array('branch_id' => $this->branch_id,'vtype_id' => $vtype,'status !=' => 0))->where("bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
			$row = $this->db->get()->row_array();
			$cur_date=date('Y-m-d');
			$row['vtype_id'] = $vtype;
			$row['bill_date'] = $cur_date;
			$row['vstatus'] = 0;
			$row['return_bill_no'] = 0;
			if($row['bill_no'] != NULL){
				$row['bill_no'] = $row['bill_no']+1;
			}
			else{
				$row['bill_no'] = 1;
			}
		}
		else{
			$row['vstatus'] = 1;
		}
		return $row;
	}

	public function get_sales($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.customer_id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id');
		}
		$this->db->select($args['columns'])->from('dms_sales_returns as a')->join('dms_sales_return_items as b','a.group_id = b.group_id');
		$this->db->where('a.branch_id',$this->branch_id);
		$this->db->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);

		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}

		return $this->db->get()->result_array();
	}

    public function get_sales_gst($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.customer_id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id');
		}
		$this->db->select($args['columns'])->from('dms_sales_returns as a')->join('dms_sales_return_items1 as b','a.group_id = b.group_id');
		$this->db->where('a.branch_id',$this->branch_id);
		$this->db->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);

		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}

		return $this->db->get()->result_array();
	}

	public function get_cst($group_id)
	{
		$row = $this->db->select('cst')->get_where('dms_sales_return_items',array('group_id' => $group_id,'cst >' => 0))->row_array();
		if(!empty($row)){
			return true;
		}
		return false;
	}

	public function delete($args = array())
	{
		if($this->db->delete($args['table'],$args['conditions'])){
			return true;
		}
		return false;
	}

	public function get_sales_items($args = array())
	{
		if(!isset($args['columns'])){
			$args['columns'] = array('id','group_id','item_id','qty','unit_id','rate','amount','vat_amt','cst','godown_id');
		}
		$this->db->select($args['columns'])->from('dms_sales_return_items');
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}

		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		return $this->db->get()->result_array();
	}

    public function get_sales_itemss($args = array())
	{
		if(!isset($args['columns'])){
			$args['columns'] = array('id','group_id','item_id','qty','unit_id','rate','amount','cgst_amt','sgst_amt','godown_id');
		}
		$this->db->select($args['columns'])->from('dms_sales_return_items1');
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}

		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		return $this->db->get()->result_array();
	}

	public function update($args = array())
	{
		if(!is_array($args['conditions'])){
			$args['conditions'] .= " and bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'";
		}
		if($this->db->update($args['table'],$args['data'],$args['conditions'])){
			return true;
		}
		return false;
	}

	public function get_bills($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('id','vtype_id','group_id','bill_no','bill_date','return_bill_no','customer_type_id','customer_id','area_id','bill_freight','other_expense','bill_discount_amt','cess','payment_mode','sid','s_status');
		}
		$this->db->select($args['columns'])->from('dms_sales_returns');
		$this->db->where('branch_id',$this->branch_id);

		if(isset($args['between'])){
			$this->db->where($args['between'],NULL,false);
		}
		else{
			$this->db->where("bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		}

		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['like']) && !empty($args['like']))
		{
			$this->db->like($args['like'],false,'before');
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}

	public function update_others($args = array())
	{
		if($this->db->update($args['table'],$args['data'],$args['conditions'])){
			return true;
		}
		return false;
	}

	public function get_group($id)
	{
		$row = $this->db->select(array('vtype_id','group_id','bill_date','return_bill_no','customer_type_id','customer_id'))->get_where('dms_sales_returns',array('id' => $id))->row_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function get_sales_bills()
	{
		$sales_array = array();
		$row = $this->db->select(array('id','bill_no','customer_type_id','bill_status'))->from('dms_sales')->where(array('branch_id' => $this->branch_id,'status' => 1,'bill_status !=' => 3))->where("bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false)->get()->result_array();
		if(!empty($row)){
			foreach($row as $key => $value){
				if($value['customer_type_id'] != 1){
					$sales_array[$value['id']] = $value['bill_no'];
				}
				else{
					if($value['bill_status'] < 2){
						$sales_array[$value['id']] = $value['bill_no'];
					}
				}
			}
		}
		return $sales_array;
	}

	public function get_customer_type($bill_id)
	{
		$customer_type = array();
		$row = $this->db->select(array('b.id','b.designation_name'))->from('dms_sales as a')->join('designation_master as b','a.customer_type_id = b.id')->where('a.id',$bill_id)->get()->row_array();
		if(!empty($row)){
			$customer_type[$row['id']] = $row['designation_name'];
		}
		return $customer_type;
	}

	public function get_customer($bill_id)
	{
		$customer = array();
		$row = $this->db->select(array('customer_type_id','customer_id'))->get_where('dms_sales',array('id' => $bill_id))->row_array();
		if(!empty($row))
		{
			if($row['customer_type_id'] == 2){
				$this->load->model('customers/Customer_master_model','customer_master');
				$customer = $this->customer_master->listing(array('conditions'=>array('id'=>$row['customer_id'])));
			}
			else if($row['customer_type_id'] ==1){
				$this->load->model('branches/Branch_model','branches');
				$customer = $this->branches->listing(array('id ='=>$row['customer_id']));
			}
			else{
				$this->load->model('retailers/Counter_model','retailer_master');
				$customer = $this->retailer_master->listing(array('id'=>$row['customer_id']));
			}
		}
		return $customer;
	}

	public function get_bill_items($bill_id)
	{
		$items = array();
		$row = $this->db->select(array('b.item_id','c.item_code','c.item_name'))->from('dms_sales as a')->join('dms_sales_items as b','a.group_id = b.group_id')->join('item_master as c','b.item_id = c.id')->where(array('a.id' => $bill_id,'a.status' => 1,'b.status' => 1,'b.item_status >' => 0))->get()->result_array();
		if(!empty($row)){
			foreach($row as $key => $value){
				$items[$value['item_id']] = $value['item_code']." / ".$value['item_name'];
			}
		}
		return $items;
	}


        public function get_bill_itemss($bill_id)
	{
		$items = array();
		$row = $this->db->select(array('b.item_id','c.item_code','c.item_name'))->from('dms_sales as a')->join('dms_sales_items1 as b','a.group_id = b.group_id')->join('item_master as c','b.item_id = c.id')->where(array('a.id' => $bill_id,'a.status' => 1,'b.status' => 1,'b.item_status >' => 0))->get()->result_array();
		if(!empty($row)){
			foreach($row as $key => $value){
				$items[$value['item_id']] = $value['item_code']." / ".$value['item_name'];
			}
		}
		return $items;
	}




	public function get_item_count($bill_id,$item_id)
	{
		$count = 0;
		$row = $this->db->select_sum('c.qty')->from('dms_sales as a')->join('dms_sales_items as b','a.group_id = b.group_id')->join('dms_stocks as c','b.id = c.table_id')->where(array('a.id' => $bill_id,'a.status' => 1,'b.item_id' => $item_id,'b.status' => 1,'b.item_status >' => 0,'c.status' => 1))->where(" (c.stock_status ='5' OR c.stock_status='6')")->get()->row_array();
		if($row['qty'] != NULL){
			$count = $row['qty'];
		}
		return $count;
	}
        public function get_item_counts($bill_id,$item_id)
	{
		$count = 0;
		$row = $this->db->select_sum('c.qty')->from('dms_sales as a')->join('dms_sales_items1 as b','a.group_id = b.group_id')->join('dms_stocks as c','b.id = c.table_id')->where(array('a.id' => $bill_id,'a.status' => 1,'b.item_id' => $item_id,'b.status' => 1,'b.item_status >' => 0,'c.status' => 1))->where(" (c.stock_status ='5' OR c.stock_status='6')")->get()->row_array();
		if($row['qty'] != NULL){
			$count = $row['qty'];
		}
		return $count;
	}
	public function get_sales_return_item_count($bill_id,$item_id,$return_item_id = NULL)
	{
		$qty = 0;
		$where = array('a.return_bill_no' => $bill_id,'a.status !=' => 0,'b.item_id' => $item_id,'b.status !=' => 0,'c.stock_status' => 8,'c.status !=' => 0);
		if($return_item_id != NULL){
			$where['b.id !='] = $return_item_id;
		}
		$row = $this->db->select_sum('c.qty')->from('dms_sales_returns as a')->join('dms_sales_return_items as b','a.group_id = b.group_id')->join('dms_stocks as c','b.id = c.table_id')->where($where)->get()->row_array();
		if($row['qty'] != NULL){
			$qty = $row['qty'];
		}
		return $qty;
	}


        public function get_sales_return_item_counts($bill_id,$item_id,$return_item_id = NULL)
	{
		$qty = 0;
		$where = array('a.return_bill_no' => $bill_id,'a.status !=' => 0,'b.item_id' => $item_id,'b.status !=' => 0,'c.stock_status' => 8,'c.status !=' => 0);
		if($return_item_id != NULL){
			$where['b.id !='] = $return_item_id;
		}
		$row = $this->db->select_sum('c.qty')->from('dms_sales_returns as a')->join('dms_sales_return_items1 as b','a.group_id = b.group_id')->join('dms_stocks as c','b.id = c.table_id')->where($where)->get()->row_array();
		if($row['qty'] != NULL){
			$qty = $row['qty'];
		}
		return $qty;
	}


	public function get_bill_no($bill_id)
	{
		if($bill_id > 0)
		{
			$row = $this->db->select('bill_no')->get_where('dms_sales',array('id' => $bill_id))->row_array();
			if(!empty($row)){
				return $row['bill_no'];
			}
		}
		return false;
	}
}
?>