<?php
class Sales_model extends MY_Model
{
	public function __construct()
	{
		parent :: __construct();

		#-----------fiscal year dates
		$this->fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$this->fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];
		$this->branch_id = $this->session->userdata('under_id');
	}

	public function insert($table,$data)
	{
		$result = $this->f_save($table,$data);
		if($result){
			return $result;
		}
		return false;
	}

	public function next_bill_no($vtype)
	{
		$vid = $this->vouchers->get_vid($vtype);
		$this->db->select(array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.sid','a.s_status'))->from('dms_sales as a')->join('dms_voucher_types as b','a.vtype_id=b.id')->where(array('b.vid' => $vid,'a.branch_id' => $this->branch_id,'a.created_by' => $this->session->userdata('id'),'a.status' => -1))->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false)->order_by('a.id','asc')->limit(1);
		$row = $this->db->get()->row_array();
		if(empty($row)){
			$this->db->select_max('bill_no')->from('dms_sales')->where(array('branch_id' => $this->branch_id,'vtype_id' => $vtype,'status !=' => 0))->where("bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
			$row = $this->db->get()->row_array();
			$cur_date=date('Y-m-d');
			$row['vtype_id'] = $vtype;
			$row['bill_date'] = $cur_date;
			$row['vstatus'] = 0;
			if($row['bill_no'] != NULL){
				$row['bill_no'] = $row['bill_no']+1;
			}
			else{
				$row['bill_no'] = 1;
			}
		}
		else{
			$row['vstatus'] = 1;
		}
		return $row;
	}

	public function get_sales($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.customer_id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.godown_id');
		}
		$this->db->select($args['columns'])->from('dms_sales as a')->join('dms_sales_items as b','a.group_id = b.group_id');
		#$this->db->where('a.branch_id',$this->branch_id);
		$this->db->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		if(!array_key_exists('a.branch_id',$args['conditions'])){
			$args['conditions']['a.branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['a.branch_id'])){
			unset($args['conditions']['a.branch_id']);
		}
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}

	public function get_cst($group_id)
	{
		$row = $this->db->select('cst')->get_where('dms_sales_items',array('group_id' => $group_id,'cst >' => 0))->row_array();
		if(!empty($row)){
			return true;
		}
		return false;
	}

	public function delete($args = array())
	{
		if($this->db->delete($args['table'],$args['conditions'])){
			return true;
		}
		return false;
	}

	public function get_sales_items($args = array())
	{
		if(!isset($args['columns'])){
			$args['columns'] = array('id','group_id','item_id','qty','unit_id','rate','amount','discount_amt','vat_amt','cst','godown_id');
		}
		$this->db->select($args['columns'])->from('dms_sales_items');
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}

		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		return $this->db->get()->result_array();
	}

	public function update($args = array())
	{
		if(!is_array($args['conditions'])){
			$args['conditions'] .= " and bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'";
		}
		if($this->db->update($args['table'],$args['data'],$args['conditions'])){
			return true;
		}
		return false;
	}

	#----------to get all bills
	public function get_bills($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('id','vtype_id','bill_no','bill_date','group_id','customer_type_id','customer_id','user_id','area_id','bill_discount_per','bill_discount_amt','bill_freight','other_expense','cess','payment_mode','bill_status');
		}
		$this->db->select($args['columns'])->from('dms_sales');

		if(isset($args['between'])){
			$this->db->where($args['between'],NULL,false);
		}
		else{
			$this->db->where("bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		}

		if(!array_key_exists('branch_id',$args['conditions'])){
			$args['conditions']['branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['branch_id'])){
			unset($args['conditions']['branch_id']);
		}
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['like']) && !empty($args['like']))
		{
			$this->db->like($args['like'],false,'before');
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return  $this->db->get()->result_array();

	}

	public function update_others($args = array())
	{
		if($this->db->update($args['table'],$args['data'],$args['conditions'])){
			return true;
		}
		return false;
	}

	public function get_group($id)
	{
		$row = $this->db->select(array('vtype_id','group_id','bill_date'))->get_where('dms_sales',array('id' => $id))->row_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function get_sms($bill_ref_no)
	{
		$row = $this->db->select('id')->from('dms_sms')->where(array('company_id' => $this->session->userdata('company_id'),'bill_ref_no' => $bill_ref_no))->where("(status = 1 or status = 3)")->get()->row_array();
		if(!empty($row)){
			return $row['id'];
		}
		return false;
	}
	#-------------------------------------------------------------------------------------------------------------
	#----------to get all bills
	public function get_registry_bills($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.payment_mode','a.bill_status');
		}

		//$this->db->select($args['columns'])->from('dms_sales as a')->join('dms_voucher_types as b','a.vtype_id=b.id')->where(array('b.company_id = '));
		$this->db->select($args['columns'])->from('dms_sales as a')->join('dms_voucher_types as b','a.vtype_id=b.id')->where("(b.company_id = 0 or b.company_id = ".$this->session->userdata('company_id').")");
		//$this->db->select(array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.return_bill_no','a.s_status'))->from('dms_purchase_returns as a')->join('dms_voucher_types as b','a.vtype_id=b.id')->where(array('b.vid' => $vid,'a.branch_id' => $this->branch_id,'a.created_by' => $this->session->userdata('id'),'a.status' => -1))->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false)->order_by('a.id','asc')->limit(1);


		if(isset($args['between'])){
			$this->db->where($args['between'],NULL,false);
		}
		else{
			$this->db->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		}

		if(!array_key_exists('branch_id',$args['conditions'])){
			$args['conditions']['a.branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['branch_id'])){
			unset($args['conditions']['branch_id']);
		}
		/*if(!array_key_exists('company_id',$args['conditions'])){
			$args['conditions']['company_id']= $this->session->userdata('company_id');
		}*/
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['like']) && !empty($args['like']))
		{
			$this->db->like($args['like'],false,'before');
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		 return $this->db->get()->result_array();
		 //$this->db->last_query();
	}
}
?>