<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Stock_adjustment_model extends MY_Model{

		#----------------------------------------
		public function get_all($args){

			$this->db->select(array('*'));
			$this->db->from('dms_stock_adjustment_types');
			$this->db->where('status',1);
			$this->db->where('company_id',$this->session->userdata('company_id'));

			//$this->db->join('vehicle_master vehicle','insurance.vehicle_id = vehicle.id');

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
		#----------------------------------------
		public function type_listing($args=array()){

			$godowns = array();
			$this->db->select(array('id','type_name'));
			$this->db->from('dms_stock_adjustment_types');
			$this->db->where('company_id',$this->session->userdata('company_id'));
			$args['conditions']['status'] = 1;
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			$rows = $this->db->get()->result_array();
			if(!empty($rows)){
				foreach($rows as $key=>$row){
					$godowns[$row['id']] = $row['type_name'];
				}
			}
			return $godowns;
						
		}
		#----------------------------------------
		public function save_temp_data($data){
			if($this->f_save('dms_stock_adjustment_temp_items',$data)){
				
				return true;
			}
			return false;
		}
		
		#--------------------------------------------------------
		
		public function get_temp_data($conditions=array()){
			
			$this->db->select(array('dstki_temp.*','im.item_code','im.item_name','um.symbol','gm.godown_name','sat.type_name'));
			$this->db->from('dms_stock_adjustment_temp_items as dstki_temp');
			$this->db->join('item_master as im','dstki_temp.item_id=im.id');
			$this->db->join('unit_master as um','dstki_temp.unit_id=um.id');
			$this->db->join('godown_master gm','dstki_temp.godown_id = gm.id');
			$this->db->join('dms_stock_adjustment_types sat','dstki_temp.adjustment_type = sat.id');
			
			if(!empty($conditions)){
				$this->db->where($conditions);
			}
			
			return $this->db->get()->result_array();
			
		}
		
		#--------------------------------------------------------
		
		public function delete_temp_data($tempID){
			if($this->db->delete('dms_stock_adjustment_temp_items',array('id'=>$tempID))){
				return true;
			}
			return false;
		}
		
		#------------------------------------------------------------
		public function get_all_stock_adust_data($args){
            
            $uid = $this->session->userdata('id');
			/*$this->db->select(array('stk_adj.bill_no','stk_adj.bill_date','stk_adj.remarks','stk_adj_itm.id stck_id','stk_adj_itm.item_id','stk_adj_itm.unit_id','stk_adj_itm.godown_id','stk_adj_itm.adjustment_type','im.item_code','im.item_name','um.symbol','gm.godown_name','sat.type_name'));
			$this->db->from('dms_stock_adjustments as stk_adj');
			$this->db->join('dms_stock_adjustment_items as stk_adj_itm','stk_adj.id = stk_adj_itm.adjustment_id');
			$this->db->join('item_master as im','stk_adj_itm.item_id=im.id');
			$this->db->join('unit_master as um','stk_adj_itm.unit_id=um.id');
			$this->db->join('godown_master gm','stk_adj_itm.godown_id = gm.id');
			$this->db->join('dms_stock_adjustment_types sat','stk_adj_itm.adjustment_type = sat.id');*/
			$this->db->select(array('stk_adj.*'));
			$this->db->from('dms_stock_adjustments as stk_adj');
			$this->db->where('stk_adj.status',1);
			
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
		#------------------------------------------------------------
		public function get_stock_adjust_amount($stck_adj_id){
			$this->db->select(array('rate','qty'));
			$this->db->from('dms_stock_adjustment_items');
			$this->db->where('adjustment_id',$stck_adj_id);
			$rows  = $this->db->get()->result_array();
			//echo $this->db->last_query();
			//echo '<pre>';print_r($rows);
			$total_amount = 0;
			if(!empty($rows)){

				foreach($rows as $row){

					$amount = $row['qty'] * $row['rate'];
					$total_amount = $total_amount+ $amount;   
				}
				//echo $total_amount;//die;
				return($total_amount);

			}

		}
		#------------------------------------------------------------
		public function get_all_stock_adust_items($args){

			$this->db->select(array('stk_adj_itm.*','im.item_code','im.item_name','im.model_no','um.symbol','gm.godown_name','sat.type_name'));
			
			$this->db->from('dms_stock_adjustment_items as stk_adj_itm');
			//$this->db->from('dms_stock_adjustments as stk_adj','stk_adj_itm.adjustment_id = stk_adj.id');
			$this->db->join('item_master as im','stk_adj_itm.item_id=im.id');
			$this->db->join('unit_master as um','stk_adj_itm.unit_id=um.id');
			$this->db->join('godown_master gm','stk_adj_itm.godown_id = gm.id');
			$this->db->join('dms_stock_adjustment_types sat','stk_adj_itm.adjustment_type = sat.id');
			$this->db->where('stk_adj_itm.status',1);
			//$this->db->select(array('stk_adj.*'));
			//$this->db->from('dms_stock_adjustments as stk_adj');

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
		#------------------------------------------------------------
		
		public function get_itemdetails_id($item_code,$item_name){
		    $data = array();
			$row = $this->db->select('id')->from('item_master')->where(array("LOWER(".'item_code'.")"=>strtolower($item_code)))->get()->row_array();
			if(!empty($row))
			{
				$itid = $row['id'];
			}
			return $itid;
		}
		
		public function get_adjustmenttype_id($adjustmenttype){
		    $data = array();
			$row = $this->db->select('id')->from('dms_stock_adjustment_types')->where(array("LOWER(".'type_name'.")"=>strtolower($adjustmenttype)))->get()->row_array();
			if(!empty($row))
			{
				$itid = $row['id'];
			}
			return $itid;
		}
		
		public function get_unit_id($item_id){
		    $data = array();
			$row = $this->db->select('unit_id')->from('item_master')->where(array('id'=>$item_id))->get()->row_array();
			if(!empty($row))
			{
				$itid = $row['unit_id'];
			}
			return $itid;
		}
		
		
	}
?>