<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Stock_transfer_model extends MY_Model{

		public function __construct()
		{
			parent :: __construct();
			
			#-----------fiscal year dates
			$this->fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
			$this->fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];
		}

		#--------------------------------------------------------------------
		public function get_stock_transfer_items($args=array()){

			$this->db->select(array('stk_tr_itm.*','im.item_code','im.item_name','im.model_no','um.symbol','gm.godown_name','gm.godown_code'));			
			$this->db->from('dms_stock_transfer_items as stk_tr_itm');
			$this->db->join('item_master as im','stk_tr_itm.item_id=im.id');
			$this->db->join('unit_master as um','stk_tr_itm.unit_id=um.id');
			$this->db->join('godown_master gm','stk_tr_itm.godown_from_id = gm.id');
			$this->db->where('im.status',1);
			$this->db->where('um.status',1);
			$this->db->where('gm.status',1);
						
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
		#--------------------------------------------------------------------
		public function delete_temp($conditions){
			return $this->db->delete('dms_stock_transfer_items',$conditions);
		}
		#--------------------------------------------------------------------
		public function get_all_stock_transfer($args=array()){
			//$this->db->select(array('stk_trs.*','gm.godown_name','gm.godown_code','gm.branch_id','bm.branch_name'));
			$this->db->select(array('stk_trs.*','gm.godown_name','gm.godown_code','bm.branch_name'));
			$this->db->from('dms_stock_transfers stk_trs');
			$this->db->join('godown_master gm','stk_trs.godown_to_id = gm.id');
			$this->db->join('branch_master bm','bm.id = gm.branch_id');
			$this->db->where('stk_trs.status',1);
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			if(isset($args['togodown'])){
				$this->db->where_in("stk_trs.godown_to_id",$args['togodown']);
			}
			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}
			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		#--------------------------------------------------------------------
		public function get_vouchers($conditions){
			$this->db->select(array('id','vtype_id','vno','vorder_no','vdate','dr_ledger','cr_ledger','vamount'));
			$this->db->from('dms_vouchers');
			$this->db->where('company_id',$this->session->userdata('company_id'));
			$this->db->where('branch_id',$this->session->userdata('under_id'));
			$this->db->where('table_name','dms_stock_transfers');
			$this->db->where('status',1);
			$this->db->where("vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
			$this->db->where($conditions);
			return $this->db->get()->row_array();
		}
		#--------------------------------------------------------------------
		public function update($data,$conditions){
			return $this->db->update('dms_stock_transfers',$data,$conditions);
		}
		#--------------------------------------------------------------------
		/*public function get_approve_stocks($args=array()){
			$this->db->select();
			$this->dn->from('dms_stocks ds');
			$this->db->join('')
			$this->db->join
		}*/
		#--------------------------------------------------------------------
		public function get_stock_transfer_pproved_items($args=array()){

			$this->db->select('*');
			#array('dsti.item_id','dsti.qty','gm.godown_name','gm.godown_code','im.item_code','im.item_name','um.symbol')
			$this->db->from("dms_stock_transfer_items as dsti");
			$this->db->join("dms_stocks as ds","dsti.id=ds.table_id");
			$this->db->join("godown_master as gm","ds.godown_id=gm.id");
			$this->db->join("item_master as im","dsti.item_id=im.id");
			$this->db->join("unit_master as um","dsti.unit_id=um.id");
			$this->db->where('dsti.status',1);
			$this->db->where('gm.status',1);
			$this->db->where('im.status',1);
			$this->db->where('um.status',1);
			
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			
			return $this->db->get()->result_array();
		}
		#-----------------------------------------------------------------
		public function get_transfer_id($conditions=array()){
			$fiscals = $this->dms->get_fiscal_year();
			$fiscal_start_date = $fiscals['start_date'];
			$fiscal_end_date = $fiscals['end_date'];
			$transfer_no=1;
			$this->db->select_max('transfer_no');
			$this->db->from('dms_stock_transfers');
			$this->db->where(array('branch_id'=>$this->session->userdata('under_id')));
			$this->db->where(array('status'=>1));
			$this->db->where("transfer_date between '".$fiscal_start_date."' and '".$fiscal_end_date."'",NULL,true);
			if(!empty($conditions)){
				$this->db->where($conditions);
			}
			$row = $this->db->get()->row_array();
			return $transfer_no+$row['transfer_no'];
		}
		#----------------------------------------------------------------- 

		public function get_branch($godown_id)
		{
			$row = $this->db->select('branch_id')->get_where('godown_master',array('id' => $godown_id,'status' => 1))->row_array();
			if(!empty($row)){
				return $row['branch_id'];
			}
			return false;
		}
		
		#---------------------------------------------------------------------------
		function get_item_id($item_code){
			return $this->db->select('id')->get_where('item_master',array('item_code'=>$item_code))->row_array()['id'];
	}
	
		
		
		#-----------------------------------------------------------------------------
	}
?>