<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Stock_transfer_vehicle_model extends MY_Model{

		public function __construct(){
			parent ::__construct();
		}

	   #-------------------------------------------------------------
		public function save($data){
			if($this->f_save("dms_stock_transfer_vehicles",$data)){
				return true;
			}
			return false;
		}

	   #-------------------------------------------------------------

		public function get_all($args=array()){

			$this->db->select(array('dstv.id','dstv.group_id','dstv.route_id','dstv.vehicle_type','dstv.vehicle_id','dstv.driver_id','dstv.vehicle_no as vehicle_number','dstv.driver_name','dstv.km','dstv.remarks','vm.vehicle_no','rm.route_name','concat(us.fname," ",us.lname) as driver','us.mobile'));
			$this->db->from('dms_stock_transfer_vehicles dstv');
			$this->db->join('vehicle_master vm','dstv.vehicle_id = vm.id','left');
			$this->db->join('route_master rm','dstv.route_id = rm.id','left');
			$this->db->join('users us','dstv.driver_id = us.id','left');
			$this->db->where('dstv.status',1);

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();

		}

	   #-------------------------------------------------------------
		public function update($data,$conditions){
			if($this->my_update('dms_stock_transfer_vehicles',$data,$conditions)){
				return true;
			}
			return false;		
		}
	   #--------------------------------------------------------------	
	}
?>