<?php if ( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Stocktransfer_upload_model extends MY_Model{

        public function __construct()
		{
			parent :: __construct();
			
			#-----------fiscal year dates
			$this->fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
			$this->fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];
			$this->companyID = $this->session->userdata('company_id');
            $this->branch_id = $this->session->userdata('under_id');
		}

		#--------------------------------------------------------------------

	    public function get_item_id($item_code,$item_name,$item_type,$item_unit,$godown)
		{
			$row = $this->db->select('id')->get_where('item_master',array('item_code' => $item_code,'status' => 1))->row_array();
			if(!empty($row))
			{
				return $row['id'];
			}
			else
			{
			    $new_item_details = array();
                $new_item_details['company_id'] = $this->companyID;
                $new_item_details['item_code'] = $item_code;
                $new_item_details['item_name'] = $item_name;
                $new_item_details['item_types'] = $item_type;
                
                $new_it = $this->db->select(array('id','group_id'))->from('item_types')->where('name',$item_type)->get()->row_array();                                
                $new_item_details['item_group_id'] = $new_it['group_id'];
                $new_item_details['item_manufacturer_id'] = 5;
                
                $tp=$new_item_details['item_types'];
                $cd=$new_item_details['item_code'];
                if($tp=='contact' || $tp=='solution')
        		{
        			$new_item_details['code_id'] = substr($cd,2);
        		}
        		else
        		{
        	        $new_item_details['code_id'] = substr($cd,1);
        		}
                	
                $new_item_details['unit_id'] = $unit = $this->get_unit_id($item_unit);
                $new_item_details['hsn'] = '';
                $new_item_details['stock_type'] = 1;
                $new_item_details['status'] = 1;
                
                $new_item_id = $this->db->insert("item_master",$new_item_details); echo "<br>".$new_item_id;
                if($new_item_id)
                {
                    $new_stock = array();
                    $new_stock['company_id'] = $this->companyID;
                    $new_stock['branch_id'] = $this->branch_id;
                    $new_stock['godown_id'] = $godown;
                    $new_stock['item_id'] = $new_item_id;
                    $new_stock['qty'] = 0;
                    $new_stock['unit_id'] = $unit;
                    $new_stock['rate'] = 0;
                    $new_stock['stock_date'] = $this->fiscal_start_date;
                    $new_stock['status'] = 1;
                    $this->db->insert("dms_stocks",$new_stock);
                        
                    return $new_item_id;
                }
			}
		}
		
		#-----------------------------------------------------------
		public function get_unit_id($unit){
			$row = $this->db->select('id')->from('unit_master')->like(array("LOWER(".'symbol'.")"=>strtolower($unit)))->get()->row_array();
			if(!empty($row)){
				return $row['id'];
			}
			else{
				return false;
			}

		}
		#--------------------------------------------------------------------
		public function get_stock_transfer_pproved_items($args=array()){

			$this->db->select('*');
			#array('dsti.item_id','dsti.qty','gm.godown_name','gm.godown_code','im.item_code','im.item_name','um.symbol')
			$this->db->from("dms_stock_transfer_items as dsti");
			$this->db->join("dms_stocks as ds","dsti.id=ds.table_id");
			$this->db->join("godown_master as gm","ds.godown_id=gm.id");
			$this->db->join("item_master as im","dsti.item_id=im.id");
			$this->db->join("unit_master as um","dsti.unit_id=um.id");
			$this->db->where('dsti.status',1);
			$this->db->where('gm.status',1);
			$this->db->where('im.status',1);
			$this->db->where('um.status',1);
			
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			
			return $this->db->get()->result_array();
		}
		#------------------------------------------------------------------------
		#------------------------------------------------------------------------
		public function get_vouchers($conditions){
			$this->db->select(array('id','vtype_id','vno','vorder_no','vdate','dr_ledger','cr_ledger','vamount'));
			$this->db->from('dms_vouchers');
			$this->db->where('company_id',$this->session->userdata('company_id'));
			$this->db->where('branch_id',$this->session->userdata('under_id'));
			$this->db->where('table_name','dms_stock_transfers');
			$this->db->where('status',1);
			$this->db->where("vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
			$this->db->where($conditions);
			return $this->db->get()->row_array();
		}
		#--------------------------------------------------------------------
		public function update($data,$conditions)
		{
			return $this->db->update('dms_stock_transfers',$data,$conditions);
		}
	
#---------------------------------------------------------------------------------------------------------------------------------------
public function get_all_stock_transfer($args=array()){
			$this->db->select(array('stk_trs.*','gm.godown_name','gm.godown_code','gm.branch_id','bm.branch_name'));
			$this->db->from('dms_stock_transfers stk_trs');
			$this->db->join('godown_master gm','stk_trs.godown_to_id = gm.id');
			$this->db->join('branch_master bm','bm.id = gm.branch_id');
			$this->db->where('stk_trs.status',1);

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			if(isset($args['togodown'])){

				$this->db->where_in("stk_trs.godown_to_id",$args['togodown']);
			
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}
			
			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}

			return $this->db->get()->result_array();

		}
		#--------------------------------------------------------------------
public function get_stock_transfer_items($args=array()){

			$this->db->select(array('stk_tr_itm.*','im.item_code','im.item_name','um.symbol','gm.godown_name','gm.godown_code'));			
			$this->db->from('dms_stock_transfer_items as stk_tr_itm');
			$this->db->join('item_master as im','stk_tr_itm.item_id=im.id');
			$this->db->join('unit_master as um','stk_tr_itm.unit_id=um.id');
			$this->db->join('godown_master gm','stk_tr_itm.godown_from_id = gm.id');
			$this->db->where('im.status',1);
			$this->db->where('um.status',1);
			$this->db->where('gm.status',1);
						
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
		#--------------------------------------------------------------------

	/*	public function check_bill_date($bill_date){
			$this->db->select();
			$this->db->from('fiscal_year_master');
			$this->db->where("'$bill_date' between start_date and end_date and close_status = 0");
			$row = $this->db->get()->row_array();
			if(empty($row)){
				return FALSE;
			}
			else{
				return TRUE;
			}
		}*/
		
		#------------------------------------------------------------
		public function get_transfer_id($conditions=array()){
			$fiscals = $this->dms->get_fiscal_year();
			$fiscal_start_date = $fiscals['start_date'];
			$fiscal_end_date = $fiscals['end_date'];
			$transfer_no=1;
			$this->db->select_max('transfer_no');
			$this->db->from('dms_stock_transfers');
			$this->db->where(array('branch_id'=>$this->session->userdata('under_id')));
			$this->db->where(array('status'=>1));
			$this->db->where("transfer_date between '".$fiscal_start_date."' and '".$fiscal_end_date."'",NULL,true);
			if(!empty($conditions)){
				$this->db->where($conditions);
			}
			$row = $this->db->get()->row_array();
			return $transfer_no+$row['transfer_no'];
		}
		#---------------------------------------------------------------------------------------------------------
		public function get_branch($godown_id)
		{
			$row = $this->db->select('branch_id')->get_where('godown_master',array('id' => $godown_id,'status' => 1))->row_array();
			if(!empty($row)){
				return $row['branch_id'];
			}
			return false;
		}
		#--------------------------------------------------------------------------------------------------------------------------------------
	}
?>