<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
	
	class Target_model extends MY_Model{

	#-------------------------------------------

		#date : 22-7-2014
		#purpose : save targets userdata
		public function save($target){

			$target['valid_from'] = date('Y-m-d',strtotime($target['valid_from']));
			$target['valid_to'] = date('Y-m-d',strtotime($target['valid_to']));
			$result = $this->f_save('targets',$target);
			return $result;
		}

	#--------------------------------------------
		#date : 30-01-2015
		#purpose : get insert id of target userdata
		public function get_target_id(){

			return $this->db->insert_id();
		}	

	#-------------------------------------------

		#date : 30-1-2015
		#purpose : save targets points
		public function save_bonus($target){

			$this->f_save('target_items',$target);
			return true;
		}

	#-------------------------------------------

	
		#date : 24-7-2014
		#purpose : update all targets of a particular user as seen (seen_status => 1)
		public function i_have_seen_my_targets($user_id){
			$this->db->update('targets',array('seen_status'=>1),array('user_id'=>$user_id));
			return true;
		}	

	#-------------------------------------------

		#date : 22-7-2014
		#purpose : get all targets for an employee
		public function get_all($args=FALSE){

			$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
			$fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];

			$fiscal_start_date_time = date('Y-m-d',strtotime($fiscal_start_date));
			$fiscal_end_date_time = date('Y-m-d',strtotime($fiscal_end_date));

			$this->db->select(array('i.item_name','u.symbol','u.formal_name','t.*','m.*'));
			$this->db->from('target_items m');
			$this->db->join('targets t','t.id=m.targets_id');
			$this->db->join('unit_master u','u.id=m.unit_id','left');
			$this->db->join('item_master i','i.id=m.item_id');
			$this->db->where('t.status',1);
			$this->db->where('i.status',1);

			$where = "((t.valid_from <= '$fiscal_start_date_time' && t.valid_to >= '$fiscal_start_date_time') or (t.valid_from <= '$fiscal_end_date_time' && t.valid_to >= '$fiscal_end_date_time') or (t.valid_from > '$fiscal_start_date_time' && t.valid_to < '$fiscal_end_date_time'))";
			
			$this->db->where($where,NULL,TRUE);

			$args = func_get_args()[0];
			foreach($args as $key=>$value){
				if($key == 'total'){
					return $this->db->get()->num_rows();
					exit;
				}else if($key == 'limit'){
					$this->db->limit($value,$args['offset']);
				}else if($key != 'offset'){
					$this->db->where($key,$value);
				}
			}

			$this->db->order_by('t.valid_to','DESC');
			return $this->db->get()->result_array();
			 			
		}

	#-------------------------------------------

		#date : 30-1-2015
		#purpose : get all temp targets for an employee
		public function get_all_temp($args=FALSE){

			$this->db->select(array('i.item_name','u.symbol','u.formal_name','t.*','m.*'));
			$this->db->from('target_items m');
			$this->db->join('targets t','t.id=m.targets_id');
			$this->db->join('unit_master u','u.id=m.unit_id','left');  
			$this->db->join('item_master i','i.id=m.item_id');
			$this->db->where('t.status',-1);
			$this->db->where('m.status',-1);
			$args = func_get_args()[0];
			foreach($args as $key=>$value){
				if($key == 'total'){
					return $this->db->get()->num_rows();
					exit;
				}else if($key == 'limit'){
					$this->db->limit($value,$args['offset']);
				}else if($key != 'offset'){
					$this->db->where($key,$value);
				}
			}
			$this->db->order_by('valid_to','DESC');
			return $this->db->get()->result_array();               
		}

	#-------------------------------------------

		#date : 09-01-2015
		#purpose : chek if a target exist for an employee
		public function chk_all_temp($user,$desig,$ttype,$titem){

			$this->db->select(array('t.*','m.*'));
			$this->db->from('target_items m');
			$this->db->join('targets t','t.id=m.targets_id');
			$this->db->where('t.user_id',$user);
			$this->db->where('t.designation_id',$desig);
			$this->db->where('t.target_type',$ttype);
			$this->db->where('t.status!=',0);
			$this->db->where('m.item_id',$titem);

			 return $this->db->get()->result_array();
		}

	#--------------------------------------------

		#date : 07-01-2015
		#purpose : get all targets for an employee between two dates
		public function get_all_between_dates($args=FALSE,$date_from,$date_to){

			$this->db->select(array('m.*','t.*'));
			$this->db->from('targets t');
			$this->db->join('target_items m','m.targets_id=t.id','inner');
			$where = "((`valid_from` <= '$date_from' && `valid_to` >= '$date_from') or (`valid_from` <= '$date_to' && `valid_to` >= '$date_to') or (`valid_from` > '$date_from' && `valid_to` < '$date_to'))";
			$this->db->where($where);
			$this->db->where('t.status',-1);
			$this->db->or_where('t.status',1);
			$args = func_get_args()[0];
			foreach($args as $key=>$value){
				if($key == 'total'){
					return $this->db->get()->num_rows();
					exit;
				}else if($key == 'limit'){
					$this->db->limit($value,$args['offset']);
				}else if($key != 'offset'){
					$this->db->where($key,$value);
				}
				}

			$this->db->order_by('valid_to','DESC');
			return $gett = $this->db->get()->result_array();
                        
		}

	#--------------------------------------------
		#date: 01-08-2014
		#purpose : delete the target
		public function delete_temp($table,$id){

			if($table == 'targets') {
				$result=$this->db->update($table,array('status'=>0),array('id'=>$id));
			} else {
				$result=$this->db->update($table,array('status'=>0),array('targets_id'=>$id));
			}
			return $result;
			
		}
	#--------------------------------------------
		#date : 01-08-2014
		#purpose : get user_id of close target as under achieved 
		public function get_user($target_id){
			$result=$this->db->select('user_id')->get_where('targets',array('id'=>$target_id))->row_array();
			return $result;
		
		}	
	#--------------------------------------------
		#date : 05-08-2014
		#purpose : edit target details
		public function update_target($data,$id){
			
			$result=$this->db->update('targets',$data,array('id'=>$id));
			return $result;
		}

	#--------------------------------------------
		#date : 05-02-2015
		#purpose : update temporary target details
		public function update_targets($table,$targets,$target_id){

			if($table =='targets')
			{
				$targets['valid_from'] = date('Y-m-d',strtotime($targets['valid_from']));
				$targets['valid_to'] = date('Y-m-d',strtotime($targets['valid_to']));
				$result=$this->my_update($table,$targets,array('id'=>$target_id));
			}
			else
			{ 
				$result=$this->my_update($table,$targets,array('targets_id'=>$target_id)); 
			}
			return $result;
		}

	#--------------------------------------------
		#date : 04-02-2015
		#purpose : Update target from temp to permanent
		public function save_target($data,$user){

			$result=$this->my_update('targets',$data,array('user_id'=>$user));
			return $result;
		}
	
	#--------------------------------------------
		#date : 04-02-2015
		#purpose : Update target_items from temp to permanent
		public function save_target_items($data,$tid){

			$result=$this->my_update('target_items',$data,array('id'=>$tid));
			return $result;
		}
					
	#--------------------------------------------
		#date : 07-08-2014
		#purpose : Get all user_type in targets
		public function list_user_type(){
			$this->db->select('user_type');
			$this->db->group_by('user_type');
			$this->db->get('targets');
		}

	#--------------------------------------------
		#date : 07-08-2014
		#purpose : Get targets
		public function get_all_targets($conditions=NULL,$return=0,$limit=0,$offset=0){
			//get employee target reports
			if($conditions['t.user_type'] == 'employee'){
		
			$this->db->select(array('i.item_name','u.symbol','t.*','us.fname','us.lname'));
			$this->db->from('targets t');
			$this->db->join('unit_master u','u.id=t.unit_id');
			$this->db->join('item_master i','i.id=t.item_id');
			$this->db->join('users us','us.id=t.user_id');
			$this->db->where('t.status',1);
		
			if($conditions){
				foreach($conditions as $key=>$value){
					$this->db->where($key,$value);
				}
			}
			if($return){
				return $this->db->count_all_results();
			}
			if($offset != 0){
				$this->db->limit($offset,$limit);
			}	
					
			$this->db->order_by('valid_to','DESC');
			return $this->db->get()->result_array();	
				
		}	
		//get branch targets reports
		else if($conditions['t.user_type'] == 'branch'){
		
			$this->db->select(array('i.item_name','u.symbol','t.*','br.branch_name','br.branch_short_name'));
			$this->db->from('targets t');
			$this->db->join('unit_master u','u.id=t.unit_id');
			$this->db->join('item_master i','i.id=t.item_id');
			$this->db->join('branch_master br','br.id=t.user_id');
			$this->db->where('t.status',1);
		
			if($conditions){
				foreach($conditions as $key=>$value){
					$this->db->where($key,$value);
				}
			}
			if($return){
				return $this->db->count_all_results();
			}
			if($offset != 0){
				$this->db->limit($offset,$limit);
			}	
					
			$this->db->order_by('valid_to','DESC');
			return $this->db->get()->result_array();		
		}
		//get ar targets reports	
		else if($conditions['t.user_type'] == 'AR'){
		
			$this->db->select(array('i.item_name','u.symbol','t.*','rt.retailer_name','rt.retailer_short_name'));
			$this->db->from('targets t');
			$this->db->join('unit_master u','u.id=t.unit_id');
			$this->db->join('item_master i','i.id=t.item_id');
			$this->db->join('retailer_master rt','rt.id=t.user_id');
			$this->db->where('t.status',1);
		
			if($conditions){
				foreach($conditions as $key=>$value){
					$this->db->where($key,$value);
				}
			}
			if($return){
				return $this->db->count_all_results();
			}
			if($offset != 0){
				$this->db->limit($offset,$limit);
			}	
					
			$this->db->order_by('valid_to','DESC');
			return $this->db->get()->result_array();		
		}	
			
		}
	#--------------------------------------------
		#date:     04/02/2014
		#purpose : to get retailers with target setting
		public function listing_ar($id = NULL){
			$this->db->select(array('rt.id as r_id','rt.retailer_short_name','u.id'));
			$this->db->from('retailer_master rt');
			$this->db->join('users u','u.branch_id = rt.id');
			$this->db->where(array('u.status'=>1,'u.designation_id'=>$id,'rt.status'=>1));
			$rows = $this->db->get()->result_array();
			//echo $this->db->last_query();die;
			//echo '<pre>';print_r($rows);die;
			$users = array();
			if(!empty($rows)){
				foreach($rows as $row){
			
					$users[$row['id']] = $row['retailer_short_name'];
				}
			}
			$users[0] = "Select";
			return $users;
		}

	#--------------------------------------------
		#date:     11/02/2015
		#purpose : to get timely notifications as deadline

		public function notify_timely_targets(){

			// set php runtime to unlimited
			set_time_limit(0);

			#user type
			$type =NULL;

				$this->db->select(array('targets.*','ti.qty','u.symbol','i.item_name'))->from('targets');
				$this->db->join('target_items ti','targets.id=ti.targets_id');
				$this->db->join('item_master i','ti.item_id=i.id');
				$this->db->join('unit_master u','ti.unit_id=u.id');
				$this->db->where('targets.user_id',$this->session->userdata('id'));
				$this->db->where('targets.seen_status',1);
				$this->db->where('targets.status',1);
				$qry = $this->db->order_by('targets.valid_to','ASC')->get();
				$count = $qry->num_rows();
				
			    	return $result['targets'] = $qry->result_array();
			}

	}

?>