<?php 
	
	class Mason_model extends MY_Model{



		#---------------------------------------------

		#date : 17-6-2014
		#purpose : list masons
		public function listing($conditions = NULL){

			$fiscal_yr_id = $this->dms->get_default_fiscal_id();
			//$conditions['fiscal_yr_id'] = $fiscal_yr_id;
			$conditions['designation_id'] = '5';
			$conditions['status'] = 1;

			$rows = $this->db->select(array('id','fname','lname'))->get_where('users',$conditions)->result_array();
			$masons = array();
			
			foreach($rows as $row){ $masons[$row['id']] = $row['fname'].' '.$row['lname'];}

			return $masons;

		}

		#---------------------------------------------
		public function save_area($mason_id,$area){
			$num = $this->db->get_where('mason_areas',array('mason_id'=>$mason_id,'area_name'=>$area))->num_rows();
			if($num==0){
				$this->db->insert('mason_areas',array('mason_id'=>$mason_id,'area_name'=>$area,'created_by'=>$this->session->userdata('id')));
			}
		}

		#---------------------------------------------
			public function get_all($conditions=NULL,$total=0,$limit=0,$offset=0){

				$this->db->select(array('users.*','desg.designation_name','desg.id  as designation_id'));
				$this->db->from('users');
				$this->db->join('designation_master desg','users.designation_id=desg.id');
				$this->db->where('users.status',1);
				$this->db->where('users.designation_id',5);
				$this->db->where('users.company_id',$this->session->userdata('company_id'));
				//$this->db->join('branch_master branch','users.under_id = branch.id');
				//$this->db->join('retailer_master retailer','users.under_id = retailer.id');

				if($conditions){
					foreach($conditions as $key=>$value){
						$this->db->where($key,$value);
					}
				}	

				#apply offset
				if($offset != 0)
					$this->db->limit($offset,$limit);

				if($total != 0){
					return $this->db->get()->num_rows();
				}

				$masons = $this->db->get()->result_array();

				//echo $this->db->last_query();

				return $masons;
			}
		#---------------------------------------------

		#date : 21-6-2014
		#purpose : get area names of a mason
		public function list_mason_areas($mason_id){

			$rows = $this->db->get_where('mason_areas',array('mason_id'=>$mason_id,'status'=>1))->result_array();

			$areas = array();
			foreach($rows as $row){ $areas[$row['id']] = $row['area_name']; }
			return $areas;
		}	

		#------------------------------------------------
		public function area_update($p_areas,$mason_id){
			
			#posted area string to array
			$posted_areas = explode(',',$p_areas);
			//print_r($posted_areas);

			#get exiisting areas#
			$exist_areas = $this->list_mason_areas($mason_id);

			#delere removed areas
			foreach($exist_areas as $ea){
				//echo $ea.'<hr/>';
				
				if(!in_array($ea,$posted_areas)){
					//remove ea
					$this->db->update('mason_areas',array('status'=>0),array('mason_id'=>$mason_id,'area_name'=>$ea)); 
				}
			}


			#add new areas
			foreach ($posted_areas as $pa) {
				
				if(!in_array($pa,$exist_areas)){
					$this->db->insert('mason_areas',array('mason_id'=>$mason_id,'area_name'=>$pa,'created_by'=>$this->session->userdata('id')));
				}
			}

			return true;
		}
		#------------------------------------------------

		public function list_it($user_type){

			if($this->session->userdata('id') == '-1'){

				$this->db->select('u.*');
				$this->db->from('users u');

				$this->db->where('u.user_type',$user_type);
				$this->db->or_where('u.user_type','administrator');
				$this->db->where('u.company_id',$this->session->userdata('company_id'));
				$this->db->where('u.status',1);
				$this->db->order_by('u.fname','ASC');

				$users = $this->db->get()->result_array();
			}
			else{
				$this->db->select('u.*');
				$this->db->from('users u');

				$this->db->where('u.user_type',$user_type);
				$this->db->where('u.company_id',$this->session->userdata('company_id'));
				$this->db->where('u.status',1);
				$this->db->order_by('u.fname','ASC');
			
				$users = $this->db->get()->result_array();
			}
			//echo $this->db->last_query();die;

			if(empty($users)){
				return false;
			}

			$data = array();
			foreach($users as $user){
				$data[$user['id']] = ucwords($user['fname']).' '.ucwords($user['lname']);
			}

			return $data;
		}
		#------------------------------------------------	


                public function get_mason($id){



                        $conditions['id'] = $id;
                        $conditions['designation_id'] = '5';
			$conditions['status'] = 1;


                       
			$rows = $this->db->select(array('mobile'))->get_where('users',$conditions)->result_array();
			
			

			return $rows;

                }

	}

?>