<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Vehicle_model extends MY_Model{
	
	
	 #----------------------------------------------
		
		public function listing($conditions = NULL){
		
			$conditions['status'] = 1;
			//print_r($conditions);die;
			//if(isset($conditions['user_type']) && $conditions['user_type']=='employee'){
			//$conditions['under_type'] = $this->session->userdata('under_type');
			//$conditions['under_id'] = $this->session->userdata('under_id');
			//}
			$rows = $this->db->select(array('id','vehicle_no'))->get_where('vehicle_master',$conditions)->result_array();
			
			$vehicles = array();
			foreach($rows as $row){
				$vehicles[$row['id']] = $row['vehicle_no'];
			}
			#echo $this->db->last_query();
			
			return $vehicles;
		
		}
	
		
	 #----------------------------------------------
	 	public function get_all($args){         
           $this->db->select(array('vm.*','bm.branch_name'));
           $this->db->from('vehicle_master vm');
           $this->db->join('branch_master bm','vm.under_id = bm.id');
           $this->db->where('vm.status',1);
           $this->db->where('bm.status',1);
		   
		   if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
         }
	 #----------------------------------------------
		public function get_all_fuel($conditions=NULL,$return=0,$limit=0,$offset=0){

			$this->db->select(array('fuel.*','vehicle.vehicle_no','us.fname','us.lname'));
			$this->db->from('vehicle_fuel_fillings fuel');
			$this->db->join('vehicle_master vehicle','fuel.vehicle_id = vehicle.id');
			$this->db->join('users us','fuel.driver_id = us.id');
			$this->db->where('fuel.status',1);
			$this->db->order_by('fuel.filling_date');

			if($conditions){

				foreach($conditions as $f=>$v)
					$this->db->where($f,$v);
			}
				
			if($return){
				return $this->db->count_all_results();
			}
				
			if($offset != 0)
				$this->db->limit($offset,$limit);
			
			return $this->db->get()->result_array();
			#all code is here
		}	

     #---------------------------------------------------
	    #date:1-10-2014
	    #purpose:to remind vehicle insurance payment details in week
	    public function insurance_payment_remainder($date){

	    	$cur_date = $date ;
	    	
	    	$max_date = strtotime ( '+7day' , strtotime ( $date ) ) ;
	    	$max_date = date('Y-m-d',$max_date);

	    	$conditions['insurance.premium_date >='] = $cur_date;
	    	$conditions['insurance.premium_date <='] = $max_date;

	    	$result = $this->get_all_insurance(array('conditions'=>$conditions));
	    	
	    	return $result;

	    }
	
         
     #------------------------------------------------
	    #date:8-10-2014
	    #purpose:to save vehile insurance details
	    public function save_insurance($data){
	    	$data['premium_date'] = date('Y-m-d',strtotime($data['premium_date']));
	    	$data['payment_date'] = (isset($data['payment_date']))?date('Y-m-d',strtotime($data['payment_date'])):'';
   	 		if($this->f_save('vehicles_insurance',$data)){
   	 			return true;
   	 		}
   	 		else{
   	 			return false;
   	 		}	 		
	    }
	 #------------------------------------------------
	    #date:20-9-2014
		#purpose:get my tasks
		public function get_all_insurance($args){

			$this->db->select(array('insurance.*','vehicle.vehicle_no','vehicle.vehicle_chasis_no','vehicle.vehicle_rc_no','vehicle.vehicle_mileage'));
			$this->db->from('vehicles_insurance insurance');
			$this->db->where('insurance.status',1);
			$this->db->join('vehicle_master vehicle','vehicle.id = insurance.vehicle_id');
			$this->db->where('vehicle.company_id',$this->session->userdata('company_id'));
			$this->db->where('vehicle.status',1);

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
	 #------------------------------------------------
		public function check_in_delete($id){
			$insurance = $this->db->select('id')->get_where('vehicles_insurance',array('vehicle_id'=>$id,'status'=>1))->num_rows();
			$fuels = $this->db->select('id')->get_where('vehicle_fuel_fillings',array('vehicle_id'=>$id,'company_id'=>$this->session->userdata('company_id'),'status'=>1))->num_rows();
			$stock_transfer = $this->db->select('id')->get_where('dms_stock_transfer_vehicles',array('vehicle_id'=>$id,'status'=>1))->num_rows();
			$sales = $this->db->select('id')->get_where('dms_sales_vehicles',array('vehicle_id'=>$id,'status'=>1))->num_rows();
			$purchase = $this->db->select('id')->get_where('dms_purchase_vehicles',array('vehicle_id'=>$id,'status'=>1))->num_rows();
			$purchase_return = $this->db->select('id')->get_where('dms_purchase_return_vehicles',array('vehicle_id'=>$id,'status'=>1))->num_rows();
			if(empty($insurance) && empty($fuels) && empty($stock_transfer) && empty($sales) && empty($purchase) && empty($purchase_return)){
				return true;
			}
			else{
				return false;
			}

		}
	 #------------------------------------------------


	}

?>