<?php
class Wholesale_model extends MY_Model
{
	public function __construct()
	{
		parent :: __construct();

		#-----------fiscal year dates
		$this->fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$this->fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];
		$this->branch_id = $this->session->userdata('under_id');
        $this->companyID = $this->session->userdata('company_id');
	}

	public function insert($table,$data)
	{
		$result = $this->f_save($table,$data);
		if($result){
			return $result;
		}
		return false;
	}

	public function next_bill_no($vtype)
	{
		$vid = $this->vouchers->get_vid($vtype);
		$this->db->select(array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.tid','a.s_status'))->from('dms_wholesale as a')->join('dms_voucher_types as b','a.vtype_id=b.id')->where(array('b.vid' => $vid,'a.branch_id' => $this->branch_id,'a.created_by' => $this->session->userdata('id'),'a.status' => -1))->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false)->order_by('a.id','asc')->limit(1);
		$row = $this->db->get()->row_array();
		if(empty($row))
		{
			$this->db->select_max('bill_no')->from('dms_wholesale')->where(array('branch_id' => $this->branch_id,'vtype_id' => $vtype,'status !=' => 0))->where("bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
			$row = $this->db->get()->row_array();
			$cur_date=date('Y-m-d');
			$row['vtype_id'] = $vtype;
			$row['bill_date'] = $cur_date;
			$row['vstatus'] = 0;
			if($row['bill_no'] != NULL){
				$row['bill_no'] = $row['bill_no']+1;
			}
			else{
				$row['bill_no'] = 1;
			}
		}
		else{
			$row['vstatus'] = 1;
		}
		return $row;
	}

	public function get_sales($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.branch_to_id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.cgst_amt','b.sgst_amt','b.cess_amt','b.discount_amt');
		}
		$this->db->select($args['columns'])->from('dms_wholesale as a')->join('dms_wholesale_items as b','a.group_id = b.group_id');
		$this->db->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		if(!array_key_exists('a.branch_id',$args['conditions'])){
			$args['conditions']['a.branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['a.branch_id'])){
			unset($args['conditions']['a.branch_id']);
		}
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}
    
 /*   public function get_cst($group_id)
	{
		$row = $this->db->select('cst')->get_where('dms_sales_items',array('group_id' => $group_id,'cst >' => 0))->row_array();
		if(!empty($row)){
			return true;
		}
		return false;
	}*/

	public function delete($args = array())
	{
		if($this->db->delete($args['table'],$args['conditions'])){
			return true;
		}
		return false;
	}
   
    public function get_sales_items($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('id','group_id','item_id','qty','unit_id','rate','amount','discount_amt','taxable_amt','cgst_amt','sgst_amt','cess_amt');
		}
		$this->db->select($args['columns'])->from('dms_wholesale_items');
		if(isset($args['conditions']))
        {
            $this->db->where($args['conditions']);
		}

        if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}

		return $this->db->get()->result_array();
	}

	public function update($args = array())
	{
		if(!is_array($args['conditions']))
		{
			$args['conditions'] .= " and bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'";
		}
		if($this->db->update($args['table'],$args['data'],$args['conditions']))
		{
			return true;
		}
		return false;
	}

	#----------to get all bills
	public function get_bills($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('id','vtype_id','bill_no','bill_date','group_id','branch_to_id','bill_discount_per','bill_discount_amt','bill_freight','other_expense','cess','payment_mode','bill_status');
		}
		$this->db->select($args['columns'])->from('dms_wholesale');

		if(isset($args['between'])){
			$this->db->where($args['between'],NULL,false);
		}
		else{
			$this->db->where("bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		}

		if(!array_key_exists('branch_id',$args['conditions'])){
			$args['conditions']['branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['branch_id'])){
			unset($args['conditions']['branch_id']);
		}
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['like']) && !empty($args['like']))
		{
			$this->db->like($args['like'],false,'before');
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}

	public function update_others($args = array())
	{
		if($this->db->update($args['table'],$args['data'],$args['conditions'])){
			return true;
		}
		return false;
	}

	public function get_group($id)
	{
		$row = $this->db->select(array('vtype_id','group_id','bill_date'))->get_where('dms_wholesale',array('id' => $id))->row_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}
	
    public function get_registry_bills($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.branch_to_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.payment_mode','a.bill_status','b.vtype','a.narration','a.bill_discount_amt','c.item_id','c.qty','c.unit_id','c.rate','c.amount','c.discount_per','c.discount_amt','c.taxable_amt','c.cgst','c.sgst','c.cgst_amt','c.sgst_amt','c.cess_amt');
		}

		$this->db->select($args['columns'])->from('dms_wholesale as a')->join('dms_voucher_types as b','a.vtype_id=b.id')->join('dms_wholesale_items as c','c.group_id=a.group_id')->where("(b.company_id = 0 or b.company_id = ".$this->session->userdata('company_id').")");

        if(isset($args['between']))
        {
			$this->db->where($args['between'],NULL,false);
		}
		else
		{
			$this->db->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		}

		if(!array_key_exists('branch_id',$args['conditions']))
		{
			$args['conditions']['a.branch_id']= $this->branch_id;
		}
		
		if(empty($args['conditions']['branch_id']))
		{
			unset($args['conditions']['branch_id']);
		}
		
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		
		if(isset($args['like']) && !empty($args['like']))
		{
			$this->db->like($args['like'],false,'before');
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		 return $this->db->get()->result_array();
	}
}
?>