<?= form_open(); ?>
<div class="panel panel-primary">
    <div class="panel-heading">
        <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("new")." ".$this->lang->line("$voucher_name-bill"); ?></h6>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <div class="row">
				<div class="col-md-4">
                    <label class="required"><?=$this->lang->line('voucher-types');?></label>
                    <?=form_dropdown("vtype_id",$voucher_types,set_value("vtype_id",$voucher_type),"class='form-control voucher-type' $disabled");?>
                    <?=form_error('vtype_id');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
					<div class="input-group">
						<span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
						<?=form_input('sales[bill_no]',set_value('sales[bill_no]',$voucher_no),"class='form-control text-right ' id='sbill-ajax' $disabled");?>
					</div>

                    <?= form_error('sales[bill_no]');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
                    <?=form_input('sales[bill_date]',set_value('sales[bill_date]',cdateFormat($voucher_date)),"class='datepicker form-control bill-date' id='sdate-ajax' $disabled");?>
                    <?= form_error('sales[bill_date]');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('phone');?></label>                  
                    <?= form_input(array('name'=>'sales[mobile]','class'=>'form-control mob'),set_value('sales[mobile]',$cust_mob)); ?> 
                    <?= form_error('sales[mobile]');?> 
                </div>            	
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('customer-name');?></label>                  
                    <?= form_input(array('name'=>'sales[customer_id]','class'=>'form-control customer-name'),set_value('sales[customer_id]',$cust_name)); ?> 
                    <?= form_error('sales[customer_id]');?> 
                </div> 
                <div class="col-md-4">
        			<label><?=$this->lang->line('address');?></label>
        			<?=form_textarea(array('name'=>'sales[address]','class'=>'form-control addr','rows'=>1),set_value('sales[address]',$cust_addr));?>
        			<?=form_error('sales[address]');?>
			    </div>
			 </div>
        </div>
        
        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
    				<label><?=$this->lang->line('email');?></label>
    				<?=form_input(array('name'=>'sales[email_id]','class'=>'form-control mail'),set_value('sales[email_id]',$cust_mail));?>
    				<?=form_error('sales[email_id]');?>
    			</div>
                <div class="col-md-4">
                    <label><?=$this->lang->line('doctor')." ".$this->lang->line('name');?></label>                  
                    <?= form_input(array('name'=>'sales[doctor]','class'=>'form-control doctor'),set_value('sales[doctor]',$doctor)); ?> 
                    <?= form_error('sales[doctor]');?> 
                </div> 
            </div>
        </div>
        
        <div class="form-group">
            <div class="row">  
                <div class="col-md-6 text-right">
                    <label><?=$this->lang->line('prescription');?></label>    
                </div>
            </div>
            <div class="row">  
                <div class="col-md-6 text-center">
                    <label>Right</label>
                    <table class="table table-bordered">
                        <thead>
	                    <tr class="boardered">
	                        <th class="disabled"></th>
	                        <th class="disabled">SPH</th>
	                        <th class="disabled">CYL</th>
	                        <th class="disabled">AXIS</th>
	                        <th class="disabled">V/N</th>	                             
                        </tr>
                        <tr>
                            <th class="disabled">DV</th> 
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="rdv1" name="des[rdv1]" value="<?php echo $des_array['rdv1'] ?>"></td>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="rdv2" name="des[rdv2]" value="<?php echo $des_array['rdv2'] ?>"></td>                                         
                            <td><?= form_input(array('name'=>'des[rdv3]','class'=>'form-control text-right','id'=>'rdv3'),set_value('des[rdv3]',$des_array['rdv3'])); ?></td>
                            <td><?= form_input(array('name'=>'des[rdv4]','class'=>'form-control text-right','id'=>'rdv4'),set_value('des[rdv4]',$des_array['rdv4'])); ?></td>
                        </tr>
                        <tr>
                            <th class="disabled">NV</th>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="rnv1" name="des[rnv1]" value="<?php echo $des_array['rnv1'] ?>"></td>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="rnv2" name="des[rnv2]" value="<?php echo $des_array['rnv2'] ?>"></td>                                        
                            <td><?= form_input(array('name'=>'des[rnv3]','class'=>'form-control text-right','id'=>'rnv3'),set_value('des[rnv3]',$des_array['rnv3'])); ?></td>
                            <td><?= form_input(array('name'=>'des[rnv4]','class'=>'form-control text-right','id'=>'rnv4'),set_value('des[rnv4]',$des_array['rnv4'])); ?></td>
                        </tr>
                        <tr>
                            <th colspan="2" class="disabled">ADD</th>
                            <td ><?= form_input(array('name'=>'des[radd]','class'=>'form-control','id'=>'radd' ),set_value('des[radd]',$des_array['radd'])); ?></td>
                            <th class="disabled">IPD</th>
                            <td><?= form_input(array('name'=>'des[ripg]','class'=>'form-control','id'=>'ripg' ),set_value('des[ripg]',$des_array['ripg'])); ?></td>
                        </tr>
                    </table>                         
                </div>
                <div class="col-md-6 text-center">
                    <label>Left</label>
                    <table class="table table-bordered">
                        <thead>
	                    <tr class="boardered">
	                        <th class="disabled"></th>
	                        <th class="disabled">SPH</th>
	                        <th class="disabled">CYL</th>
	                        <th class="disabled">AXIS</th>
	                        <th class="disabled">V/N</th>	                             
                        </tr>
                        <tr>
                            <th class="disabled">DV</th>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="ldv1" name="des[ldv1]" value="<?php echo $des_array['ldv1'] ?>"></td>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="ldv2" name="des[ldv2]" value="<?php echo $des_array['ldv2'] ?>"></td>                                        
                            <td><?= form_input(array('name'=>'des[ldv3]','class'=>'form-control text-right','id'=>'ldv3' ),set_value('des[ldv3]',$des_array['ldv3'])); ?></td>
                            <td><?= form_input(array('name'=>'des[ldv4]','class'=>'form-control text-right','id'=>'ldv4' ),set_value('des[ldv4]',$des_array['ldv4'])); ?></td>
                        </tr>
                        <tr>
                            <th class="disabled">NV</th>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="lnv1" name="des[lnv1]" value="<?php echo $des_array['lnv1'] ?>"></td>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="lnv2" name="des[lnv2]" value="<?php echo $des_array['lnv2'] ?>"></td>                                        
                            <td><?= form_input(array('name'=>'des[lnv3]','class'=>'form-control text-right','id'=>'lnv3' ),set_value('des[lnv3]',$des_array['lnv3'])); ?></td>
                            <td><?= form_input(array('name'=>'des[lnv4]','class'=>'form-control text-right','id'=>'lnv4' ),set_value('des[lnv4]',$des_array['lnv4'])); ?></td>
                        </tr>
                        <tr>
                            <th colspan="2" class="disabled">ADD</th>
                            <td><?= form_input(array('name'=>'des[ladd]','class'=>'form-control','id'=>'ladd' ),set_value('des[ladd]',$des_array['ladd'])); ?></td>
                            <th class="disabled">IPD</th>
                            <td><?= form_input(array('name'=>'des[lipg]','class'=>'form-control','id'=>'lipg' ),set_value('des[lipg]',$des_array['lipg'])); ?></td>
                        </tr>
                    </table>                         
                </div>
            </div>
        </div>

        <div class="form-group"> 
            <div class="row">
                <div class="col-md-2">
                    <label ><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-4"> 
                    <label class="required"><?=$this->lang->line('item');?></label>
                    <?= form_input(array('name'=>'item_id','class'=>'form-control'),set_value('item_id')); ?>
                    <?= form_error('item_id');?>
                </div>
            </div>
        </div>
        <div class="float-left"><?=$this->lang->line('stock-bal')." : ";?></div><div class="float-left text-bold marg-left-10" id="stock-balance"><?=$stock_count." ".$primary_unit;?></div>
        <div class="form-group">
            <div class="text-right">
                <?=form_submit(array('name' => 'btn_add','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('add-to-bill')));?>
            </div>
        </div>
    </div>
</div>

<?php
if($sales_temp_status > 0)
{
	$uri_array = $this->uri->uri_to_assoc(3);
	$cess = $this->stock->get_cess();
?>
	<div class="row">
	    <div class="col-md-12">
	        <div class='table-responsive'>
	            <table class="table table-bordered table-striped">
            	    <thead>
            	    <tr class="bg-success">
                    	<th>#</th>
                    	<th width="30%" colspan="2"><?= $this->lang->line('item-name');?></th>
                    	<th><?= $this->lang->line('cqty');?></th>
                    	<th><?= $this->lang->line('qty');?></th>
                    	<th><?= $this->lang->line('price'); ?></th>
                    	<th><?= $this->lang->line('cash'); ?> <?= $this->lang->line('dis'); ?></th>
                    	<th><?= $this->lang->line('taxable'); ?></th>
                        <th><?= $this->lang->line('tax'); ?>(%) <?= $this->lang->line('cgst'); ?></th>
                        <th><?= $this->lang->line('tax'); ?> <?= $this->lang->line('amt'); ?></th>
                        <th><?= $this->lang->line('tax'); ?>(%) <?= $this->lang->line('sgst'); ?></th>
                        <th><?= $this->lang->line('tax'); ?> <?= $this->lang->line('amt'); ?></th>
                        <th><?= $this->lang->line('cess'); ?> (%)</th>
                        <th><?= $this->lang->line('cess'); ?> <?= $this->lang->line('amt'); ?></th>
                    	<th width="10%"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                    	<th colspan='2'><?=$this->lang->line('actions');?></th>
                	</tr>
	                </thead>
<?php
                	$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0; $totalFreight=0; $totalTaxable=0;
                	$grandNetAmount=0;$total_cst_amount = 0; $a=14;$b=12; $totalcgst=0; $totalsgst=0; $totalcess=0;
                	foreach($sales_temp_data as $key => $item)
                	{
                		$i++; 
                		$itemID = $item['item_id'];
                		$item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
                		$qty = $item['qty'];
                		$rate = $item['rate'];
                		$godown = $item['godown_id'];
                		$cqty = $this->stock->get_stock_count($godown,$itemID,date('Y-m-d'));
                		
                		$discount_per = $item['discount_per'];
                		$discount_amt = $item['discount_amt'];
                		$cst_percent = $item['cst'];
                		$vat = 0;$vatAmount = 0;$cst_amount = 0;$cgst=0;$sgst=0;$cgstAmt=0;$sgstAmt=0;
                		$amount = $item['amount'];
                		$taxable = $item['taxable_amt'];
                		$totalAmount += $amount;
                		$netValue = $amount-$discount_amt;
                		
                		$cgst =  $item['cgst']; // $this->stock->get_item_cgst($itemID);
                		$sgst =  $item['sgst']; //$this->stock->get_item_sgst($itemID);
                		$vat = $cgst + $sgst ;
                		$cgstAmt = $item['cgst_amt'];
                		$sgstAmt = $item['sgst_amt'];
                		$cessAmt = $item['cess_amt'];
                		$vatAmount = $cgstAmt + $sgstAmt;
                		
                		$totalVatAmt += $vatAmount;
                		$totalTaxable += $taxable;
                		$totalcgst += $cgstAmt;
                		$totalsgst += $sgstAmt;
                		$totalcess += $cessAmt;
                		
                		$total_cst_amount += $cst_amount;
                		$totalNetValue += $taxable;
                		$netAmount = get_rounded($taxable+$vatAmount+$cessAmt);
                		$totalNetAmount += $netAmount;
                		$totalDiscountAmt += $discount_amt;
?>
                		<tr>
                    		<td><?= $i; ?></td>
                    		<td colspan="2"><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
                    		<td class="text-right"><b><font color="#2F5923"><?= $cqty; ?></font></b></td>
                    		<td class="text-right"><?= $qty; ?></td>
                    		<td class="text-right"><?= numberFormat($rate); ?></td>
                    		<td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
                    		<td class="text-right"><?= numberFormat(round_this($taxable)); ?></td>
            				<td class="text-right"><?= $cgst; ?></td>
            				<td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
                            <td class="text-right"><?= $sgst; ?></td>
                	        <td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>	
                            <td class="text-right"><?= numberFormat($cess); ?></td>
                            <td class="text-right"><?= numberFormat($cessAmt); ?></td>
		                    <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                            <?php app_table_links('ida/'.$item['id'].'gida/'.$item['group_id'],array(624,625));?>
		                </tr>
<?php
	                }
	                $grandNetAmount = round_this($totalNetAmount);
?>
	                <tr>
                    	<td class="text-right text-bold" colspan="7"><?= $this->lang->line('total'); ?></td>
                    	<td class="text-right text-bold"><?= numberFormat(round_this($totalTaxable)); ?></td>
                    	<td class="disabled"></td>
                    	<td class="text-right text-bold"><?= numberFormat(round_this($totalcgst)); ?></td>
                    	<td class="disabled"></td>
                    	<td class="text-right text-bold"><?= numberFormat(round_this($totalsgst)); ?></td>
		                <td class="disabled"></td>
		                <td class="text-right text-bold"><?= numberFormat(round_this($totalcess)); ?></td>
                	    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                	    <td colspan="2" class="disabled"></td>
                	</tr>
<?php 
                    $presumptive_tax_amt = 0;
                	if(!empty($presumptive_tax))
                	{
                		$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
                		$grandNetAmount += round_this($presumptive_tax_amt);
                		$totalVatAmt = round_this($presumptive_tax_amt);
?>
                        <tr>
                            <!--<td colspan="2"></td>-->
                            <td colspan="<?=($b-$colspan);?>" class="text-right">
                            <span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
                            <td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
                            <td colspan="2" class="disabled"></td>
                        </tr>
<?php 
                    }
                  
                  //  $cess_amt = (($totalVatAmt+$total_cst_amount)*$cess)/100;
                //	$grandNetAmount += round_this($cess_amt);
?>
                    <tr>
                        <td colspan="2" class="text-right text-bold required"><?=$this->lang->line('area');?></td>
                	    <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                        	<div class="row">
                                <div class="col-md-9"><?= form_dropdown('area_id',$areas,set_value('area_id'),'class="form-control"'); ?><?= form_error('area_id');?></div>
                                <div class="col-md-3 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
                    		</div>
                    	</td>
                        <td class="text-right"><?=numberFormat(round_this($totalcess));?></td>
                	    <td colspan="2" class="disabled"></td>
                	</tr>
                    <tr>
                        <td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?></td>
                    	<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                            <div class="row">
                            	<div class="col-md-3"><?= form_dropdown('payment_mode',$payment_mode,set_value('payment_mode'),'class="form-control payment-mode"'); ?><?= form_error('payment_mode');?></div>
                                <div class="col-md-3"><?= $this->lang->line('credit-period');?></div>
                                <div class="col-md-3"><?= form_input(array('name'=>'credit_period','class'=>'form-control number text-right'),set_value('credit_period')); ?><?=form_error('credit_period');?></div>
                            	<div class="col-md-3 pull-right"><?= $this->lang->line('freight');?></div>
                            </div>
                    	</td>
                	    <td><?= form_input(array('name'=>'freight','class'=>'form-control decimal text-right width-150 pull-right freight-amt'),set_value('freight')); ?><?=form_error('freight');?></td>
                	    <td colspan="2" class="disabled"></td>
                	</tr>
                	<tr>
                	    <td colspan="<?=($a-$colspan);?>" class="text-right text-bold">
                            <div class="cd-ajax <?php if($cd_status){?>hide<?php }?>">
                                <div class="row">
                                    <div class="col-md-3">
                                        <?php $transaction_types = $this->dms->transaction_types();?>
                                        <?= form_dropdown('ccd',$transaction_types,set_value('ccd'),'class="form-control"'); ?>
                                        <?=form_error('ccd');?>
                                    </div>
                                    <div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
                                    <div class="col-md-3">
                                        <?=form_input('cd_no',set_value('cd_no'),"class='form-control'");?>
                                        <?=form_error('cd_no');?>
                                    </div>
                                    <div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
                                    <div class="col-md-2">
                                        <?=form_input('cheque_date',set_value('cheque_date',cdateFormat($voucher_date)),"class='datepicker form-control'");?>
                                        <?=form_error('cheque_date');?>
                                    </div>
                                </div>
                            </div>
    	                </td>
                        <td></td>
                        <td colspan="2" class="disabled"></td>
	                </tr>
                    <tr>
                    	<td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
                    	<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                    		<div class="row">
                    		    <div class="col-md-9 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks')); ?><?=form_error('remarks');?></div>
                                <div class="col-md-3 pull-right"><?= $this->lang->line('other-expense');?></div>
                    		</div>
                    	</td>
                    	<td><?= form_input(array('name'=>'other_expense','class'=>'form-control text-right width-150 pull-right other-expense decimal'),set_value('other_expense')); ?><?=form_error('other_expense');?></td>
                    	<td colspan="2" class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
                	</tr>
<?php
                	if($this->input->post('freight'))
                	{
                		$grandNetAmount += $this->input->post('freight');
                	}
                	if($this->input->post('other_expense'))
                	{
                		$grandNetAmount += $this->input->post('other_expense');
                	}
                	if($this->input->post('bill_discount_amt'))
                	{
                		$grandNetAmount -= $this->input->post('bill_discount_amt');
                	}

                    if(show_round_off())
                    { 
?>
                        <tr>
                            <td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
                                <div class="row">
                                    <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
                                </div>
                            </td>
                            <td class="text-right text-bold"><div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div></td>
                    	    <td colspan="2" class="disabled"></td>
                    	</tr>
<?php 
	                } 
?>
                    <tr>
                        <td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
                        <td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
                            <div class="row">
                                <div class="col-md-3 pull-left">
                                    <?= form_input(array('name'=>'bill_discount_per','class'=>'form-control text-right bill_discount_percent decimal'),set_value('bill_discount_per')); ?><?=form_error('bill_discount_per');?>
                                </div>
                                <div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
                                <div class="col-md-3"><?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amount decimal text-right'),set_value('bill_discount_amt')); ?><?=form_error('bill_discount_amt');?></div>
                                <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
                            </div>
                        </td>
                        <td class="text-right text-bold">
                        	<div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div>
                    	</td>
                	    <td colspan="2" class="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-right text-bold" colspan="2"><?=$this->lang->line('delivery');?> <?=$this->lang->line('date');?></td>
                    	<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                    		<div class="row">
                    		    <div class="col-md-5 pull-left">
                    		        <?= form_input(array('name'=>'d_date','class'=>'datepicker form-control text-right d_date decimal'),set_value('d_date')); ?>
                                    <?=form_error('d_date');?>
                                </div>
                                <div class="col-md-3 pull-right required"><?=$this->lang->line('advance');?> <?=$this->lang->line('amount');?></div>
                    		</div>
                    	</td>
                    	<td>
                    	    <?= form_input(array('name'=>'bill_advance','class'=>'form-control text-right bill_advance decimal'),set_value('bill_advance',0)); ?>
                            <?=form_error('bill_advance');?>
                        </td>
                        <td colspan="2" class="disabled"></td>
                    </tr>
                    <input type="hidden" name="round_off_amount" id="round_value" value="<?= round_off($grandNetAmount); ?>">
                    <input type="hidden" name="vat_total" value="<?=round_this($totalVatAmt); ?>">
                    <input type="hidden" name="cess_total" value="<?=round_this($totalcess); ?>">
                    <input type="hidden" name="grand_total" value="<?=round_this($totalNetValue); ?>">
	            </table>
	        </div>
        </div>
    </div>

	<div class="row">
    	<div class="col-md-12">
    		<div class="form-group">
    			<div class="text-right">
    				<?= form_submit(array('name'=>'btn_save','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('generate-bill')));?>
    			</div>
    		</div>
    	</div>
	</div>
<?php
}
?>
<?= form_close();?>