<div class="panel panel-primary">
    <div class="panel-heading">
        <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("view")." ".$this->lang->line("bill");?></h6>
    </div>
    <div class="panel-body">
<?php 
        if($this->uri->segment(1) == 'booking')
        { 
?>
            <div class="row">
                <div class="col-md-12">
                    <?php app_export_menus('id/'.$sales_array[0]['primary_id'],array(620,629));?>
                </div>
            </div>
<?php 
        } 
?>
        <?php $bill_prefix = $this->stock->get_voucher_prefix($sales_array[0]['vtype_id']); ?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('voucher-types');?></label>
                    <input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
                </div>
                <div class="col-md-4">
                    <label><?=$this->lang->line('bill-no');?></label>
                    <div class="input-group">
                        <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                        <input type="text" class="form-control" disabled value="<?=$sales_array[0]['bill_no'];?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label><?=$this->lang->line('bill-date');?></label>
                    <input type="text" class="form-control" disabled value="<?=dateFormat($sales_array[0]['bill_date']);?>">
                </div>
            </div>
        </div>
        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('customer-name');?></label>
                    <input type="text" class="form-control" disabled value="<?=$customer_name;?>">
                </div>
                <div class="col-md-4">
                    <label><?=$this->lang->line('phone');?></label>
                    <input type="text" class="form-control" disabled value="<?=$customer_mob;?>">
                </div>
                <div class="col-md-4">
                    <label><?=$this->lang->line('doctor');?></label>
                    <input type="text" class="form-control" disabled value="<?=$doctor?>">
                </div>
            </div>
        </div>
        
        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('vendor');?></label>
                    <input type="text" class="form-control" disabled value="<?=$vendor_name;?>">
                </div>
                <div class="col-md-4">
                    <label><?=$this->lang->line('lence-refno');?></label>
                    <input type="text" class="form-control" disabled value="<?=$lens_refno;?>">
                </div>
                <div class="col-md-4">
                    <label><?=$this->lang->line('lence-qty');?></label>
                    <input type="text" class="form-control" disabled value="<?=$lens_qty?>">
                </div>
            </div>
        </div>
        
        
        
        
        <div class="form-group">
            <div class="row">  
                <div class="col-md-6 text-right">
                    <label><?=$this->lang->line('prescription');?></label>    
                </div>
            </div>
            <div class="row">  
                <div class="col-md-6 text-center">
                    <label>Right</label>
                    <table class="table table-bordered">
                        <thead>
	                    <tr class="boardered">
	                        <th class="disabled"></th>
	                        <th class="disabled">SPH</th>
	                        <th class="disabled">CYL</th>
	                        <th class="disabled">AXIS</th>
	                        <th class="disabled">V/N</th>	                             
                        </tr>
                        <tr>
                            <th class="disabled">DV</th> 
                            <td><input type="text" class="form-control" readonly value="<?php if($des_array['rdv1']>0){echo "+".$des_array['rdv1'];}else{echo $des_array['rdv1'];} ?>"></td>
                            <td><input type="text" class="form-control" readonly value="<?php if($des_array['rdv2']>0){echo "+".$des_array['rdv2'];}else{echo $des_array['rdv2'];} ?>"></td>                                       
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['rdv3']; ?>"></td>
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['rdv4']; ?>"></td>
                        </tr>
                        <tr>
                            <th class="disabled">NV</th>
                            <td><input type="text" class="form-control" readonly value="<?php if($des_array['rnv1']>0){echo "+".$des_array['rnv1'];}else{echo $des_array['rnv1'];} ?>"></td>
                            <td><input type="text" class="form-control" readonly value="<?php if($des_array['rnv2']>0){echo "+".$des_array['rnv2'];}else{echo $des_array['rnv2'];} ?>"></td>                                        
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['rnv3']; ?>"></td>
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['rnv4']; ?>"></td>
                        </tr>
                        <tr>
                            <th colspan="2" class="disabled">ADD</th>
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['radd']; ?>"></td>
                            <th class="disabled">IPD</th>
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['ripg']; ?>"></td>
                        </tr>
                    </table>                         
                </div>
                <div class="col-md-6 text-center">
                    <label>Left</label>
                    <table class="table table-bordered">
                        <thead>
	                    <tr class="boardered">
	                        <th class="disabled"></th>
	                        <th class="disabled">SPH</th>
	                        <th class="disabled">CYL</th>
	                        <th class="disabled">AXIS</th>
	                        <th class="disabled">V/N</th>	                             
                        </tr>
                        <tr>
                            <th class="disabled">DV</th>
                            <td><input type="text" class="form-control" readonly value="<?php if($des_array['ldv1']>0){echo "+".$des_array['ldv1'];}else{echo $des_array['ldv1'];} ?>"></td>
                            <td><input type="text" class="form-control" readonly value="<?php if($des_array['ldv2']>0){echo "+".$des_array['ldv2'];}else{echo $des_array['ldv2'];} ?>"></td>                                       
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['ldv3']; ?>"></td>
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['ldv4']; ?>"></td>
                        </tr>
                        <tr>
                            <th class="disabled">NV</th>
                            <td><input type="text" class="form-control" readonly value="<?php if($des_array['lnv1']>0){echo "+".$des_array['lnv1'];}else{echo $des_array['lnv1'];} ?>"></td>
                            <td><input type="text" class="form-control" readonly value="<?php if($des_array['lnv2']>0){echo "+".$des_array['lnv2'];}else{echo $des_array['lnv2'];} ?>"></td>                                        
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['lnv3']; ?>"></td>
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['lnv4']; ?>"></td>
                        </tr>
                        <tr>
                            <th colspan="2">ADD</th>
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['ladd']; ?>"></td>
                            <th class="disabled">IPD</th>
                            <td><input type="text" class="form-control" readonly value="<?php echo $des_array['lipg']; ?>"></td>
                        </tr>
                    </table>                         
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-12">
                <div class='table-responsive'>
                    <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                            <th>#</th>
                        	<th width="30%"><?= $this->lang->line('item-name');?></th>
                        	<th><?= $this->lang->line('cqty');?></th>
                        	<th><?= $this->lang->line('qty');?></th>
                        	<th><?= $this->lang->line('price'); ?></th>
                        	<th><?= $this->lang->line('cash'); ?> <?= $this->lang->line('dis'); ?></th>
                        	<th><?= $this->lang->line('taxable'); ?></th>
                            <th><?= $this->lang->line('tax'); ?>(%) <?= $this->lang->line('cgst'); ?></th>
                            <th><?= $this->lang->line('tax'); ?> <?= $this->lang->line('amt'); ?></th>
                            <th><?= $this->lang->line('tax'); ?>(%) <?= $this->lang->line('sgst'); ?></th>
                            <th><?= $this->lang->line('tax'); ?> <?= $this->lang->line('amt'); ?></th>
                            <th><?= $this->lang->line('cess'); ?> (%)</th>
                            <th><?= $this->lang->line('cess'); ?> <?= $this->lang->line('amt'); ?></th>
                        	<th width="10%"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                        </tr>
                        </thead>
<?php
                        $i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0; $totalTaxable=0; //$totalFreight=0;
                        $grandNetAmount=0;$total_cst_amount = 0; $a=13; $b=11; $totalcgst=0; $totalsgst=0; $totalcess=0;
                        $cess = $sales_array[0]['cess'];
                        foreach($sales_array as $key => $item)
                        {
                            $i++;
                            $itemID = $item['item_id'];
                            $item_details = $this->stock->get_item($itemID,array('item_code','item_name','model_no'));
                            $qty = $item['qty'];
                            $rate = $item['rate'];
                            $godown = $item['godown_id'];
                		    $cqty = $this->stock->get_stock_count($godown,$itemID,date('Y-m-d'));
                            $discount_per = $item['discount_per'];
                            $discount_amt = $item['discount_amt'];
                            $cst_percent = $item['cst'];
                            $vat = 0;$vatAmount = 0;$cst_amount = 0;
                            $amount = $item['amount'];
                            $taxable = $item['taxable_amt'];
                            $totalAmount += $amount;
                            $netValue = $amount-$discount_amt;
               
                            $cgst= $item['cgst']; // $this->stock->get_item_cgst($itemID);
                            $sgst = $item['sgst']; // $this->stock->get_item_sgst($itemID);
                            $cgstAmt = $item['cgst_amt'];
                            $sgstAmt = $item['sgst_amt'];
                            $cessAmt = $item['cess_amt'];
                            $vatAmount = $cgstAmt + $sgstAmt;
                                
                            $totalVatAmt += $vatAmount;
                            $totalTaxable += $taxable;
                    		$totalcgst += $cgstAmt;
                    		$totalsgst += $sgstAmt;
                    		$totalcess += $cessAmt;
                            
                            $total_cst_amount += $cst_amount;
                    		$totalNetValue += $taxable;
                    		$netAmount = $taxable+$vatAmount+$cessAmt;
                    		$totalNetAmount += $netAmount;
                    		$totalDiscountAmt += $discount_amt;
?>
                            <tr>
                                <td><?= $i; ?></td>
                                <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?> / <?= $item_details['model_no']; ?></td>
                                <td class="text-right"><b><font color="#2F5923"><?= $cqty; ?></font></b></td>
                                <td class="text-right"><?= $qty; ?></td>
                                <td class="text-right"><?= numberFormat($rate); ?></td>
                                <td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
                                <td class="text-right"><?= numberFormat(round_this($taxable)); ?></td>
                				<td class="text-right"><?= $cgst; ?></td>
                				<td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
                                <td class="text-right"><?= $sgst; ?></td>
                    	        <td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>	
                                <td class="text-right"><?= numberFormat($cess); ?></td>
                                <td class="text-right"><?= numberFormat($cessAmt); ?></td>
    		                    <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                            </tr>
<?php
                        }
                        $grandNetAmount = round_this($totalNetAmount);
?>
                        <tr>
                            <td class="text-right text-bold" colspan="6"><?= $this->lang->line('total'); ?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalTaxable)); ?></td>
                        	<td class="disabled"></td>
                        	<td class="text-right text-bold"><?= numberFormat(round_this($totalcgst)); ?></td>
                        	<td class="disabled"></td>
                        	<td class="text-right text-bold"><?= numberFormat(round_this($totalsgst)); ?></td>
    		                <td class="disabled"></td>
    		                <td class="text-right text-bold"><?= numberFormat(round_this($totalcess)); ?></td>
                    	    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                        </tr>
<?php 
                        $presumptive_tax_amt = 0;
                        if(!empty($presumptive_tax))
                        {
                            $presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
                            $grandNetAmount += round_this($presumptive_tax_amt);
?>
                            <tr>
                                <td colspan="<?=($a-$colspan);?>" class="text-right">
                                <span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
                                <td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
                            </tr>
<?php 
                        }

                       // $cess_amt = (($totalVatAmt+$total_cst_amount+$presumptive_tax_amt)*$cess)/100;
                       // $grandNetAmount += round_this($cess_amt);
?>
                        <tr>
                            <td colspan="2" class="text-right text-bold"><?=$this->lang->line('area');?></td>
                            <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                                <div class="row">
                                    <div class="col-md-9"><input class="form-control" type="text" disabled value="<?=$area_id;?>"></div>
                                    <div class="col-md-3 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
                                </div>
                            </td>
                            <td class="text-right"><?=numberFormat(round_this($totalcess));?></td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?></td>
                            <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                                <div class="row">
                                    <div class="col-md-3"><input class="form-control" type="text" disabled value="<?=$payment_mode;?>"></div>
                                    <div class="col-md-3"><?= $this->lang->line('credit-period');?></div>
                                    <div class="col-md-3"><input class="form-control text-right" type="text" disabled value="<?=$sales_array[0]['cr_period'];?>"></div>
                                    <div class="col-md-3 pull-right"><?= $this->lang->line('freight');?></div>
                                </div>
                            </td>
                            <td class="text-right"><?=numberFormat(round_this($sales_array[0]['bill_freight']));?></td>
                        </tr>
                        <tr>
                        	<td colspan="<?=($a-$colspan);?>" class="text-right text-bold">
                                <div class="cd-ajax <?php if($cd_status){?>hide<?php }?>">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <?php $transaction_types = $this->dms->transaction_types();?>
                                            <?= form_dropdown('ccd',$transaction_types,set_value('ccd',$ccd),'class="form-control" disabled'); ?>
                                        </div>
                                        <div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
                                        <div class="col-md-3">
                                            <?=form_input('cd_no',set_value('cd_no',$cd_no),"class='form-control' disabled");?>
                                        </div>
                                        <div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
                                        <div class="col-md-2">
                                            <?=form_input('cheque_date',set_value('cheque_date',dateFormat($pdc)),"class='datepicker form-control' disabled");?>
                                        </div>
                                    </div>
                                </div>
                        	</td>
                            <td></td>
                    	</tr>
                        <tr>
                            <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
                            <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                                <div class="row">
                                    <div class="col-md-9 pull-left"><textarea class="form-control" disabled><?=$sales_array[0]['narration'];?></textarea></div>
                                    <div class="col-md-3 pull-right"><?= $this->lang->line('other-expense');?></div>
                                </div>
                            </td>
                            <td class="text-right"><?=numberFormat(round_this($sales_array[0]['other_expense']));?></td>
                        </tr>
<?php
	                    $grandNetAmount += (($sales_array[0]['bill_freight']+$sales_array[0]['other_expense']));

                        if(show_round_off())
                        { 
?>
                            <tr>
                                <td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
                                    <div class="row">
                                        <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
                                    </div>
                                </td>
                                <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(round_off($grandNetAmount)); ?></div></td>
                            </tr>
<?php 
                        } 
?>
                        <tr>
                            <td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
                            <td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
                                <div class="row">
                                    <div class="col-md-3 pull-left"><input class="form-control text-right" type="text" disabled value="<?=$sales_array[0]['bill_discount_per'];?>"></div>
                                    <div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
                                    <div class="col-md-3"><input class="form-control text-right" type="text" disabled value="<?=$sales_array[0]['bill_discount_amt'];?>"></div>
                                    <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
                                </div>
                            </td>
                            <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
                        </tr>
                        <tr>
                            <td class="text-right text-bold" colspan="2"><?=$this->lang->line('delivery');?> <?=$this->lang->line('date');?></td>
                            <td colspan="3" class="text-right text-bold">
                        		<div class="row">
                        		    <div class="col-md-10 pull-left">
                                        <?= form_input(array('name'=>'del_date','class'=>'form-control text-right del_date disabled'),set_value('del_date',dateFormat($sales_array[0]['delivery_date']))); ?>
                                        <?=form_error('del_date');?>
                                    </div>
                                </div>
                            </td>
                            <td class="text-right text-bold" colspan="2"><?=$this->lang->line('paid');?> <?=$this->lang->line('amount');?></td>
	                        <td colspan="3" class="text-right text-bold">
                        		<div class="row">
                        		    <div class="col-md-10 pull-left">
                                        <?= form_input(array('name'=>'bill_advance','class'=>'form-control text-right bill_advance decimal disabled'),set_value('bill_advance',numberFormat($paid_amt))); ?>
                                        <?=form_error('bill_advance');?>
                                    </div>
                                </div>
                            </td>
                            <td colspan="3" class="text-right text-bold">
                                <div class="row">
                                    <div class="col-md-10 pull-right "><?=$this->lang->line('balance');?> <?=$this->lang->line('amount');?></div>
		                        </div>
                        	</td>
                        	<td class="text-right text-bold"><?=numberFormat($bal_amt);?></td>
                        </tr>
                    </table>
                </div>

                <div class="row">
                    <div class="col-md-7 pull-left text-bold"><?=$this->lang->line('last-updated-by')." : ".get_username($sales_array[0]['created_by']);?></div>
                    <div class="col-md-5 text-right text-bold"><?=$this->lang->line('last-updated-on')." : ".dateTimeFormat($sales_array[0]['created_on']);?></div>
                </div>

            </div>
        </div>
    </div>
</div>