<style>
*{	font-size:10px; line-height:1.3em;}
.pdf-head{	font-weight:bold; margin-left:auto; margin-right:auto; text-align:center;}
.data-table{	font-size:10px;}
.text-right{	text-align:right;}
.text-center{	text-align:center;}
.text-bold{	font-weight:bold;}
.vendor{ text-indent:20px;}
.data-list{	padding:2px;}
.data-list th{	font-size:10px; text-align:center; background-color:#E4E4E4; font-weight:bold;}
.data-list td{	font-size:9px;}
.disabled{background-color:#E1E1E1;}
.italic{ font-style:italic;}
</style>
<?php
if(!empty($receipts)){
	$receiptDetails = $receipts[0];
	$bill_no = $receiptDetails['bill_no'];
	$bill_date = $receiptDetails['bill_date'];
	$customerID = $receiptDetails['customer_id'];
	$payment_mode = $receiptDetails['payment_mode'];
	$cash_type = $receiptDetails['cash_type'];
	$ledger_name = $receiptDetails['ledger_name'];
	$cheque_no = $receiptDetails['cheque_no'];
	$cheque_date = $receiptDetails['cheque_date'];
	$narration = $receiptDetails['narration'];
	$args = array();
	$args['return'] = 1;
	$args['conditions'] = array('id'=>$customerID);
	$vendorDetails = $this->stock->get_vendors($args);	
	?>
    <div class="pdf-head">PAYMENT VOUCHER</div>
    <table  class="data-table" border="0">
    <tr>
    <td class="text-right">
        <span class="text-bold">Bill. No. : </span><?= $bill_no; ?><br/>
        <span class="text-bold">Bill Date : </span><?= dateFormat($bill_date); ?>
    </td>
    </tr>
    <tr><td>To ,</td></tr>
    <tr><td class="vendor text-bold"><?= $vendorDetails['name']; ?></td></tr>
    <tr><td class="vendor"><?= $vendorDetails['address']; ?><?= (!empty($vendorDetails['pincode']))?' , Pin : '.$vendorDetails['pincode']:''; ?></td></tr>
    <tr><td class="vendor"><?= (!empty($vendorDetails['phone']))?'Phone : '.$vendorDetails['phone']:''; ?>
    <?= (!empty($vendorDetails['email']))?', Email  : '.$vendorDetails['email']:''; ?></td></tr>
    <tr><td class="vendor"><?= (!empty($vendorDetails['tin_no']))?'TIN : '.$vendorDetails['tin_no']:''; ?><?= (!empty($vendorDetails['pan_no']))?'PAN : '.$vendorDetails['pan_no']:''; ?></td></tr>
    </table>
	<div></div>
	<?php if(!empty($receipts)){?>
        <table class="table data-table data-list" border="1" width="635px">
        <thead>
        <tr>
        <th width="20px">#</th>
        <th>Bill No.</th>
        <th>Bill Date</th>
        <th>Bill Amount</th>
        <th>Prev. Payments</th>
        <th>Amount</th>
        <th>Discount</th>
        <th>Net Amount</th>  
        </tr>
        </thead>
		<?php
		$i=0;$total_bill_amount=$total_paid_amount=$total_received_amount=$total_balance_amount=$total_discount_amount=$grand_total=0;
		foreach($receipts as $key=>$receipt){$i++;
			$total=0;
			$previous_receipts=$bill_amount=$received_amount=$paid_amount=0;
			$sales_bill = $this->payment_ab_lib->get_purchase_bill($receipt['ps_id']);
			$bill_amount = round_this($sales_bill['bill_amount']);		
		
			$received_amount = $receipt['received_amount'];
			$receipt_discount = $receipt['discount'];
			$condition = array('dvab.bill_date <='=>$receipt['bill_date'],'dvab.bill_no <='=>$receipt['bill_no']);
			$paid_amount = $this->payment_ab_lib->get_bill_payment($receipt['ps_id'],$condition);
			if($paid_amount >0){
				$previous_receipts = $paid_amount-$received_amount;
			}
			$balance_amount = $bill_amount-($paid_amount);
			$total = $received_amount-$receipt_discount;
			$grand_total += $total;
			$total_discount_amount += $receipt_discount;
			$total_bill_amount += $bill_amount;
			$total_paid_amount += $previous_receipts;
			$total_received_amount += $received_amount;
			$total_balance_amount += $balance_amount;					
			?>
            <tr>
            <td class="text-center" width="20px"><?= $i; ?></td>
            <td><?= $receipt['purchase_bill_no']; ?></td>
            <td class="text-center"><?= dateFormat($receipt['purchase_bill_date']); ?></td>
            <td class="text-right"><?= numberFormat(get_rounded($bill_amount)); ?></td>
            <td class="text-right"><?= numberFormat(round_this($previous_receipts)); ?></td>
            <td class="text-right"><?= numberFormat(round_this($received_amount)); ?></td>
            <td class="text-right"><?= numberFormat(round_this($receipt_discount)); ?></td>
            <td class="text-right"><?= numberFormat(round_this($total)); ?></td>
            </tr>
            <?php
		}?>
        <tr>
        <td colspan="3" class="text-right text-bold">Total</td>
        <td class="text-right text-bold"><?= numberFormat($total_bill_amount); ?></td>
        <td class="text-right text-bold"><?= numberFormat($total_paid_amount); ?></td>
        <td class="text-right text-bold"><?= numberFormat($total_received_amount); ?></td>
        <td class="text-right text-bold"><?= numberFormat($total_discount_amount); ?></td>
        <td class="text-right text-bold"><?= numberFormat($grand_total); ?></td>
        </tr>
    	</table>       
		<?php
		$cashTypes = array(0=>'CASH',1=>'Cheque',2=>'DD');
		$cashType = $cashTypes[$cash_type];
		if($cash_type == 0){$ledger_name = NULL;}
		?>
		<div class="text-right italic">
			<?= $this->to_words->num_to_words(round_this($grand_total)); ?>
		</div>
		<br>
        <table border="0">
        <tr>
            <td colspan="2">Payment Mode</td>
            <td colspan="7">: <?= $cashType; ?></td>
        </tr>
        <tr>
            <td colspan="2">Cheque / DD No </td>
            <td colspan="4">: <?= $cheque_no; ?></td>
            <td>Date</td>
            <td colspan="2">: <?= dateFormat($cheque_date); ?></td>
        </tr>
        <tr>
            <td colspan="2">Bank</td>
            <td colspan="7">: <?= $ledger_name; ?></td>
        </tr>
        </table>
		<br>
		<div><label>Narration :</label><label><?= $narration; ?></label></div>
		<div class="text-right text-bold">Authorised Signatory.</div>
		<?php
	}
}
?>