<?php if(!empty($payments)){ ?>
<div class="panel panel-primary">
    <div class="panel-heading">
    	<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('payment-against-bill-report'); ?> </h6>
    </div>
    <div class="panel-body">
	<?php
	$uriString=NULL;
	if($this->uri->uri_to_assoc(3)){
		$uriArray = $this->uri->uri_to_assoc(3);
		$uriString = $this->uri->assoc_to_uri($uriArray);
	}else{
		$uriString = $from_date.'/'.$to_date;
	}
	?>
	<div class="form-group">
		<div class="row">
			<div class="col-md-12">
				<?= export_to_excel('payment_against_bill/excel/'.$from_date.'/'.$to_date); ?>
			</div>
		</div>
        <div class="row">
            <div class="col-md-12">
                <div class='table-responsive'>
                <table class="table table-bordered table-striped">
                <thead>
                <tr class="bg-success">
                <th>#</th>
                <th><?= $this->lang->line('bill-no'); ?></th>
                <th><?= $this->lang->line('bill-date'); ?></th>
                <th><?= $this->lang->line('bill-amount'); ?></th>
                <th><?= $this->lang->line('vendor'); ?></th>
                <th><?= $this->lang->line('narration'); ?></th>
                <th colspan="4"><?= $this->lang->line('actions'); ?></th>
                </tr>
                </thead>
            	<?php
				foreach($payments as $key=>$payment){
				$receiptID= $payment['id'];
					?>
					<tr>
					<td class="text-center"><?= $count++; ?></td>
					<td><?= $payment['bill_no']; ?></td>
					<td><?= dateFormat($payment['bill_date']); ?></td>
					<td class="text-right"><?= numberFormat(get_rounded($payment['amount'])); ?></td>
					<td><?= $payment['manufacturer_name'];?></td>
					<td><?= $payment['narration']; ?></td>
					<?= app_table_links($receiptID.'/'.$uriString,array(393,394,395,396)); ?>
					</tr>
					<?php
				}
			?>
            </table>
            </div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
    	<div class="pagination"><?= $links; ?></div>
    </div>
</div>
<?php } ?>