<?= form_open(); ?>
<div class="panel panel-primary">
    <div class="panel-heading">
    	<h6 class="panel-title">
    		<i class="icon-database"></i><?=$this->lang->line('open-stock-details');?>
		</h6>
	</div>
    <div class="panel-body">
        
        <div class="form-group">
            <div class="row">
            	<div class="col-md-6">
                	<label><?=$this->lang->line('item-code');?></label>
                    <?= form_input(array('value'=>$openings['item_code'],'class'=>'form-control','disabled'=>true)); ?>
                </div>
            	<div class="col-md-6">
                	<label><?=$this->lang->line('item-name');?></label>
                    <?= form_input(array('value'=>$openings['item_name'],'class'=>'form-control','disabled'=>true)); ?>
                </div>
                <div class="col-md-6">
                	<label><?=$this->lang->line('model-no');?></label>
                    <?= form_input(array('value'=>$openings['model_no'],'class'=>'form-control','disabled'=>true)); ?>
                </div>
            </div>
        </div>
    
        <div class="form-group">
            <div class="row">
            	<div class="col-md-6">
                	<label><?=$this->lang->line('opening-date');?></label>
                    <?= form_input(array('class'=>'form-control','value'=>dateFormat($openings['stock_date']),'readonly'=>true)); ?>
                </div>
                <div class="col-md-6">
                	<label><?=$this->lang->line('godown');?></label>
                    <?= form_input(array('class'=>'form-control','value'=>$openings['godown_code'].' '.$openings['godown_name'],'readonly'=>true)); ?>
                </div>
            </div>
        </div>
    
        <div class="form-group">
            <div class="row">
            	<div class="col-md-3">
                	<label><?=$this->lang->line('current-quantity');?></label>
                    <?= form_input(array('name'=>'curr_qty','class'=>'form-control','value'=>set_value('curr_qty',$current_opening),'disabled'=>true)); ?>
                    <?= form_error('curr_qty'); ?>
                </div>
                <div class="col-md-3">
                	<label class="required"><?=$this->lang->line('actual-opening-quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control decimal','value'=>set_value('qty',$openings['qty']))); ?>
                    <?= form_error('qty'); ?>
                </div>

				<div class="col-md-3">
                	<label><?=$this->lang->line('unit');?></label>
                    <?= form_input(array('class'=>'form-control','value'=>$openings['symbol'],'readonly'=>true)); ?>
                </div>

				<div class="col-md-3">
                	<label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control decimal','value'=>set_value('rate',$openings['rate']))); ?>
                    <?= form_error('rate'); ?>
                </div>
            </div>
        </div>
    
        <div class="form-group">
            <div class="text-right">
                <?=form_button(array('type'=>'submit','class'=>'btn btn-primary pull-right btn-loading','content'=>$this->lang->line('update')));?>
            </div>	
        </div>
    </div>	
</div>    

