<?= form_open(base_url('opening_stock/report/')); ?>
<div class="panel panel-primary">
	<div class="panel-heading">
		<h6 class="panel-title"><i class="icon-database"></i><?=$this->lang->line('search');?></h6>
	</div>
    <div class="panel-body">
    
        <div class="form-group">
            <div class="row">
                <label class="col-md-2"><?= $this->lang->line('item-name'); ?></label>
                <div class="col-md-3">
                    <?= form_dropdown('item_id',$items,set_value('item_id',$sel_item),'class=" form-control select-full"'); ?>
                    <?= form_error('item_id');?>
                </div>
                <label class="col-md-2"><?= $this->lang->line('godown'); ?></label>
                <div class="col-md-3">
                    <?= form_dropdown('go_down_id',$go_downs,set_value('go_down_id',$sel_godown),'class="form-control"'); ?>
                    <?= form_error('go_down_id');?>
                </div>
                <div class="col-md-2">
                    <?=form_button(array('type'=>'submit','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('search')));?>
                </div>
            </div>
        </div>

	</div>
</div>
<?= form_close(); ?>
<?php if(!empty($stockOpenings)){ ?>

<div class="row block">
	<div class="col-md-12">
		<?=export_to_excel('excel/opening_stock_excel/opening_stock/postItem/'.$postItem.'/postGodown'.'/'.$postGodown); ?>
    </div>
	<div class="col-md-12">
		<h5 class="pull-right">Opening Date : <?= dateFormat($opening_date); ?></h5>
		<?php
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		?>
        <div class='table-responsive'>
            <table class="table table-bordered table-striped">
            <thead>
            <tr class="bg-success">
            <th>#</th>
            <th><?=$this->lang->line('item-code');?></th>	
            <th><?=$this->lang->line('item-name');?></th>
            <th><?=$this->lang->line('godown');?></th>
            <th><?=$this->lang->line('quantity');?></th>
            <th><?= $this->lang->line('unit'); ?></th>
            <th><?=$this->lang->line('rate');?></th>
            <th><?=$this->lang->line('amount');?></th>
            <th colspan="3"><?=$this->lang->line('actions');?></th>
            </tr>
            </thead>
			<?php 
			foreach($stockOpenings as $itemID=>$stock_opening){
				$rate = $stock_opening['rate'];
				$quantity = $stock_opening['opening_qnty'];
				$amount = (float)$rate*(float)$quantity;
				?>
                <tr>
                <td class="text-center"><?= $count++; ?></td>
                <td><?= $stock_opening['item_code']; ?></td>
                <td><?= $stock_opening['item_name']; ?> / <?= $stock_opening['model_no']; ?></td>
                <td><?= $stock_opening['godown_code']; ?> / <?= $stock_opening['godown_name']; ?></td>    
                <td class="text-right"><?= $quantity; ?></td>
                <td class="text-center"><span title="<?= $stock_opening['formal_name']; ?>"><?= $stock_opening['symbol']; ?></span></td>                
                <td class="text-right"><?= $rate; ?></td>
				<td class="text-right"><?= $amount; ?></td>
                <?php app_table_links($stock_opening['id'].'/'.$urlString,array(262,263));?>
                </tr>
                <?php
			}
			?>
			</table>
		</div>
	</div>
</div>
<?php } ?>
<div class="row">
    <div class="col-md-12">
        <div class="pagination"><?=$links;?></div>
    </div>
</div>