<div class="panel panel-primary">
	<div class="panel-heading">
		<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("view")." ".$this->lang->line("bill"); ?></h6>
	</div>
	<div class="panel-body">
		<?php $bill_prefix = $this->stock->get_voucher_prefix($purchase_array[0]['vtype_id']); ?>
		<div class="row">
    	    <div class="col-md-12">
        		<?php app_export_menus('id/'.$purchase_array[0]['primary_id'],452);?>
    		</div>
		</div>

		<div class="form-group">
			<div class="row">
		    	<div class="col-md-4">
		        	<label><?=$this->lang->line('voucher-types');?></label>
		        	<input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
		    	</div>
    			<div class="col-md-4">
        			<label><?=$this->lang->line('bill-no');?></label>
        			<div class="input-group">
            			<span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
            			<input type="text" class="form-control" disabled value="<?=$purchase_array[0]['bill_no'];?>">
        			</div>
    			</div>
    			<div class="col-md-4">
        			<label><?=$this->lang->line('bill-date');?></label>
        			<input type="text" class="form-control" disabled value="<?=dateFormat($purchase_array[0]['bill_date']);?>">
    			</div>
			</div>
		</div>

		<div class="form-group">
    		<div class="row">
        		<div class="col-md-4">
            		<label><?=$this->lang->line('invoice-no');?></label>
            		<input type="text" class="form-control" disabled value="<?=$purchase_array[0]['invoice_no'];?>">
        		</div>
        		<div class="col-md-4">
            		<label><?=$this->lang->line('invoice-date');?></label>
            		<input type="text" class="form-control" disabled value="<?=dateFormat($purchase_array[0]['invoice_date']);?>">
        		</div>
        		<div class="col-md-4">
            		<label><?=$this->lang->line('vendor');?></label>
            		<input type="text" class="form-control" disabled value="<?=$vendor_name;?>">
        		</div>
    		</div>
		</div>

		<div class="row">
			<div class="col-md-12">
    			<div class='table-responsive'>
    				<table class="table table-bordered table-striped">
    					<thead>
    					<tr class="bg-success">
    						<th>#</th>
    						<th><?= $this->lang->line('item-name');?></th>
    						<th><?= $this->lang->line('quantity');?></th>
    						<th><?= $this->lang->line('unit'); ?></th>
    						<th><?= $this->lang->line('rate'); ?></th>
    						<th><?= $this->lang->line('amount'); ?></th>
    						<th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
    						<th><?= $this->lang->line('net-value'); ?></th>
<?php
							if($tax_type ==0)
							{
								$a=12; $b=10;
?>    							
               					<th><?= $this->lang->line('cgst'); ?> (%)</th>
               					<th><?= $this->lang->line('sgst'); ?> (%)</th>
               					<th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
               					<th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>
<?php               						
               				}
               				else
               				{
               					$a=10; $b=8;
?>
								<th><?= $this->lang->line('igst'); ?> (%)</th>
               					<th><?= $this->lang->line('igst'); ?> <?= $this->lang->line('amt'); ?></th>
<?php               						
               				}
?>               						  
    						<th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
    					</tr>
    					</thead>
<?php					    					
    					$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;$totalcgstamt=0; 	 $total_qty=0;
    					$totalsgstamt=0;$totaligstamt=0;//$totalFreight=0;
    					$grandNetAmount=0;$total_cst_amount = 0;
					    $cess = $purchase_array[0]['cess'];
    					foreach($purchase_array as $key => $item)
    					{
					        $i++;
					        $itemID = $item['item_id'];
					        $item_details = $this->stock->get_item($itemID,array('item_code','item_name','model_no'));
					        $qty = $item['qty'];
					        $rate = $item['rate'];
					        $discount_per = $item['discount_per'];
					        $discount_amt = $item['discount_amt'];
					        $cst_percent = $item['cst'];
					        $vat = 0;$vatAmount = 0;$cst_amount = 0;$cgst=0;$sgst=0;$cgstAmt=0;$sgstAmt=0;$igst=0;$igstAmt=0;
					        $amount = $item['amount'];
					        $totalAmount += $amount;
					        $netValue = $amount-$discount_amt;
					        if($tax_type == 0)
					        {
             					$cgst=$item['cgst']; //$this->stock->get_item_cgst($itemID);
             					$sgst=$item['cgst']; //$this->stock->get_item_sgst($itemID);
             					$cgstAmt=$item['cgst_amt'];
             					$sgstAmt=$item['sgst_amt'];
             					$totalcgstamt += $cgstAmt;
				        		$totalsgstamt += $sgstAmt;
             					$vatAmount = $cgstAmt+$sgstAmt;
             				}
             				else
             				{
             					$igst=$item['igst'];
             					$igstAmt=$item['igst_amt']; 
             					$totaligstamt +=  $igstAmt;           						
             					$vatAmount = $igstAmt;
             				}
             					
             				$total_qty += $qty;
             				$totalVatAmt += $vatAmount;
             				$netAmount = $netValue+$vatAmount;       
        					$totalNetValue += $netValue;       
        					$totalNetAmount += $netAmount;
        					$totalDiscountAmt += $discount_amt;
?>
        					<tr>
						        <td><?= $i; ?></td>
						        <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?> /  <?= $item_details['model_no']; ?></td>
						        <td class="text-right"><?= $qty; ?></td>
						        <td><?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
						        <td class="text-right"><?= numberFormat($rate); ?></td>
						        <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
						        <td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
						        <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
<?php
    							if($tax_type == 0)
    							{
?>						        
    					            <td class="text-right"><?= $cgst; ?></td>
    					            <td class="text-right"><?= $sgst; ?></td>
    				                <td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
    				                <td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>
<?php
    							}
    							else
    							{
?>
								    <td class="text-right"><?= $igst; ?></td>
				                    <td class="text-right"><?= numberFormat(round_this($igstAmt)); ?></td>
<?php
							    }
?>				                    		
        					    <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        					</tr>
<?php
    					}
    					$grandNetAmount = round_this($totalNetAmount);
?>
    					<tr>
				    		<td class="text-right text-bold" colspan="2"><?= $this->lang->line('total'); ?></td>
				    		<td class="text-right text-bold"><?= $total_qty; ?></td>
    					    <td class="disabled"></td>
	              		    <td class="disabled"></td>
				    		<td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
				    		<td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
				    		<td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
<?php
    						if($tax_type == 0)
    						{
?>				    		
	          					<td class="disabled"></td>
	          					<td class="disabled"></td>        
	          					<td class="text-right text-bold"><?= numberFormat($totalcgstamt); ?></td>
	              				<td class="text-right text-bold"><?= numberFormat($totalsgstamt); ?></td>
<?php
    						}
    						else
    						{
?>          					
							    <td class="disabled"></td>        
	          					<td class="text-right text-bold"><?= numberFormat($totaligstamt); ?></td>
<?php
						    }
?>	          				
    						<td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    					</tr>
<?php 
    					$presumptive_tax_amt = 0;
    					if(!empty($presumptive_tax))
    					{
				    		$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
				    		$grandNetAmount += round_this($presumptive_tax_amt);
?>
    						<tr>
    							<td colspan="<?=(12-$colspan);?>" class="text-right">
    								<span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span>
    							</td>
    							<td class="text-right"><?=numberFormat($presumptive_tax_amt);?></td>
    						</tr>
<?php 
					    }
 
    					/*$cess_amt = ($totalAmount*$cess)/100;
    					$grandNetAmount += round_this($cess_amt);*/?>

    					<!--<tr>
    						<td colspan="<?=($a-$colspan);?>" class="text-right text-bold"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</td>
    						<td class="text-right"><?=numberFormat(round_this($cess_amt));?></td>
					    </tr>-->

    					<tr>
    						<td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?></td>
    						<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
    							<div class="row">
							        <div class="col-md-3"><input class="form-control" type="text" disabled value="<?=$payment_mode;?>"></div>
							        <div class="col-md-3"><?= $this->lang->line('credit-period');?></div>
							        <div class="col-md-3"><input class="form-control text-right" type="text" disabled value="<?=$purchase_array[0]['cr_period'];?>"></div>
							        <div class="col-md-3 pull-right"><?= $this->lang->line('freight');?></div>
    							</div>
    						</td>
    						<td class="text-right"><?=numberFormat(round_this($purchase_array[0]['bill_freight']));?></td>
    					</tr>
    					<tr>
						    <td colspan="<?=($a-$colspan);?>" class="text-right text-bold">
    							<div class="cd-ajax <?php if($cd_status){?>hide<?php }?>">
    								<div class="row">
        								<div class="col-md-3">
            								<?php $transaction_types = $this->dms->transaction_types();?>
            								<?= form_dropdown('ccd',$transaction_types,set_value('ccd',$ccd),'class="form-control" disabled'); ?>
            								<?=form_error('ccd');?>
        								</div>
        								<div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
								        <div class="col-md-3">
								            <?=form_input('cd_no',set_value('cd_no',$cd_no),"class='form-control' disabled");?>
								            <?=form_error('cd_no');?>
								        </div>
        								<div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
								        <div class="col-md-2">
								        	<?=form_input('cheque_date',set_value('cheque_date',dateFormat($pdc)),"class='datepicker form-control' disabled");?>
								        	<?=form_error('cheque_date');?>
								        </div>
    								</div>
    							</div>
						    </td>
    						<td></td>
					    </tr>
    					<tr>
    						<td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
    						<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
        						<div class="row">
							        <div class="col-md-9 pull-left"><textarea class="form-control" disabled><?=$purchase_array[0]['narration'];?></textarea></div>
							        <div class="col-md-3 pull-right"><?= $this->lang->line('other-expense');?></div>
							    </div>
    						</td>
    						<td class="text-right"><?=numberFormat(round_this($purchase_array[0]['other_expense']));?></td>
    					</tr>
<?php
					    $grandNetAmount += (($purchase_array[0]['bill_freight']+$purchase_array[0]['other_expense'])-$purchase_array[0]['bill_discount_amt']+$purchase_array[0]['courier_charge']+$purchase_array[0]['courier_gst']);

    					if(show_round_off())
    					{ 
?>
    					    <tr>
    							<td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
    								<div class="row">
        								<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
    								</div>
    							</td>
    							<td class="text-right text-bold">
    								<div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div>
    							</td>
    						</tr>
<?php 
					    }
?>
					    <tr>
    						<td class="text-right text-bold" colspan="2"><?=$this->lang->line('courier-charge');?></td>
    						<td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
    							<div class="row">
	        						<div class="col-md-3 pull-left">
	        							<?= form_input(array('name'=>'courier_charge','class'=>'form-control cour text-right decimal','disabled'=>'disabled'),set_value('courier_charge',$purchase_array[0]['courier_charge'])); ?><?=form_error('courier_charge');?>
	        						</div>
	        						<div class="col-md-3"><?= $this->lang->line('gst');?> <?=$this->lang->line('amount');?></div>
	        						<div class="col-md-3"><?= form_input(array('name'=>'cour_gst_amt','class'=>'form-control cour_gst text-right decimal','disabled'=>'disabled'),set_value('cour_gst_amt',$purchase_array[0]['courier_gst'])); ?><?=form_error('cour_gst_amt');?></div>
	        						<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('cour-amount');?></div>
	    						</div>
    						</td>
<?php
         					$tot_cour_amt = $purchase_array[0]['courier_charge']+$purchase_array[0]['courier_gst'];
?>
    						<td class="text-right">
    							<div class="col-md-12"><?= form_input(array('name'=>'tot_cour_amt','class'=>'form-control tot_cour_amt text-right decimal','disabled'=>'disabled'),set_value('tot_cour_amt',$tot_cour_amt)); ?><?=form_error('tot_cour_amt');?></div>
						    </td>
    					</tr>
    					<tr>
    						<td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
    						<td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
    							<div class="row">
        							<div class="col-md-3 pull-left"><input class="form-control text-right" type="text" disabled value="<?=$purchase_array[0]['bill_discount_per'];?>"></div>
						        	<div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
						        	<div class="col-md-3"><input class="form-control text-right" type="text" disabled value="<?=$purchase_array[0]['bill_discount_amt'];?>"></div>
						        	<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    							</div>
    						</td>
    						<td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
    					</tr>
    				</table>
    			</div>

    			<div class="row">
    				<div class="col-md-7 pull-left text-bold"><?=$this->lang->line('last-updated-by')." : ".get_username($purchase_array[0]['created_by']);?></div>
    				<div class="col-md-5 text-right text-bold"><?=$this->lang->line('last-updated-on')." : ".dateTimeFormat($purchase_array[0]['created_on']);?></div>
    			</div>
		    </div>
	    </div>
    </div>
</div>