<?= form_open();
if(!empty($purchase_orders)){
	$po_date = $vendor_id = $disabled = NULL;
	$po_details = $purchase_orders[0];
	$po_no = $po_details['po_no'];
	$po_date = $po_details['po_date'];
	$vendor_id = $po_details['vendor_id'];
	$l_date = '2017-07-01';
	$po_status = $po_details['po_status'];
	$po_discount_amt = $po_details['po_discount_amt'];
	$po_discount_per = $po_details['po_discount_per'];
	$po_remarks = $po_details['remarks'];
	$cess = $po_details['cess'];
	$uriArray = $this->uri->uri_to_assoc(3);
	$uriString = $this->uri->assoc_to_uri($uriArray);
	$bill_prefix = $this->stock->get_voucher_prefix(-2);
	?>
	
	<div class="panel panel-primary">
		<div class="panel-heading">
			<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('purchase-order'); ?></h6>
		</div>
		<div class="panel-body">

    	<div class="form-group">
    		<div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('po-no');?></label>
                        <div class="input-group">
                            <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                            <?= form_input(array('name'=>'po_no','class'=>'form-control number text-right'),set_value('po_no',$po_no),"$disabled"); ?>
                        </div>
                    <?= form_error('po_no');?>
                </div>
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('po-date');?></label>
                    <?= form_input(array('name'=>'po_date','class'=>'form-control datepicker'),set_value('po_date',cdateFormat($po_date)),"$disabled"); ?>
                    <?= form_error('po_date');?>
                </div>
    		</div>
    	</div>

        <div class="form-group">
            <div class="row">
                <label class="requiread col-md-2"><?= $this->lang->line('vendor'); ?></label>
                <div class="col-md-10">
                <?= form_dropdown('vendor_id',$vendors,set_value('vendor_id',$vendor_id),"class='form-control vendors' $disabled"); ?>
                <?= form_error('vendor_id');?>
                </div>
            </div>
        </div>
	<?php if($po_status == 0){ ?>

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id'),'class="form-control item_name"'); ?>
                    <?= form_error('item_id');?>
                </div>
                <?php $purchase_CST = $this->stock->get_constant(array('purchase_cst')); ?>
                <div class="col-md-<?= 6-($purchase_CST)*2; ?>">
                    <label class="required"><?=$this->lang->line('godown');?></label>
                    <?= form_dropdown('godown_id',$goDowns,set_value('godown_id'),'class="form-control godown"'); ?>
                    <?= form_error('godown_id');?>
                </div>
                <!---<div class="col-md-2">
                    <?php if(!empty($purchase_CST) && empty($presumtiveTax)){ ?>
                    <label class=""><?=$this->lang->line('cst');?> %</label>
                    <?= form_input(array('name'=>'cst','class'=>'form-control text-right cst decimal'),set_value('cst')); ?>
                    <?= form_error('cst');?>
                    <?php } ?>
                </div>--->
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty decimal qty-rate'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate decimal qty-rate'),set_value('rate')); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right decimal amount'),set_value('amount')); ?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> %</label>
                    <?= form_input(array('name'=>'discount_per','class'=>'form-control text-right decimal discount_per','id'=>'discount_per'),set_value('discount_per')); ?>
                    <?= form_error('discount_per');?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
                    <?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right decimal discount_amt'),set_value('discount_amt')); ?>
                    <?= form_error('discount_amt');?>
                </div>
            </div>
		</div>
        <div class="form-group">
            <div class="row">
                <div class="col-md-3"><?=$this->lang->line('rate');?> : <label type="text" class="rate-per text-right"></label> <label id="primary-unit"></label></div>
                <div class="col-md-9">
                    <?=form_button(array('type'=>'submit','name'=>'add_to_bill','class'=>'btn btn-primary pull-right btn-loading','content'=>$this->lang->line('add-to-bill')));?>
                </div>
            </div>
        </div>

	<?php } ?>

	<?php if(!empty($purchase_orders)){	?>
        <div class="form-group">
            <div class="row">
            	<div class="col-md-12">
    				<div class='table-responsive'>
                        <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                        <th>#</th>
                        <th><?=$this->lang->line('item-name');?></th>
                        <th><?=$this->lang->line('quantity');?></th>
                        <th><?= $this->lang->line('unit'); ?></th>
                        <th><?= $this->lang->line('rate'); ?></th>
                        <th><?= $this->lang->line('amount'); ?></th>
                        <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
                        <?php 
							if($po_date < $l_date)
							{						
							/*	if(!empty($cst_enabled) && empty($presumtiveTax))
								{ 
						?>
                            		<th><?= $this->lang->line('cst'); ?></th>
                        <?php 
								} 
						*/?> 
                        <?php 
								if(empty($presumtiveTax))
								{ /*
						?>
                            		<th><?= $this->lang->line('vat'); ?> (%)</th>
                            		<th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
                        <?php */
								} 
							}
							else
							{
						?>	
                        		<th><?= $this->lang->line('cgst'); ?> (%)</th>
                                <th><?= $this->lang->line('sgst'); ?> (%)</th>
                            	<th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
                            	<th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>	
						<?php		
							}
						?>
                        <th><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                        <?php if($po_status == 0){ ?><th colspan="2"><?= $this->lang->line('actions'); ?></th> <?php } ?>
                        </tr>
                        </thead>
						<?php
						$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;$grandNetAmount=0;$totalCst=0;	$cst=0;
						$count=$totalAmount=$totalVatAmount=$totalNetAmount=0;
						foreach($purchase_orders as $key=>$po_item){ $count++;

							$po_itemID = $po_item['dpi_id'];
							$vatAmount=$vat=$amount=$netAmount=0;
							$itemID = $po_item['item_id'];
							$qty = $po_item['qty'];
							$rate = $po_item['rate'];
							$cstPercent = 0;
							$discountPer = $po_item['discount_per'];
							$discountAmt = $po_item['discount_amt'];
							$vatAmount=0;$cstAmount=0;$vat=0;$cgst=0;$sgst=0;$cgstAmt=0;$sgstAmt=0;
							if($po_date< $l_date)
							{
								/*if($cstPercent == 0){
									$vat = $this->stock->get_item_vat($itemID);
								}else{
									$cst=1;
								}
								$cstAmount = ($cstPercent*$netValue)/100;
								if(empty($presumtiveTax)){
									$vatAmount = $po_item['vat_amt'];//($vat*$netValue)/100;
								}else{
									$cstAmount=0;
								}
								$netValue += $cstAmount;
								$totalCst += $cstAmount;*/
							}
							else
							{
								$cgst = $this->stock->get_item_cgst($itemID);
								$sgst = $this->stock->get_item_sgst($itemID);
								$cgstAmt = $po_item['cgst_amt'];
								$sgstAmt = $po_item['sgst_amt'];
								$vatAmount = $cgstAmt + $sgstAmt;
							}
							$amount = $po_item['amount'];
							$totalAmount += $amount;
							$totalDiscountAmt += $discountAmt;
							$netValue = $amount-$discountAmt;
							
							$totalNetValue += $netValue;
							
							$totalVatAmt += $vatAmount;
							$netAmount = $netValue+$vatAmount;
							$totalNetAmount += $netAmount;
							
							?>
                            <tr>
                            <td class="text-center"><?= $count; ?></td>
                            <td><?= $po_item['item_code']; ?> / <?= $po_item['item_name']; ?></td>
                            <td class="text-right"><?= $qty; ?></td>
                            <td class="text-right"><?= $po_item['symbol']; ?></td>
                            <td class="text-right"><?= numberFormat($rate); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
                            <?php 
								if($po_date < $l_date)
								{
								//	$a=7;
									/*if(!empty($cst_enabled) && empty($presumtiveTax))
									{ 
							?>
                                		<td class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
                            <?php 
									} 
							?>
                            <?php 
									if(empty($presumtiveTax))
									{ 
							?>
                                		<td class="text-right"><?= $vat; ?></td>
                                		<td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
                            <?php 
									}*/
								}
								else
								{
									$a=9;
							?>		
									<td class="text-right"><?= $cgst; ?></td>
                                    <td class="text-right"><?= $sgst; ?></td>
                                	<td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
                                	<td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>				
							<?php		
								}
							?>
                            		<td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                            <?php 
									if($po_status == 0){ ?>
                            	<td><a href="<?= base_url('purchase_orders/edit_item/'.$po_itemID.'/'.$uriString); ?>" title="<?= $this->lang->line('edit'); ?>"><i class="glyphicon glyphicon-pencil"></i></a></td>

                            	<td><a href="<?= base_url('purchase_orders/remove_item/'.$po_itemID.'/'.$uriString); ?>" title="<?= $this->lang->line('remove'); ?>"><i class="glyphicon glyphicon-remove delete red"></i></a></td>
                            <?php } ?>
                            </tr>
							<?php } ?>

                            <tr>
                            <td colspan="5" class="text-right text-bold"><?= $this->lang->line('total'); ?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
                            <?php 
								if($po_date < $l_date)
								{
								/*	if(!empty($cst_enabled) && empty($presumtiveTax))
									{ 
							?>
                                		<td class="text-right text-bold"><?= numberFormat(round_this($totalCst)); ?></td>
                            <?php 
									} 
							?>
                            <?php 
									if(empty($presumtiveTax))
									{ 
							?>
                            			<td class="disabled"></td>
                            			<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                            <?php 
									}*/
								}
								else
								{
							?>	
                            		<td class="disabled"></td>
                                    <td class="text-right text-bold" colspan="2">GST Amt.</td>
                            		<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>	
							<?php		
								}
							?>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                            <?php if($po_status == 0){ ?><td class="disabled" colspan="2"></td><?php } ?>
                            </tr>
							<?php
							$gnTotalVatAmount=$totalVatAmt;
							$pCol =2;
							if(!empty($presumtiveTax)){
								$pCol=0;
								$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
								$gnTotalVatAmount = round_this($pmTaxAmt);
								$totalNetAmount += round_this($pmTaxAmt);
								?>
                                <tr>
                                <td class="text-right text-bold" colspan="<?= $a+$pCol+$cst; ?>"><?= $this->lang->line('presum-tax') ?> @ <?= $presumtiveTax[0]; ?> %</td>
                                <td class="text-right text-bold"><?= numberFormat(round_this($pmTaxAmt)); ?></td>
                                <?php if($po_status == 0){ ?><td class="disabled" colspan="2"></td><?php } ?>
                                </tr>
							<?php }?>
							<?php
                            $cessAmount=0;
                            $cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
                            $totalNetAmount += round_this($cessAmount);
                            ?>
                            <tr>
                            <td class="text-right text-bold" colspan="<?= $a+$pCol+$cst; ?>"><?= $this->lang->line('cess');?> @ <?= $cess; ?> %</td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($cessAmount)); ?></td>
                            <?php if($po_status == 0){ ?><td class="disabled" colspan="2"></td><?php } ?>
                            </tr>
                            <input type="hidden" id="gnTotalAmt" value="<?= round_this($totalNetAmount); ?>">
                            <?php $totalNetAmount -= $po_discount_amt; ?>
                            <?php if(show_round_off()){ ?>
                            <tr>
                            <td class="text-right text-bold" colspan="<?= $a+$pCol+$cst; ?>"><?= $this->lang->line('round-off');?></td>
                            <td class="text-right text-bold">
                            	<div class="in-line" id="roundOff"><?= numberFormat(round_off($totalNetAmount)); ?></div>
                            </td>
                            <?php if($po_status == 0){ ?><td class="disabled" colspan="2"></td><?php } ?>
                            </tr>
                            <?php } ?>
                            <tr>
                            <td class="" colspan="<?= $a+$pCol+$cst; ?>">
                                <div class="row">
                                    <div class="col-md-4">
                                    	<label><?=$this->lang->line('discount');?> %</label>
                                    	<?= form_input(array('name'=>'bill_discount_per','class'=>'form-control bill_discount_per text-right decimal'),set_value('bill_discount_per',$po_discount_per)); ?>
                                    </div>
                                    <div class="col-md-4">
                                    	<label><?=$this->lang->line('discount');?> <?=$this->lang->line('amount');?></label>
                                    	<?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amt text-right decimal'),set_value('bill_discount_amt',$po_discount_amt)); ?>
                                    </div>
                                    <div class="col-md-4">
                                    	<span class="text-bold pull-right"><?=$this->lang->line('net-amount');?></span>
                                    </div>
                                </div>
                            </td>
                            <td class="text-right text-bold">
                            	<div id="gn_net_amount"><?= numberFormat(get_rounded($totalNetAmount)); ?></div>
                            </td>
                            <?php if($po_status == 0){ ?><td class="disabled" colspan="2"></td><?php } ?>
                            </tr>
							</table>
						</div>
    				</div>
    			</div>
			</div>

            <div class="form-group">
                <div class="row">
                    <label class="requiread col-md-2"><?= $this->lang->line('remarks'); ?></label>
                    <div class="col-md-10">
						<?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>3),set_value('remarks',$po_remarks)); ?>
                        <?= form_error('remarks');?>
                    </div>
                </div>
            </div>

            <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <div class="text-right">
                        <?= form_button(array('type'=>'submit','name'=>'save_bill','class'=>'btn btn-primary pull-right confirm btn-loading','content'=>$this->lang->line('save')));?>
                    </div>
                </div>
            </div>
            </div>
			<?php
	}
	?>
    	</div>
	</div>
    <?php
}
?>
<?= form_close(); ?>