<?= form_open();
if(!empty($purchase_orders)){
	$purchase_order = $purchase_orders[0];
	?>
	<div class="panel panel-primary">
        <div class="panel-heading">
        	<h6 class="panel-title">
            	<i class="icon-database"></i><?= $this->lang->line('edit-purchase-order'); ?>
			</h6>
        </div>
		<div class="panel-body">

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id',$purchase_order['item_id']),'class="form-control item_name" disabled'); ?>
                    <?= form_error('item_id');?>
                </div>
                <?php $purchase_CST = $this->stock->get_constant(array('purchase_cst')); ?>
                <div class="col-md-<?=(empty($presumtiveTax) && $purchase_CST)?4:6;?>">
                    <label class="required"><?=$this->lang->line('godown');?></label>
                    <?= form_dropdown('godown_id',$goDowns,set_value('godown_id',$purchase_order['godown_id']),'class="form-control godown"'); ?>
                    <?= form_error('godown_id');?>
                </div>
             
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty decimal qty-rate'),set_value('qty',round_this($purchase_order['qty']))); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id',$purchase_order['unit_id']),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate decimal qty-rate'),set_value('rate',round_this($purchase_order['rate']))); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                   <?= form_input(array('name'=>'amount','class'=>'form-control text-right decimal amount'),set_value('amount',round_this($purchase_order['amount']))); ?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> %</label>
                    <?= form_input(array('name'=>'discount_per','class'=>'form-control text-right decimal discount_per','id'=>'discount_per'),set_value('discount_per',round_this($purchase_order['discount_per']))); ?>
                    <?= form_error('discount_per');?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
                    <?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right decimal discount_amt'),set_value('discount_amt',round_this($purchase_order['discount_amt']))); ?>
                    <?= form_error('discount_amt');?>
                </div>
            </div>
		</div>
        
<?php
 	$l_date = '2017-07-01';
	$po_date = $purchase_order['po_date'];
 	if($po_date < $l_date)
	{
?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-2 float-left">
                    <?=$this->lang->line('rate');?> : <label type="text" class="rate-per text-right"><?=round_this($rate);?></label><label id="primary-unit"><?=" / ".$unit;?></label>
                </div>

                <div class="col-md-2 pull-right">
                    <?php $disabled_vat = "";if($purchase_order['cst'] != 0){$disabled_vat = "readonly";}?>
                    <label><?=$this->lang->line('vat');?> <?=$this->lang->line('amt');?></label>
                    <?=form_input('vat_amt',set_value('vat_amt',round_this($purchase_order['vat_amt'])),"class='form-control text-right vat_amt decimal' $disabled_vat");?>
                    <?= form_error('vat_amt');?>
                </div>
                <?php $vat_percent = $this->stock->get_item_vat($purchase_order['item_id']);?>
                <div class="col-md-2 pull-right">
                    <label><?=$this->lang->line('vat');?> %</label>
                    <?= form_input(array('class'=>'form-control text-right vat-percent','readonly' => true,'value' => round_this($vat_percent))); ?>
                </div>
            </div>
        </div>
 <?php
	}
	else
	{
?>
		 <div class="form-group">
            <div class="row">
                <div class="col-md-2 float-left">
                    <?=$this->lang->line('rate');?> : <label type="text" class="rate-per text-right"><?=round_this($rate);?></label><label id="primary-unit"><?=" / ".$unit;?></label>
                </div>

                <div class="col-md-2 pull-right">
                    <?php $disabled_vat = "readonly";?>
                    <label><?=$this->lang->line('cgst');?> <?=$this->lang->line('amt');?></label>
                    <?=form_input('cgst_amt',set_value('cgst_amt',round_this($purchase_order['cgst_amt'])),"class='form-control text-right vat_amt decimal' $disabled_vat");?>
                    <?= form_error('cgst_amt');?>
                </div>
                <?php $vat_percent = $this->stock->get_item_cgst($purchase_order['item_id']);?>
                <div class="col-md-2 pull-right">
                    <label><?=$this->lang->line('cgst');?> %</label>
                    <?= form_input(array('class'=>'form-control text-right vat-percent','readonly' => true,'value' => round_this($vat_percent))); ?>
                </div>
            </div>
        </div>
         <div class="form-group">
            <div class="row">
                <div class="col-md-2 pull-right">
                    <?php $disabled_vat = "readonly";?>
                    <label><?=$this->lang->line('sgst');?> <?=$this->lang->line('amt');?></label>
                    <?=form_input('sgst_amt',set_value('sgst_amt',round_this($purchase_order['sgst_amt'])),"class='form-control text-right vat_amt decimal' $disabled_vat");?>
                    <?= form_error('sgst_amt');?>
                </div>
                <?php $vat_percent1 = $this->stock->get_item_sgst($purchase_order['item_id']);?>
                <div class="col-md-2 pull-right">
                    <label><?=$this->lang->line('sgst');?> %</label>
                    <?= form_input(array('class'=>'form-control text-right vat-percent','readonly' => true,'value' => round_this($vat_percent1))); ?>
                </div>
            </div>
        </div>
<?php
	}
?>

        <div class="form-group">
            <div class="text-right">
                <?=form_button(array('type' => 'submit','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('update')));?>
            </div>
        </div>
	</div>
</div>
<?php }
echo form_close(); ?>