<style>
*{	font-size:10px;}
.pdf-head{	font-weight:bold; margin-left:auto; margin-right:auto; text-align:center; font-size:12px;}
.data-table{	font-size:10px;}
.text-right{	text-align:right;}
.text-center{	text-align:center;}
.text-bold{	font-weight:bold;}
.vendor{ text-indent:20px;}
.data-list{	padding:2px;}
.data-list th{	font-size:10px; text-align:center; background-color:#E4E4E4; font-weight:700;}
.data-list td{	font-size:8px;}
.disabled{background-color:#E2E2E1;}
.italic{ font-style:italic;}
.has-border{ border:1px solid #999;}
.has-border-left{border-left:1px solid #999;}
.data-list tr td{  border-right:1px solid #999;}
.data-list tr th{border:1px solid #999;}
.declaration{font-size:8px;}
.terms-conditions{font-size:8px;}
</style>
<?php
if(!empty($purchase_orders)){
	$l_date = '2017-07-01';
	$po_date = $vendor_id = NULL;
	$po_details = $purchase_orders[0];
	$po_no = $po_details['po_no'];
	$po_date = $po_details['po_date'];
	$vendor_id = $po_details['vendor_id'];
	$vendor_name = $po_details['vendor_name'];
	$vendor_phone = (!empty($po_details['vendor_phone']))?'Ph : '.$po_details['vendor_phone'].',':'';
	$vendor_address = $po_details['vendor_address'];
	$vendor_pin = $po_details['vendor_pin'];
	$vendor_mail = (!empty($po_details['vendor_mail']))?' Email : '.$po_details['vendor_mail']:'';
	$vendor_tin = (!empty($po_details['vendor_tin_no']))?' TIN : '.$po_details['vendor_tin_no']:'';
	$vendor_gstn = (!empty($po_details['vendor_gstn']))?' TIN : '.$po_details['vendor_gstn']:'';
	$po_status = $po_details['po_status'];
	$po_discount_amt = $po_details['po_discount_amt'];
	$po_discount_per = $po_details['po_discount_per'];
	$po_remarks = $po_details['remarks'];
	$cess = $po_details['cess'];
	$presumtiveTax = $this->stock->get_tax_type();
	$itmSpc=$qtySpc=$untSpc=$rtSpc=$amtSpc=0;
	$bill_prefix = $this->stock->get_voucher_prefix(-2);

	if(!empty($presumtiveTax)){
		$itmSpc=30;
		$qtySpc=$untSpc=$rtSpc=$amtSpc=20;
	}
	if(!empty($cst_enabled)){
		$itmSpc = $itmSpc-20;
		$qtySpc = $qtySpc-20;
	}
	?>
	<div class="pdf-head">PURCHASE ORDER</div>
        <table  class="data-table" border="0">
            <tr>
            <td class="text-right">
                <span class="text-bold">Po. No. : </span><?= $bill_prefix.' '.$po_no; ?><br/>
                <span class="text-bold">Po. Date : </span><?= dateFormat($po_date); ?>
            </td>
            </tr>
        </table>
        <table  class="data-table" border="0">
            <tr><td>To ,</td></tr>
            <tr><td class="vendor text-bold"><?= $vendor_name; ?></td></tr>
            <tr><td class="vendor"><?= $vendor_address; ?> <?= $vendor_pin; ?></td></tr>
            <tr><td class="vendor"><?= $vendor_phone; ?> <?= $vendor_mail; ?></td></tr>
            <tr><td class="vendor"><?= $vendor_tin; ?></td></tr>
            <tr><td class="vendor"><?= $vendor_gstn; ?></td></tr>
        </table>
		<div></div>
		<?php if(!empty($purchase_orders)){	?>

        <table class="data-list">
        <thead>
        <tr>
        <th width="25">#</th>
        <th width="<?= 110+$itmSpc; ?>">Item</th>
        <th width="<?= 70+$qtySpc; ?>">Qty.</th>
        <th width="<?= 60+$rtSpc; ?>">Rate</th>
        <th width="<?= 70+$amtSpc; ?>">Amount</th>
        <th width="50">Dis.Amt</th>
		<?php 
			if($po_date < $l_date)
			{
				if(!empty($cst_enabled) && empty($presumtiveTax))
				{ 
		?>
        		    <th width="40px"><?= $this->lang->line('cst'); ?></th>
        <?php 
				} 
		?>
        <?php 	
				if(empty($presumtiveTax))
				{ 
		?>
        			<th width="40">VAT <br><span style="font-size:8px;">(%)</span></th>
        			<th width="60">VAT Amt.</th>
        <?php 
				}
			}
			else
			{
		?>		
				<th width="40">GST <br><span style="font-size:8px;">(%)</span></th>
        			<th width="60">GST Amt.</th>	
		<?php		
			}
		?>
        <th width="<?= 80+$amtSpc; ?>">Total</th>
        </tr>
        </thead>
		<?php
		$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;
		$totalVatAmt=0;$totalNetAmount=0;$grandNetAmount=0;$totalCst=0;	$cst=0;
		$count=$totalAmount=$totalVatAmount=$totalNetAmount=0;
		foreach($purchase_orders as $key=>$po_item){ $count++;

			$tempItemID = $po_item['dpi_id'];
			$vatAmount=$vat=$amount=$netAmount=0;
			$itemID = $po_item['item_id'];
			$qty = $po_item['qty'];
			$rate = $po_item['rate'];
			$cstPercent = $po_item['cst'];
			$discountPer = $po_item['discount_per'];
			$discountAmt = $po_item['discount_amt'];
			$vatAmount=0;$cstAmount=0;$vat=0;
			if($po_date < $l_date)
			{
				if($cstPercent == 0)
				{
					$vat = $this->stock->get_item_vat($itemID);
				}
				else
				{
					$cst=1;
				}
				$cstAmount = ($cstPercent*$netValue)/100;
				if(empty($presumtiveTax))
				{
					$vatAmount = $po_item['vat_amt'];//($vat*$netValue)/100;
				}
				else
				{
					$cstAmount=0;
				}
				$totalCst += $cstAmount;
				$netValue += $cstAmount;
			}
			else
			{
				$cgst = $this->stock->get_item_cgst($itemID);
				$sgst = $this->stock->get_item_sgst($itemID);
				$vat = $cgst + $sgst;
				$vatAmount = $po_item['cgst_amt'] + $po_item['sgst_amt'];
			}
			$amount = $po_item['amount'];
			$totalAmount += $amount;
			$totalDiscountAmt += $discountAmt;
			$netValue = $amount-$discountAmt;		
			$totalNetValue += $netValue;
			$totalVatAmt += $vatAmount;
			$netAmount = $netValue+$vatAmount;
			$totalNetAmount += $netAmount;
			
			?>
            <tr>
            <td width="25" class="text-center has-border-left"><?= $count; ?></td>
            <td width="<?= 110+$itmSpc; ?>"><?= $po_item['item_code']; ?> / <?= $po_item['item_name']; ?></td>
            <td width="<?= 70+$qtySpc; ?>" class="text-right"><?= $qty; ?> <?= $po_item['symbol']; ?></td>
            <td width="<?= 60+$rtSpc; ?>" class="text-right"><?= numberFormat($rate); ?></td>
            <td width="<?= 70+$amtSpc; ?>" class="text-right"><?= numberFormat(round_this($amount)); ?></td>
            <td width="50" class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
            <?php 
				if($po_date < $l_date)
				{
					if(!empty($cst_enabled) && empty($presumtiveTax))
					{ 
			?>
                		<td width="40px" class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
            <?php 
					} 
			?>
            <?php 
					if(empty($presumtiveTax))
					{ 
			?>
            			<td width="40" class="text-right"><?= $vat; ?></td>
            			<td width="60" class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
            <?php 
					}
				}
				else
				{
			?>	
            		<td width="40" class="text-right"><?= $vat; ?></td>
            		<td width="60" class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>	
			<?php		
				}
			?>
            <td width="<?= 80+$amtSpc; ?>" class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
            </tr>
	<?php } ?>
        <tr>
        <td colspan="4" class="text-right text-bold has-border disabled">Total</td>
        <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalAmount)); ?></td>
        <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
        <?php if(!empty($cst_enabled) && empty($presumtiveTax)){ ?>
            <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalCst)); ?></td>
        <?php } ?>
        <?php if(empty($presumtiveTax)){ ?>
        <td class="disabled has-border"></td>
        <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalVatAmt)); ?></td>
        <?php } ?>
        <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalNetAmount)); ?></td>
        </tr>
		<?php
		$gnTotalVatAmount=$totalVatAmt;
		$pCol =2;
		if(!empty($presumtiveTax)){
			$pCol=0;
			$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
			$gnTotalVatAmount = round_this($pmTaxAmt);
			$totalNetAmount += round_this($pmTaxAmt);
			?>
            <tr>
            <td class="text-right" colspan="<?= 6+$pCol+$cst; ?>">Presumptive Tax @ <?= $presumtiveTax[0]; ?> %</td>
            <td class="text-right text-bold has-border" colspan="1"><?= numberFormat(round_this($pmTaxAmt)); ?></td>
            </tr>
            <?php
		}
		$cessAmount=0;
		$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
		$totalNetAmount += round_this($cessAmount);
    	?>
        <tr>
        <td class="text-right" colspan="<?= 6+$pCol+$cst; ?>">Cess @ <?= $cess; ?> %</td>
        <td class="text-right text-bold has-border" colspan="1"><?= numberFormat(round_this($cessAmount)); ?></td>
        </tr>
        <tr>
        <td class="text-right" colspan="<?= 6+$pCol+$cst; ?>">Discount</td>
        <td class="text-right text-bold has-border" colspan="1"><?= numberFormat(round_this($po_discount_amt)); ?></td>
        </tr>
		<?php $totalNetAmount -= $po_discount_amt; ?>
        <?php if(show_round_off()){ ?>
        <tr>
        <td class="text-right" colspan="<?= 6+$pCol+$cst; ?>"><?= $this->lang->line('round-off');?></td>
        <td class="text-right text-bold" colspan="1"><?= numberFormat(round_off($totalNetAmount)); ?></td>
        </tr>
        <?php } ?>
        <tr>
        <td class="text-right text-bold" colspan="<?= 6+$pCol+$cst; ?>"><label>Net Amount. (<?= get_currency();?>)</label></td>
        <td class="text-right text-bold has-border" colspan="1">
        <span class=" g-total"><?= numberFormat(get_rounded($totalNetAmount)); ?></span>
        </td>
        </tr>
		</table>
		<div class="text-left italic"><?= $this->to_words->num_to_words(get_rounded($totalNetAmount)); ?></div>
		<div><span class="text-bold">Remarks : </span><?= $po_remarks; ?></div>
<div class="text-right text-bold">Authorised Signatory.</div>
<?php } }?>