<?= form_open(); ?>
<?php $bill_prefix = $this->stock->get_voucher_prefix($purchase_array[0]['vtype_id']); ?>
<div class="panel panel-primary">
    <div class="panel-heading">
    	<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("edit")." ".$this->lang->line("$voucher_name"); ?></h6>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('voucher-types');?></label>
                    <input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
                    <div class="input-group">
                        <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                        <?=form_input('bill_no',set_value('bill_no',$purchase_array[0]['bill_no']),"class='form-control text-right number' id='sbill-ajax'");?>
                    </div>
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
                    <?=form_input('bill_date',set_value('bill_date',cdateFormat($purchase_array[0]['bill_date'])),"class='datepicker form-control bill-date' id='sdate-ajax'");?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
            	<div class="col-md-3">
                    <label class="required"><?=$this->lang->line('invoice-no');?></label>
                    <?=form_input('invoice_no',set_value('invoice_no',$purchase_array[0]['invoice_no']),"class='form-control'");?>
                    <?=form_error('invoice_no');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('invoice-date');?></label>
                    <?=form_input('invoice_date',set_value('invoice_date',cdateFormat($purchase_array[0]['invoice_date'])),"class='datepicker form-control'");?>
                    <?= form_error('invoice_date');?>
                </div>
            	<div class="col-md-6">
                    <label class="required"><?=$this->lang->line('vendor');?></label>
                    <?=form_dropdown("vendor_id",$vendors,set_value("vendor_id",$purchase_array[0]['vendor_id']),"class='form-control customer_type'");?>
                    <?=form_error('vendor_id');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id'),'class="form-control item_name"'); ?>
                    <?= form_error('item_id');?>
                </div>
                <div class="col-md-<?=(empty($presumptive_tax) && $purchase_cst)?4:6;?>">
                    <label class="required"><?=$this->lang->line('godown');?></label>
                    <?= form_dropdown('godown_id',$goDowns,set_value('godown_id'),'class="form-control godown"'); ?>
                    <?= form_error('godown_id');?>
                </div>
                <?php if(empty($presumptive_tax) && $purchase_cst){?>
                <div class="col-md-2">
                    <label><?=$this->lang->line('cst');?> %</label>
                    <?= form_input(array('name'=>'cst','class'=>'form-control text-right decimal cst'),set_value('cst')); ?>
                    <?= form_error('cst');?>
                </div>
                <?php }?>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty qty-rate decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate qty-rate decimal'),set_value('rate')); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right amount'),set_value('amount')); ?>
                    <?= form_error('amount');?>
                </div>
                <div class="col-md-2">
                    <label><?=$this->lang->line('discount');?> %</label>
                    <?= form_input(array('name'=>'discount_per','class'=>'form-control text-right discount_per decimal','id'=>'discount_per'),set_value('discount_per')); ?>
                    <?= form_error('discount_per');?>
                </div>
                <div class="col-md-2">
                    <label><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
                    <?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right discount_amt decimal'),set_value('discount_amt')); ?>
                    <?= form_error('discount_amt');?>
                </div>
            </div>
        </div>

        <div class="float-left"><?=$this->lang->line('stock-bal')." : ";?></div><div class="float-left text-bold marg-left-10" id="stock-balance"><?=$stock_count." ".$primary_unit;?></div>

        <div class="form-group">
            <div class="text-right">
                <?=form_submit(array('name' => 'btn_add','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('add-to-bill')));?>
            </div>
        </div>

	</div>
</div>

<div class="row">
<div class="col-md-12">

    <div class='table-responsive'>
    <table class="table table-bordered table-striped">
    <thead>
    <tr class="bg-success">
    <th>#</th>
    <th><?= $this->lang->line('item-name');?></th>
    <th><?= $this->lang->line('quantity');?></th>
    <th><?= $this->lang->line('unit'); ?></th>
    <th><?= $this->lang->line('rate'); ?></th>
    <th><?= $this->lang->line('amount'); ?></th>
    <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
    <th><?= $this->lang->line('net-value'); ?></th>
    <?php $colspan = 2;if(empty($presumptive_tax) && $purchase_cst){$colspan-=1;?>
    	<th><?= $this->lang->line('cst').". ".$this->lang->line('amt'); ?></th>
	<?php }?>
    <?php if(empty($presumptive_tax)){$colspan-=2;?>
        <th><?= $this->lang->line('vat'); ?> (%)</th>
        <th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
    <?php }?>
    <th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
    <th colspan='2'><?=$this->lang->line('actions');?></th>
    </tr>
    </thead>
    <?php
    $i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;//$totalFreight=0;
    $grandNetAmount=0;$total_cst_amount = 0;
    $cess = $purchase_array[0]['cess'];
    foreach($purchase_array as $key => $item){
        $i++;
        $itemID = $item['item_id'];
        $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
        $qty = $item['qty'];
        $rate = $item['rate'];
        $discount_per = $item['discount_per'];
        $discount_amt = $item['discount_amt'];
        $cst_percent = $item['cst'];
        $vat = 0;$vatAmount = 0;$cst_amount = 0;
        $amount = $item['amount'];
        $totalAmount += $amount;
        $netValue = $amount-$discount_amt;
        if(empty($presumptive_tax)){
            if($cst_percent == 0){
                $vat = $this->stock->get_item_vat($itemID);
                $vatAmount = $item['vat_amt'];
                $totalVatAmt += $vatAmount;
            }else{
                $cst_amount = ($netValue*$cst_percent)/100;
            }
        }
        $total_cst_amount += $cst_amount;
        $totalNetValue += $netValue;
        $netAmount = $netValue+$vatAmount+$cst_amount;
        $totalNetAmount += $netAmount;
        $totalDiscountAmt += $discount_amt;
        ?>
        <tr>
        <td class="text-center"><?= $i; ?></td>
        <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
        <td class="text-right"><?= $qty; ?></td>
        <td><?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
        <td class="text-right"><?= numberFormat($rate); ?></td>
        <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
        <td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
        <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
        <?php if(empty($presumptive_tax) && $purchase_cst){?>
        	<td class="text-right"><?= numberFormat(round_this($cst_amount)); ?></td>
		<?php }?>
        <?php if(empty($presumptive_tax)){?>
            <td class="text-right"><?= $vat; ?></td>
            <td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
        <?php }?>
        <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        <?php app_table_links('idu/'.$item['id'].$redirect,array(408,409));?>
        </tr>
        <?php
    }
    $grandNetAmount = round_this($totalNetAmount);
    ?>
    <tr>
    <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
    <?php if(empty($presumptive_tax) && $purchase_cst){?>
    	<td class="text-right text-bold"><?= numberFormat(round_this($total_cst_amount)); ?></td>
	<?php }?>
    <?php if(empty($presumptive_tax)){?>
        <td class="disabled"></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php }?>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    <td colspan="2" class="disabled"></td>
    </tr>

    <?php $presumptive_tax_amt = 0;if(!empty($presumptive_tax)){
    $presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
    $grandNetAmount += round_this($presumptive_tax_amt);
    ?>
    <tr>
    <td colspan="<?=(10-$colspan);?>" class="text-right">
    <span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
    <td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
    <td colspan="2" class="disabled"></td>
    </tr>
    <?php }?>
    <?php $cess_amt = (($totalVatAmt+$total_cst_amount+$presumptive_tax_amt)*$cess)/100;
    $grandNetAmount += round_this($cess_amt);?>

    <tr>
    <td colspan="<?=(10-$colspan);?>" class="text-right text-bold"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</td>
    <td class="text-right"><?=numberFormat(round_this($cess_amt));?></td>
	<td colspan="2" class="disabled"></td>
	</tr>

    <tr>
	<td colspan="<?=(10-$colspan);?>" class="text-right text-bold">
    <div class="row">
    	<div class="col-md-12 pull-right"><?= $this->lang->line('freight');?></div>
    </div>
	</td>
	<td><?= form_input(array('name'=>'freight','class'=>'form-control decimal text-right width-150 pull-right freight-amt'),set_value('freight',$purchase_array[0]['bill_freight'])); ?><?=form_error('freight');?></td>
	<td colspan="2" class="disabled"></td>
	</tr>

    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
    <td colspan="<?=(8-$colspan);?>" class="text-right">
        <div class="row">
        <div class="col-md-9 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks',$purchase_array[0]['narration'])); ?><?=form_error('remarks');?></div>
        <div class="col-md-3 pull-right  text-bold"><?= $this->lang->line('other-expense');?></div>
        </div>
    </td>
    <td class="text-right"><?= form_input(array('name'=>'other_expense','class'=>'form-control text-right width-150 pull-right other-expense decimal'),set_value('other_expense',$purchase_array[0]['other_expense'])); ?><?=form_error('other_expense');?></td>
    <td colspan="2" class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
    </tr>
    <?php
    $grandNetAmount += (($purchase_array[0]['bill_freight']+$purchase_array[0]['other_expense'])-$purchase_array[0]['bill_discount_amt']);
    ?>

    <?php if(show_round_off()){ ?>
    <tr>
    <td colspan="<?=(10-$colspan);?>" class="text-right text-bold">
        <div class="row">
	       <div class="col-md-3 pull-right"><?= $this->lang->line('round-off');?></div>
        </div>
    </td>
    <td class="text-right"><div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div></td>
    <td colspan="2" class="disabled"></td>
    </tr>
    <?php } ?>
    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
    <td class="text-right text-bold" colspan="<?=(8-$colspan);?>">
    <div class="row">
        <div class="col-md-3 pull-left"><?= form_input(array('name'=>'bill_discount_per','class'=>'form-control text-right bill_discount_percent decimal'),set_value('bill_discount_per',$purchase_array[0]['bill_discount_per'])); ?><?=form_error('bill_discount_per');?></div>
        <div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
        <div class="col-md-3"><?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amount decimal text-right'),set_value('bill_discount_amt',$purchase_array[0]['bill_discount_amt'])); ?><?=form_error('bill_discount_amt');?></div>
        <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
    <td colspan="2" class="disabled"></td>
    </tr>
    </table>
    </div>

    <div class="row">
	<div class="col-md-12">
		<div class="form-group">
			<div class="text-right">
				<?= form_submit(array('name'=>'btn_update','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('update')."  ".$this->lang->line('bill')));?>
			</div>
		</div>
	</div>
	</div>

</div>
</div>

<?= form_close(); ?>