<?php if(!empty($purchase_requests)){ 
$purchase_request = $purchase_requests[0];
$requestNumber = $purchase_request['request_no'];
$requestedOn = $purchase_request['request_date'];
$deliveryOn = $purchase_request['delivery_date'];
$remarks = $purchase_request['remarks'];
$reqStatus = $purchase_request['req_status'];
$branchDetails = $this->dms->get_user_branch($purchase_request['requested_by']);
$requested_user = $purchase_request['requested_user'];
$designation = $purchase_request['designation_name'];
$updateRemarks = $purchase_request['update_remarks'];
$updatedOn = $purchase_request['updated_on'];
$updateUser = $purchase_request['updated_user'];
$customerID = $purchase_request['customer_id'];

?>
<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('purchase-request'); ?> </h6>
</div>
<div class="panel-body">

<div class="form-group">
    <div class="row">
    	<div class="col-md-6">
        	<label><?=$this->lang->line('request-no');?> : <?= $requestNumber; ?></label>
        </div>
    	<div class="col-md-6 text-right">
        	<label><?=$this->lang->line('requested-on');?> : <?= dateFormat($requestedOn); ?></label>
        </div>
    </div>
</div>
   
<div class="form-group">
    <div class="row">
        <label class="col-md-2"><?=$this->lang->line('requested-by');?> : </label>
        <div class="col-md-9"><label><?= $requested_user; ?> [<?= $designation; ?>]</label></div>
    </div>
    <div class="row">
    	<label class="col-md-2"></label>
        <div class="col-md-9">
        <div><label><?= $branchDetails['name']; ?> <?= $branchDetails['address']; ?></label></div>
        <div><label><i class="icon-phone2"></i> : <?= $branchDetails['land_line']; ?> <i class="icon-mobile"></i> : <?= $branchDetails['mobile']; ?></label></div>
        </div>
    </div>       
</div>   
  
<?php
if(!empty($customerID)){
	$cust_details = $this->stock->get_customer(2,$customerID,1);
	?>
<div class="form-group">
    <div class="row">
        <label class="col-md-2"><?=$this->lang->line('customer');?> </label>
        <div class="col-md-9"><label>: <?= $cust_details['name']; ?></label></div>
    </div>
    <div class="row">
    	<label class="col-md-2"></label>
        <div class="col-md-9">
        <div><label><i class="icon-home2"></i> <?= $cust_details['address']; ?></label></div>
        <div><label><i class="icon-phone2"></i> <?= $cust_details['phone_no']; ?> , <i class="icon-mobile"></i><?= $cust_details['mobile_no']; ?> , <i class="icon-mail4"></i> <?= $cust_details['email_id']; ?></label></div>
        </div>
    </div>       
</div>  
<?php    
}
?>

<?php if(!empty($purchase_requests)){ ?>
<div class="row">
    <div class="col-md-12">
        <div class='table-responsive'>
        <table class="table table-bordered table-striped">
        <thead>
        <tr class="bg-success">
        <th>#</th>
        <th><?= $this->lang->line('item-name'); ?></th>
        <th><?= $this->lang->line('quantity'); ?></th>
        <th><?= $this->lang->line('unit'); ?></th>
        </tr>       
        </thead>
        <?php $i=0;
		foreach($purchase_requests as $key=>$temp){$i++;
			?>
            <tr>
            <td><?= $i; ?></td>
            <td><?= $temp['item_code']; ?> / <?= $temp['item_name']; ?></td>
            <td class="text-right"><?= $temp['qty']; ?></td>
            <td class="text-right"><?= $temp['symbol']; ?></td>
            </tr>
            <?php
		}?>
        </table>
        </div>
    
    </div>
</div>

<div class="form-group">
    <div class="row">
    	<div class="col-md-6">
        	<label><?=$this->lang->line('delivery-on');?> : <?= dateFormat($deliveryOn); ?></label>
        </div>
    	<div class="col-md-6">
        	<label><?=$this->lang->line('status');?> : <?= $statusArray[$reqStatus]; ?></label>
        </div>
    </div>
</div>

<div class="form-group">
    <div class="row">
    	<div class="col-md-12">
        	<label><?=$this->lang->line('remarks');?> : <?= $remarks; ?></label>
        </div>
    </div>
</div>

<?php if($reqStatus >1){ ?>

<div class="form-group">
    <div class="row">
    	<div class="col-md-6">
        	<label><?=$this->lang->line('updated-on');?> : <?= dateFormat($updatedOn); ?></label>
        </div>
    	<div class="col-md-6">
        	<label><?=$this->lang->line('updated-by');?> : <?= $updateUser; ?></label>
        </div>        
    </div>
</div>

<div class="form-group">
    <div class="row">
    	<div class="col-md-12">
        	<label><?=$this->lang->line('remarks');?> : <?= $updateRemarks; ?></label>
        </div>
    </div>
</div>

<?php } ?>

<?php } ?>

</div>
</div>
<?php } ?>