<?= form_open();$disabled=NULL;
if(!empty($receipts)){
	$uriString=NULL;
	if($this->uri->uri_to_assoc(3)){
		$uriArray = $this->uri->uri_to_assoc(3);
		$uriString = $this->uri->assoc_to_uri($uriArray);
	}

	$receiptDetails = $receipts[0];
	$bill_no = $receiptDetails['bill_no'];
	$bill_date = $receiptDetails['bill_date'];
	$customer_type_id = $receiptDetails['customer_type_id'];
	$customerID = $receiptDetails['customer_id'];
	$payment_mode = $receiptDetails['payment_mode'];
	$cash_type = $receiptDetails['cash_type'];
	$ledger_name = $receiptDetails['ledger_name'];
	$cheque_no = $receiptDetails['cheque_no'];
	$cheque_date = $receiptDetails['cheque_date'];
	$narration = $receiptDetails['narration'];
	$customerType = $this->stock->get_designation($customer_type_id);
	$customerDetails = $this->stock->get_customer($customer_type_id,$customerID,1);
	?>
    <div class="panel panel-primary">
        <div class="panel-heading">
        	<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('receipt-against-bill'); ?> </h6>
        </div>
        <div class="panel-body">

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('bill-no');?></label>
                        <?= form_input(array('name'=>'bill_no','class'=>'form-control number text-right required'),set_value('bill_no',$bill_no),"$disabled"); ?>
                        <?= form_error('bill_no');?>
                    </div>
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('bill-date');?></label>
                        <?= form_input(array('name'=>'bill_date','class'=>'form-control datepicker required'),set_value('bill_date',cdateFormat($bill_date)),"$disabled"); ?>
                        <?= form_error('bill_date');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="requiread col-md-3">
                    	<?= form_dropdown('customer_type',$customer_types,set_value('customer_type',$customer_type_id),"class='form-control customer_type required' $disabled disabled"); ?>
                    </div>
                    <div class="col-md-9">
						<?= form_dropdown('customer_id',$customers,set_value('customer_id',$customerID),"class='form-control customers' disabled"); ?>
                        <?= form_error('customer_id');?>
                    </div>
                </div>
            </div>

            <input type="hidden" name="" value="<?= $this->input->post('cbill_amt'); ?>" id="bill_amount">
            <input type="hidden" name="" value="<?= $this->input->post('cpr_amt'); ?>" id="prev_amount">
            <div class="form-group">
                <div class="row">
                    <label class="required col-md-3"><?= $this->lang->line('sales-bill'); ?></label>
                    <div class="col-md-9">
						<?= form_dropdown('customer_bill',$customer_bills,set_value('customer_bill',$customer_bill),"class='form-control customers-bills required'"); ?>
                        <?= form_error('customer_bill');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-2">
                        <label class=""><?=$this->lang->line('bill-date');?></label>
                        <?= form_input(array('name'=>'cbill_date','class'=>'form-control disabled cbill cbill_date','readonly'=>true),set_value('cbill_date'),"$disabled"); ?>
                        <?= form_error('cbill_date');?>
                    </div>
                    <div class="col-md-2">
                        <label class=""><?=$this->lang->line('bill-amount');?></label>
                        <?= form_input(array('name'=>'cbill_amt','class'=>'text-right form-control disabled cbill cbill_amount','readonly'=>true),set_value('cbill_amt'),"$disabled"); ?>
                        <?= form_error('cbill_amt');?>
                    </div>
                    <div class="col-md-2">
                        <label class=""><?=$this->lang->line('previous-receipts');?></label>
                        <?= form_input(array('name'=>'cpr_amt','class'=>'text-right form-control disabled cbill cbill_prev_amount','readonly'=>true),set_value('cpr_amt'),"$disabled"); ?>
                        <?= form_error('cpr_amt');?>
                    </div>
                    <div class="col-md-2">
                        <label class="required"><?=$this->lang->line('received-amount');?></label>
                        <?= form_input(array('name'=>'received_amount','class'=>'form-control decimal cbill received text-right required'),set_value('received_amount'),""); ?>
                        <?= form_error('received_amount');?>
                    </div>
                    <div class="col-md-2">
                        <label class=""><?=$this->lang->line('discount');?></label>
                        <?= form_input(array('name'=>'discount_amount','class'=>'form-control decimal cbill discount text-right required'),set_value('discount_amount'),""); ?>
                        <?= form_error('discount_amount');?>
                    </div>
                    <div class="col-md-2">
                        <label class=""><?=$this->lang->line('amount');?></label>
                        <?= form_input(array('name'=>'amount','class'=>'form-control decimal cbill amount text-right required'),set_value('amount'),""); ?>
                        <?= form_error('amount');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <?=form_button(array('type'=>'submit','name'=>'add_to_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('add-to-bill')));?>
                    </div>
                </div>
            </div>
			<?php if(!empty($receipts)){ ?>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <div class='table-responsive'>
                        <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                        <th>#</th>
                        <th><?= $this->lang->line('bill-no'); ?></th>
                        <th><?= $this->lang->line('bill-date'); ?></th>
                        <th><?= $this->lang->line('bill-amount'); ?></th>
                        <th><?= $this->lang->line('previous-receipts'); ?></th>
                        <th><?= $this->lang->line('received-amount'); ?></th>
                        <th><?= $this->lang->line('discount'); ?></th>
                        <th><?= $this->lang->line('balance-amount'); ?></th>
                        <th colspan="2"><?= $this->lang->line('actions'); ?></th>
                        </tr>
                        </thead>
            			<?php
						$i=0;$total_bill_amount=$total_paid_amount=$total_received_amount=$total_balance_amount=$total_discount_amount=0;
						foreach($receipts as $key=>$receipt){$i++;

							$receiptItemID= $receipt['dvabi_id'];
							$previous_receipts=$bill_amount=$received_amount=$paid_amount=0;
							$sales_bill = $this->receipt_ab_lib->get_sales_bill($receipt['ps_id']);
							$bill_amount = get_rounded($sales_bill['bill_amount']);
							$received_amount = $receipt['received_amount'];
							$receipt_discount = $receipt['discount'];
							$condition = array('dvab.bill_date <='=>$receipt['bill_date'],'dvab.bill_no <='=>$receipt['bill_no']);
							$paid_amount = $this->receipt_ab_lib->get_bill_payment($receipt['ps_id'],$condition);
							if($paid_amount >0){
								$previous_receipts = $paid_amount-$received_amount;
							}
							$total_discount_amount += $receipt_discount;
							$balance_amount = $bill_amount-($paid_amount);
							$total_bill_amount += $bill_amount;
							$total_paid_amount += $previous_receipts;
							$total_received_amount += $received_amount;
							$total_balance_amount += $balance_amount;
							?>
                            <tr>
                            <td class="text-center"><?= $i; ?></td>
                            <td><?= $receipt['sales_bill_no']; ?></td>
                            <td><?= dateFormat($receipt['sales_bill_date']); ?></td>
                            <td class="text-right"><?= numberFormat($bill_amount); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($previous_receipts)); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($received_amount)); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($receipt_discount)); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($balance_amount)); ?></td>
                            <td><a href="<?= base_url('receipt_against_bill/edit_item/'.$receiptItemID.'/'.$uriString); ?>" title="<?= $this->lang->line('edit'); ?>"><i class="glyphicon glyphicon-pencil"></i></a></td>
                            <td><a href="<?= base_url('receipt_against_bill/remove_item/'.$receiptItemID.'/'.$uriString); ?>" title="<?= $this->lang->line('remove'); ?>"><i class="glyphicon glyphicon-remove delete red"></i></a></td>
                            </tr>
                            <?php
						}?>
                        <tr>
                        <td colspan="3" class="text-right text-bold">Total</td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_bill_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_paid_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_received_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_discount_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_balance_amount)); ?></td>
                        <td colspan="2" class="disabled"></td>
                        </tr>
                        </table>
						</div>
        			</div>
    			</div>
			</div>
			<?php
            $cash_type0 = true;$cash_type1 = false;
            if($cash_type > 0){
                $cash_type1 = true;
                $cash_type0 = false;
            }
            ?>
            <div class="form-group">
                <div class="row">
                    <label class="col-md-3"><?= $this->lang->line('payment-mode'); ?></label>
                    <div class="col-md-2">
						<?= form_radio('receipt_mode','0',set_radio('receipt_mode','0',$cash_type0),'class="receipt-mode"'); ?>
                        <label><?= $this->lang->line('cash'); ?></label>
                    </div>
                    <div class="col-md-2">
						<?= form_radio('receipt_mode','1',set_radio('receipt_mode','1',$cash_type1),'class="receipt-mode"'); ?>
                        <label><?= $this->lang->line('bank'); ?></label>
                    </div>
                </div>
            </div>
			<?php
            $disPDC = 'disabled="disabled"';
            if($this->input->post('receipt_mode') && $this->input->post('receipt_mode')>0){
                $disPDC = NULL;
            }else{
                if($cash_type >0){
                    $disPDC = NULL;
                }
            }
            ?>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
						<?= form_dropdown('payment_mode',$bank_accounts,set_value('payment_mode',$payment_mode),"class='form-control payment-mode pdc' $disPDC"); ?>
                        <?= form_error('payment_mode');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-4">
                        <label><?=$this->lang->line('transaction-type');?></label>
                        <?php $transaction_types = $this->dms->transaction_types();?>
                        <?= form_dropdown('ccd',$transaction_types,set_value('ccd',$cash_type),"class='form-control pdc' $disPDC"); ?>
                        <?=form_error('ccd');?>
                    </div>
                    <div class="col-md-4">
                        <label class="pdcl"><?=$this->lang->line('cd-no');?></label>
                        <?= form_input(array('name'=>'cheque_no','class'=>'form-control pdc'),set_value('cheque_no',$cheque_no),$disPDC); ?>
                        <?= form_error('cheque_no');?>
                    </div>
                    <div class="col-md-4">
                        <label class="pdcl"><?=$this->lang->line('cheque-date');?></label>
                        <?= form_input(array('name'=>'cheque_date','class'=>'form-control pdc datepicker required'),set_value('cheque_date',cdateFormat($cheque_date)),$disPDC); ?>
                        <?= form_error('cheque_date');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <label class="col-md-3"><?= $this->lang->line('narration'); ?></label>
                    <div class="col-md-9">
						<?= form_textarea(array('name'=>'narration','class'=>'form-control','rows'=>3),set_value('narration',$narration)); ?>
                        <?= form_error('narration');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <?=form_button(array('type'=>'submit','name'=>'save','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('save')));?>
                    </div>
                </div>
            </div>
			<?php
			}
			?>
		</div>
	</div>
	<?php
}
?>
<?= form_close(); ?>
