<style>
*{	font-size:10px; line-height:1.3em;}
.pdf-head{	font-weight:bold; margin-left:auto; margin-right:auto; text-align:center;}
.data-table{	font-size:10px;}
.text-right{	text-align:right;}
.text-center{	text-align:center;}
.text-bold{	font-weight:bold;}
.vendor{ text-indent:20px;}
.data-list{	padding:2px;}
.data-list th{	font-size:10px; text-align:center; background-color:#E4E4E4; font-weight:bold;}
.data-list td{	font-size:9px;}
.disabled{background-color:#E1E1E1;}
.italic{ font-style:italic;}
</style>
<?php
if(!empty($receipts)){
	$receiptDetails = $receipts[0];
	$bill_no = $receiptDetails['bill_no'];
	$bill_date = $receiptDetails['bill_date'];
	$customer_type_id = $receiptDetails['customer_type_id'];
	$customerID = $receiptDetails['customer_id'];
	$payment_mode = $receiptDetails['payment_mode'];
	$cash_type = $receiptDetails['cash_type'];
	$ledger_name = $receiptDetails['ledger_name'];
	$cheque_no = $receiptDetails['cheque_no'];
	$cheque_date = $receiptDetails['cheque_date'];
	$narration = $receiptDetails['narration'];
	$customerType = $this->stock->get_designation($customer_type_id);
	$customerDetails = $this->stock->get_customer($customer_type_id,$customerID,1);
	?>
	<div class="pdf-head">RECEIPT VOUCHER</div>
	<table  class="data-table" border="0">
	<tr>
	<td class="text-right">
		<span class="text-bold">Voucher. No. : </span><?= $bill_no; ?><br/>
		<span class="text-bold">Date : </span><?= dateFormat($bill_date); ?>
	</td>
	</tr>
	<tr><td>To ,</td></tr>
	<tr><td class="vendor text-bold"><?= $customerDetails['name']; ?></td></tr>
	<tr>
	<td class="vendor"><?= $customerDetails['address']; ?><?= (!empty($customerDetails['email_id']))?' , Email : '.$customerDetails['email_id']:''; ?></td></tr>
	<tr><td class="vendor"><?= (!empty($customerDetails['mobile_no']))?'Mob : '.$customerDetails['mobile_no']:''; ?><?= (!empty($customerDetails['phone_no']))? ' , Ph : '.$customerDetails['phone_no']:''; ?></td>
	</tr>
	</table>
	<div></div>
	<?php if(!empty($receipts)){ ?>
        <table class="table data-table data-list" border="1" width="100%">
        <thead>
        <tr>
        <th width="5%">#</th>
        <th width="10%">Bill No.</th>
        <th width="10%">Bill Date</th>
        <th width="20%">Bill Amount</th>
        <th width="15%">Previous Receipts</th>
        <th width="15%">Amount</th>
        <th width="10%">Discount</th>
        <th width="15%">Net Amount</th>
        </tr>
        </thead>
		<?php
        $i=0;$total_bill_amount=$total_paid_amount=$total_received_amount=$total_balance_amount=$total_discount_amount=$grand_total=0;
        foreach($receipts as $key=>$receipt){$i++;

			$previous_receipts=$bill_amount=$received_amount=$paid_amount=0;
			$sales_bill = $this->receipt_ab_lib->get_sales_bill($receipt['ps_id']);
			$bill_amount = get_rounded($sales_bill['bill_amount']);

			$received_amount = $receipt['received_amount'];
			$receipt_discount = $receipt['discount'];
			$condition = array('dvab.bill_date <='=>$receipt['bill_date'],'dvab.bill_no <='=>$receipt['bill_no']);
			$paid_amount = $this->receipt_ab_lib->get_bill_payment($receipt['ps_id'],$condition);
			if($paid_amount >0){
				$previous_receipts = $paid_amount-$received_amount;
			}
			$balance_amount = $bill_amount-($paid_amount);
			$total = $received_amount-$receipt_discount;
			$grand_total += $total;
			$total_discount_amount += $receipt_discount;
			$total_bill_amount += $bill_amount;
			$total_paid_amount += $previous_receipts;
			$total_received_amount += $received_amount;
			$total_balance_amount += $balance_amount;
			?>
            <tr>
            <td width="5%" class="text-center"><?= $i; ?></td>
            <td width="10%"><?= $receipt['sales_bill_no']; ?></td>
            <td width="10%" class="text-center"><?= dateFormat($receipt['sales_bill_date']); ?></td>
            <td width="20%" class="text-right"><?= numberFormat($bill_amount); ?></td>
            <td width="15%" class="text-right"><?= numberFormat(round_this($previous_receipts)); ?></td>
            <td width="15%" class="text-right"><?= numberFormat(round_this($received_amount)); ?></td>
            <td width="10%" class="text-right"><?= numberFormat(round_this($receipt_discount)); ?></td>
            <td width="15%" class="text-right"><?= numberFormat(round_this($total)); ?></td>
            </tr>
            <?php
		}?>
        <tr>
        <td colspan="3" class="text-right text-bold">Total</td>
        <td class="text-right text-bold"><?= numberFormat(round_this($total_bill_amount)); ?></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($total_paid_amount)); ?></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($total_received_amount)); ?></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($total_discount_amount)); ?></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($grand_total)); ?></td>
        </tr>
        </table>
		<?php
		$cashType = "CASH";
		if($cash_type == 0){$ledger_name = NULL;}else{$cashType = "BANK";}
		?>
        <div class="text-right italic">
        	<?= $this->to_words->num_to_words(round_this($grand_total)); ?>
        </div>
		<br>
        <table border="0">
        <tr>
        <td colspan="2">Payment Mode</td>
        <td colspan="7">: <?= $cashType; ?></td>
        </tr>
        <?php if($cash_type > 0){$transaction_types = $this->dms->transaction_types();?>
        <tr>
        <td colspan="2">Transaction Type</td>
        <td colspan="7">: <?= $transaction_types[$cash_type]; ?></td>
        </tr>
        <tr>
        <td colspan="2">Transaction No </td>
        <td colspan="4">: <?= $cheque_no; ?></td>
        <td>Date</td>
        <td colspan="2">: <?= dateFormat($cheque_date); ?></td>
        </tr>
        <tr>
        <td colspan="2">Bank</td>
        <td colspan="7">: <?= $ledger_name; ?></td>
        </tr>
        <?php }?>
        </table>
		<br>
        <div><label>Narration :</label><label><?= $narration; ?></label></div>
        <div class="text-right text-bold">Authorised Signatory.</div>
		<?php
	}
}
?>