<?php if(!empty($receipts)){ ?>
    <div class="panel panel-primary">
        <div class="panel-heading">
            <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('receipt-against-bill-report'); ?> </h6>
        </div>
		<div class="panel-body">
		<?php
        $uriString=NULL;
        if($this->uri->uri_to_assoc(3)){
            $uriArray = $this->uri->uri_to_assoc(3);
            $uriString = $this->uri->assoc_to_uri($uriArray);
        }else{
            $uriString = $from_date.'/'.$to_date;
        }
        ?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-12"><?= export_to_excel('receipt_against_bill/excel/'.$from_date.'/'.$to_date); ?></div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class='table-responsive'>
                    <table class="table table-bordered table-striped">
                    <thead>
                    <tr class="bg-success">
                    <th>#</th>
                    <th><?= $this->lang->line('bill-no'); ?></th>
                    <th><?= $this->lang->line('bill-date'); ?></th>
                    <th><?= $this->lang->line('bill-amount'); ?></th>
                    <th><?= $this->lang->line('customer'); ?></th>
                    <th><?= $this->lang->line('narration'); ?></th>
                    <th colspan="4"><?= $this->lang->line('actions'); ?></th>
                    </tr>
                    </thead>
            		<?php
					foreach($receipts as $key=>$receipt){

						$receiptID= $receipt['id'];
						$custTypeID = $receipt['customer_type_id'];
						$customerID = $receipt['customer_id'];
						$customer_name= $this->stock->get_customer($custTypeID,$customerID);
						?>
                        <tr>
                        <td class="text-center"><?= $count++; ?></td>
                        <td><?= $receipt['bill_no']; ?></td>
                        <td><?= dateFormat($receipt['bill_date']); ?></td>
                        <td class="text-right"><?= numberFormat(get_rounded($receipt['amount'])); ?></td>
                        <td><?= $customer_name;?></td>
                        <td><?= $receipt['narration']; ?></td>
                        <?= app_table_links($receiptID.'/'.$uriString,array(384,385,386,387)); ?>
                        </tr>
						<?php
					}
					?>
                    </table>
                    </div>
				</div>
			</div>
		</div>

        <div class="row">
        	<div class="col-md-12">
            	<div class="pagination"><?= $links; ?></div>
            </div>
        </div>
	</div>
</div>
<?php } ?>