<?= form_open();$disabled=NULL;
$bill_date = date('Y-m-d');
if(!empty($receipt_bill_items)){
	$bill_num = $receipt_bill_items[0]['bill_no'];
	$bill_date = $receipt_bill_items[0]['bill_date'];
	$customer_id = $receipt_bill_items[0]['customer_id'];
	$disabled = 'disabled';
}
?>
<div class="panel panel-primary">
    <div class="panel-heading">
        <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('receipt-against-bill'); ?> </h6>
    </div>
	<div class="panel-body">

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
                    <?= form_input(array('name'=>'bill_no','class'=>'form-control number text-right required'),set_value('bill_no',$bill_num)); ?>
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
                    <?= form_input(array('name'=>'bill_date','class'=>'form-control datepicker required'),set_value('bill_date',cdateFormat($bill_date)),"$disabled"); ?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>
    
        <div class="form-group">
            <div class="row">
                <div class="requiread col-md-3">
                	<?= form_dropdown('customer_type',$customer_types,set_value('customer_type',$cust_type),"class='form-control customer_type required' $disabled"); ?>
                </div>
                <div class="col-md-9">
					<?= form_dropdown('customer_id',$customers,set_value('customer_id',$customer_id),"class='form-control customers' $disabled"); ?>
                    <?= form_error('customer_id');?>
                </div>
            </div>
        </div>

        <input type="hidden" name="" value="<?= $this->input->post('cbill_amt'); ?>" id="bill_amount">
        <input type="hidden" name="" value="<?= $this->input->post('cpr_amt'); ?>" id="prev_amount"> 
        <div class="form-group">
            <div class="row">
                <label class="required col-md-3"><?= $this->lang->line('sales-bill'); ?></label>
                <div class="col-md-9">
					<?= form_dropdown('customer_bill',$customer_bills,set_value('customer_bill',$customer_bill),"class='form-control customers-bills required'"); ?>
                    <?= form_error('customer_bill');?>
                </div>
            </div>
        </div>
    
        <div class="form-group">
            <div class="row">
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('bill-date');?></label>
                    <?= form_input(array('name'=>'cbill_date','class'=>'form-control disabled cbill cbill_date','readonly'=>true),set_value('cbill_date'),"$disabled"); ?>
                    <?= form_error('cbill_date');?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('bill-amount');?></label>
                    <?= form_input(array('name'=>'cbill_amt','class'=>'text-right form-control disabled cbill cbill_amount','readonly'=>true),set_value('cbill_amt'),"$disabled"); ?>
                    <?= form_error('cbill_amt');?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('previous-receipts');?></label>
                    <?= form_input(array('name'=>'cpr_amt','class'=>'text-right form-control disabled cbill cbill_prev_amount','readonly'=>true),set_value('cpr_amt'),"$disabled"); ?>
                    <?= form_error('cpr_amt');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('received-amount');?></label>
                    <?= form_input(array('name'=>'received_amount','class'=>'form-control decimal cbill received text-right required'),set_value('received_amount'),""); ?>
                    <?= form_error('received_amount');?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?></label>
                    <?= form_input(array('name'=>'discount_amount','class'=>'form-control decimal cbill discount text-right required'),set_value('discount_amount'),""); ?>
                    <?= form_error('discount_amount');?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control decimal cbill amount text-right required'),set_value('amount'),""); ?>
                    <?= form_error('amount');?>
                </div>
            </div>
        </div>
    
        <div class="form-group">
            <div class="row">
                <div class="col-md-12">
                    <?=form_button(array('type'=>'submit','name'=>'add_to_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('add-to-bill')));?>
                </div>
            </div>
        </div>

		<?php if(!empty($receipt_bill_items)){ ?>

        <div class="form-group">
            <div class="row">
                <div class="col-md-12">
                    <div class='table-responsive'>
                    <table class="table table-bordered table-striped">
                    <thead>
                    <tr class="bg-success">
                    <th>#</th>
                    <th><?= $this->lang->line('bill-no'); ?></th>
                    <th><?= $this->lang->line('bill-date'); ?></th>
                    <th><?= $this->lang->line('bill-amount'); ?></th>
                    <th><?= $this->lang->line('previous-receipts'); ?></th>
                    <th><?= $this->lang->line('received-amount'); ?></th>
                    <th><?= $this->lang->line('discount'); ?></th>
                    <th><?= $this->lang->line('net-amount'); ?></th>
                    <th><?= $this->lang->line('balance-amount'); ?></th>
                    <th><?= $this->lang->line('actions'); ?></th>
                    </tr>
                    </thead>
            		<?php
					$i=0;$total_bill_amount=$total_paid_amount=$total_received_amount=$total_balance_amount=$total_discount_amount= $total_net_amount=0;
					foreach($receipt_bill_items as $key=>$receipt_item){$i++;
						$previous_receipts=$bill_amount=$received_amount=$paid_amount=$net_amount= 0;
						$sales_bill = $this->receipt_ab_lib->get_sales_bill($receipt_item['ps_id']);
						$bill_amount = get_rounded($sales_bill['bill_amount']);
						$received_amount = $receipt_item['received_amount'];
						$discount_amount = $receipt_item['discount'];
						$paid_amount = $this->receipt_ab_lib->get_bill_payment($receipt_item['ps_id']);
						if($paid_amount >0){
							$previous_receipts = $paid_amount-$received_amount;
						}
						$net_amount = $received_amount-$discount_amount;
						$balance_amount = $bill_amount-($paid_amount);
						$total_net_amount += $net_amount;
						$total_discount_amount +=$discount_amount;
						$total_bill_amount += $bill_amount;
						$total_paid_amount += $previous_receipts;
						$total_received_amount += $received_amount;
						$total_balance_amount += $balance_amount;
						?>
                        <tr>
                        <td class="text-center"><?= $i; ?></td>
                        <td><?= $receipt_item['sales_bill_no']; ?></td>
                        <td><?= dateFormat($receipt_item['sales_bill_date']); ?></td>
                        <td class="text-right"><?= numberFormat($bill_amount); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($previous_receipts)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($received_amount)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($discount_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($net_amount)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($balance_amount)); ?></td>
                        <td class="text-center"><a href="<?= base_url('receipt_against_bill/remove_temp_item/'.$receipt_item['dvabi_id']); ?>" title="<?= $this->lang->line('remove'); ?>"><i class="glyphicon glyphicon-remove delete"></i></a></td>
                        </tr>
                        <?php
					}?>
                    <tr>
                    <td colspan="3" class="text-right text-bold">Total</td>
                    <td class="text-right"><?= numberFormat(round_this($total_bill_amount)); ?></td>
                    <td class="text-right"><?= numberFormat(round_this($total_paid_amount)); ?></td>
                    <td class="text-right"><?= numberFormat(round_this($total_received_amount)); ?></td>
                    <td class="text-right"><?= numberFormat(round_this($total_discount_amount)); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($total_net_amount)); ?></td>
                    <td class="text-right"><?= numberFormat(round_this($total_balance_amount)); ?></td>
                    <td></td>
                    </tr>
                    </table>       
					</div>
        		</div>
    		</div>
		</div>

        <div class="form-group">
            <div class="row">
                <label class="required col-md-3"><?= $this->lang->line('payment-mode'); ?></label>
                <div class="col-md-2">
                    <?= form_radio('receipt_mode','0',set_radio('receipt_mode','0',true),'class="receipt-mode"'); ?>
                    <label><?= $this->lang->line('cash'); ?></label>
                </div>
                <div class="col-md-2">
                    <?= form_radio('receipt_mode','1',set_radio('receipt_mode','1'),'class="receipt-mode"'); ?>
                    <label><?= $this->lang->line('cheque'); ?></label>
                </div>
                <div class="col-md-2">
                    <?= form_radio('receipt_mode','2',set_radio('receipt_mode','2'),'class="receipt-mode"'); ?>
                    <label><?= $this->lang->line('dd'); ?></label>
                </div>
                <?= form_error('receipt_mode'); ?>
            </div>
        </div>

		<?php
        $disPDC = 'disabled="disabled"';
        if($this->input->post('receipt_mode') && $this->input->post('receipt_mode')>0){
            $disPDC = NULL;
        }
        ?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-12">
					<?= form_dropdown('payment_mode',$bank_accounts,set_value('payment_mode',$bank),"class='form-control payment-mode pdc' $disPDC"); ?>
                    <?= form_error('payment_mode');?>
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="pdcl"><?=$this->lang->line('cd-no');?></label>
                    <?= form_input(array('name'=>'cheque_no','class'=>'form-control pdc'),set_value('cheque_no'),$disPDC); ?>
                    <?= form_error('cheque_no');?>
                </div>
                <div class="col-md-6">
                    <label class="pdcl"><?=$this->lang->line('cheque-date');?></label>
                    <?= form_input(array('name'=>'cheque_date','class'=>'form-control pdc datepicker required'),set_value('cheque_date'),$disPDC); ?>
                    <?= form_error('cheque_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <label class=" col-md-3"><?= $this->lang->line('narration'); ?></label>
                <div class="col-md-9">
					<?= form_textarea(array('name'=>'narration','class'=>'form-control','rows'=>3),set_value('narration')); ?>
                    <?= form_error('narration');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-12">
                    <?=form_button(array('type'=>'submit','name'=>'save','class'=>'btn btn-primary pull-right btn-loading','content'=>$this->lang->line('save')));?>
                </div>
            </div>
        </div>
		<?php } ?>    
	</div>
</div>   
<?= form_close(); ?>