<?= form_open();$disabled='disabled';
if(!empty($receipts)){
	$receiptDetails = $receipts[0];
	$receiptID = $receiptDetails['id'];
	$bill_no = $receiptDetails['bill_no'];
	$bill_date = $receiptDetails['bill_date'];
	$customer_type_id = $receiptDetails['customer_type_id'];
	$customerID = $receiptDetails['customer_id'];
	$payment_mode = $receiptDetails['payment_mode'];
	$cash_type = $receiptDetails['cash_type'];
	$ledger_name = $receiptDetails['ledger_name'];
	$cheque_no = $receiptDetails['cheque_no'];
	$cheque_date = $receiptDetails['cheque_date'];
	$narration = $receiptDetails['narration'];
	$customerType = $this->stock->get_designation($customer_type_id);
	$customerDetails = $this->stock->get_customer($customer_type_id,$customerID,1);
	$uriString=NULL;
	if($this->uri->uri_to_assoc(3)){
		$uriArray = $this->uri->uri_to_assoc(3);
		$uriString = $this->uri->assoc_to_uri($uriArray);
	}else{
		$uriString = $from_date.'/'.$to_date;
	}
	?>    
	<div class="panel panel-primary">
        <div class="panel-heading">
        	<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('receipt-against-bill'); ?> </h6>
        </div>
		<div class="panel-body">

			<div class="row">
            	<div class="col-md-12">
                	<?= app_export_menus($receiptID.'/'.$uriString,array(387)); ?>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('bill-no');?></label>
                        <?= form_input(array('name'=>'bill_no','class'=>'form-control number text-right required'),set_value('bill_no',$bill_no),"$disabled"); ?>
                        <?= form_error('bill_no');?>
                    </div>
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('bill-date');?></label>
                        <?= form_input(array('name'=>'bill_date','class'=>'form-control datepicker required'),set_value('bill_date',cdateFormat($bill_date)),"$disabled"); ?>
                        <?= form_error('bill_date');?>
                    </div>
                </div>
            </div>
    
            <div class="form-group">
                <div class="row">
                    <div class="requiread col-md-3">
                    	<label><?= $customerType; ?></label>
                    </div>
                    <div class="col-md-9 ">
                    	<div class="text-bold"><?= $customerDetails['name']; ?></div>
                    	<div><?= $customerDetails['address']; ?></div>
                    	<div><?= $customerDetails['mobile_no']; ?> <?= $customerDetails['phone_no']; ?> <?= $customerDetails['email_id']; ?></div>
                    </div>
                </div>
            </div>
    
			<?php if(!empty($receipts)){ ?>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <div class='table-responsive'>
                        <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                        <th>#</th>
                        <th><?= $this->lang->line('bill-no'); ?></th>
                        <th><?= $this->lang->line('bill-date'); ?></th>
                        <th><?= $this->lang->line('bill-amount'); ?></th>
                        <th><?= $this->lang->line('previous-receipts'); ?></th>
                        <th><?= $this->lang->line('received-amount'); ?></th>
                        <th><?= $this->lang->line('discount'); ?></th>
                        <th><?= $this->lang->line('net-amount'); ?></th>
                        <th><?= $this->lang->line('balance-amount'); ?></th>
                        </tr>
                        </thead>
            			<?php
						$i=0;$total_bill_amount=$total_paid_amount=$total_received_amount=$total_balance_amount=$total_discount_amount=$total_net_amount=0;
						foreach($receipts as $key=>$receipt){$i++;
							$previous_receipts=$bill_amount=$received_amount=$paid_amount=$net_amount=0;
							$sales_bill = $this->receipt_ab_lib->get_sales_bill($receipt['ps_id']);
							$bill_amount = get_rounded($sales_bill['bill_amount']);		

							$received_amount = $receipt['received_amount'];
							$receipt_discount = $receipt['discount'];
							$condition = array('dvab.bill_date <='=>$receipt['bill_date'],'dvab.bill_no <='=>$receipt['bill_no']);
							$paid_amount = $this->receipt_ab_lib->get_bill_payment($receipt['ps_id'],$condition);
							if($paid_amount >0){
								$previous_receipts = $paid_amount-$received_amount;
							}
							$balance_amount = $bill_amount-($paid_amount);
							$net_amount = $received_amount-$receipt_discount;

							$total_net_amount += $net_amount;
							$total_discount_amount += $receipt_discount;
							$total_bill_amount += $bill_amount;
							$total_paid_amount += $previous_receipts;
							$total_received_amount += $received_amount;
							$total_balance_amount += $balance_amount;					
							?>
                            <tr>
                            <td class="text-center"><?= $i; ?></td>
                            <td><?= $receipt['sales_bill_no']; ?></td>
                            <td><?= dateFormat($receipt['sales_bill_date']); ?></td>
                            <td class="text-right"><?= numberFormat($bill_amount); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($previous_receipts)); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($received_amount)); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($receipt_discount)); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($net_amount)); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($balance_amount)); ?></td>
                            </tr>
                            <?php
						}?>
                        <tr>
                        <td colspan="3" class="text-right text-bold">Total</td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_bill_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_paid_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_received_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_discount_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_net_amount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($total_balance_amount)); ?></td>
                        </tr>            
                        </table>       
                        </div>
        			</div>
    			</div>
			</div>
			<?php
            $cash_type0=$cash_type1=$cash_type2=false;
            $ctype = 'cash_type'.$cash_type;
            $$ctype=true;
            ?>
            <div class="form-group">
                <div class="row">
                    <label class="col-md-3"><?= $this->lang->line('payment-mode'); ?></label>
                    <div class="col-md-2">
                        <?= form_radio('receipt_mode','0',set_radio('receipt_mode','0',$cash_type0),'class="receipt-mode"'); ?>
                        <label><?= $this->lang->line('cash'); ?></label>
                    </div>
                    <div class="col-md-2">
                        <?= form_radio('receipt_mode','1',set_radio('receipt_mode','1',$cash_type1),'class="receipt-mode"'); ?>
                        <label><?= $this->lang->line('cheque'); ?></label>
                    </div>
                    <div class="col-md-2">
                        <?= form_radio('receipt_mode','2',set_radio('receipt_mode','2',$cash_type2),'class="receipt-mode"'); ?>
                        <label><?= $this->lang->line('dd'); ?></label>
                    </div>
                </div>
            </div>

			<?php
			$disPDC = 'disabled="disabled"';
			if($this->input->post('receipt_mode') && $this->input->post('receipt_mode')>0){
				$disPDC = NULL;
			}
			if($cash_type == 0){$ledger_name = NULL;}
			?>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
						<?= form_input(array('name'=>'bank','class'=>'form-control'),set_value('',$ledger_name),$disPDC); ?>
                        <?= form_error('payment_mode');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label class="pdcl"><?=$this->lang->line('cd-no');?></label>
                        <?= form_input(array('name'=>'cheque_no','class'=>'form-control number pdc'),set_value('cheque_no',$cheque_no),$disPDC); ?>
                        <?= form_error('cheque_no');?>
                    </div>
                    <div class="col-md-6">
                        <label class="pdcl"><?=$this->lang->line('cheque-date');?></label>
                        <?= form_input(array('name'=>'cheque_date','class'=>'form-control pdc required'),set_value('cheque_date',cdateFormat($cheque_date)),$disPDC); ?>
                        <?= form_error('cheque_date');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <label class="col-md-3"><?= $this->lang->line('narration'); ?></label>
                    <div class="col-md-9">
						<?= form_textarea(array('name'=>'narration','class'=>'form-control','rows'=>3),set_value('narration',$narration),$disPDC); ?>
                        <?= form_error('narration');?>
                    </div>
                </div>
            </div>

			<?php 
			}
			?>
		</div>
	</div>            
	<?php
}
?>    
<?= form_close(); ?>